/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.TypeParameterNode;
import java.util.Objects;

public class ParameterizedTypeDescriptorNode
extends TypeDescriptorNode {
    public ParameterizedTypeDescriptorNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token parameterizedType() {
        return (Token)this.childInBucket(0);
    }

    public TypeParameterNode typeParameter() {
        return (TypeParameterNode)this.childInBucket(1);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"parameterizedType", "typeParameter"};
    }

    public ParameterizedTypeDescriptorNode modify(Token parameterizedType, TypeParameterNode typeParameter) {
        if (this.checkForReferenceEquality(parameterizedType, typeParameter)) {
            return this;
        }
        return NodeFactory.createParameterizedTypeDescriptorNode(parameterizedType, typeParameter);
    }

    public ParameterizedTypeDescriptorNodeModifier modify() {
        return new ParameterizedTypeDescriptorNodeModifier(this);
    }

    public static class ParameterizedTypeDescriptorNodeModifier {
        private final ParameterizedTypeDescriptorNode oldNode;
        private Token parameterizedType;
        private TypeParameterNode typeParameter;

        public ParameterizedTypeDescriptorNodeModifier(ParameterizedTypeDescriptorNode oldNode) {
            this.oldNode = oldNode;
            this.parameterizedType = oldNode.parameterizedType();
            this.typeParameter = oldNode.typeParameter();
        }

        public ParameterizedTypeDescriptorNodeModifier withParameterizedType(Token parameterizedType) {
            Objects.requireNonNull(parameterizedType, "parameterizedType must not be null");
            this.parameterizedType = parameterizedType;
            return this;
        }

        public ParameterizedTypeDescriptorNodeModifier withTypeParameter(TypeParameterNode typeParameter) {
            Objects.requireNonNull(typeParameter, "typeParameter must not be null");
            this.typeParameter = typeParameter;
            return this;
        }

        public ParameterizedTypeDescriptorNode apply() {
            return this.oldNode.modify(this.parameterizedType, this.typeParameter);
        }
    }
}

