/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.NameReferenceNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class QualifiedNameReferenceNode
extends NameReferenceNode {
    public QualifiedNameReferenceNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token modulePrefix() {
        return (Token)this.childInBucket(0);
    }

    public Node colon() {
        return this.childInBucket(1);
    }

    public IdentifierToken identifier() {
        return (IdentifierToken)this.childInBucket(2);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"modulePrefix", "colon", "identifier"};
    }

    public QualifiedNameReferenceNode modify(Token modulePrefix, Node colon, IdentifierToken identifier) {
        if (this.checkForReferenceEquality(modulePrefix, colon, identifier)) {
            return this;
        }
        return NodeFactory.createQualifiedNameReferenceNode(modulePrefix, colon, identifier);
    }

    public QualifiedNameReferenceNodeModifier modify() {
        return new QualifiedNameReferenceNodeModifier(this);
    }

    public static class QualifiedNameReferenceNodeModifier {
        private final QualifiedNameReferenceNode oldNode;
        private Token modulePrefix;
        private Node colon;
        private IdentifierToken identifier;

        public QualifiedNameReferenceNodeModifier(QualifiedNameReferenceNode oldNode) {
            this.oldNode = oldNode;
            this.modulePrefix = oldNode.modulePrefix();
            this.colon = oldNode.colon();
            this.identifier = oldNode.identifier();
        }

        public QualifiedNameReferenceNodeModifier withModulePrefix(Token modulePrefix) {
            Objects.requireNonNull(modulePrefix, "modulePrefix must not be null");
            this.modulePrefix = modulePrefix;
            return this;
        }

        public QualifiedNameReferenceNodeModifier withColon(Node colon) {
            Objects.requireNonNull(colon, "colon must not be null");
            this.colon = colon;
            return this;
        }

        public QualifiedNameReferenceNodeModifier withIdentifier(IdentifierToken identifier) {
            Objects.requireNonNull(identifier, "identifier must not be null");
            this.identifier = identifier;
            return this;
        }

        public QualifiedNameReferenceNode apply() {
            return this.oldNode.modify(this.modulePrefix, this.colon, this.identifier);
        }
    }
}

