/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import io.ballerina.projects.DependencyGraph;
import io.ballerina.projects.Document;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.Module;
import io.ballerina.projects.ModuleDependency;
import io.ballerina.projects.ModuleId;
import io.ballerina.projects.Package;
import io.ballerina.projects.PackageContext;
import io.ballerina.projects.PackageDependencyScope;
import io.ballerina.projects.PackageManifest;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.ResolvedPackageDependency;
import io.ballerina.projects.environment.PackageCache;
import io.ballerina.projects.internal.balo.BaloJson;
import io.ballerina.projects.internal.balo.DependencyGraphJson;
import io.ballerina.projects.internal.balo.PackageJson;
import io.ballerina.projects.internal.balo.adaptors.JsonCollectionsAdaptor;
import io.ballerina.projects.internal.balo.adaptors.JsonStringsAdaptor;
import io.ballerina.projects.internal.model.Dependency;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.ballerinalang.compiler.BLangCompilerException;

public abstract class BaloWriter {
    private static final String MODULES_ROOT = "modules";
    private static final String RESOURCE_DIR_NAME = "resources";
    private static final String BLANG_SOURCE_EXT = ".bal";
    protected static final String PLATFORM = "platform";
    protected static final String DEPENDENCY = "dependency";
    protected static final String PATH = "path";
    protected String target = "any";
    protected String langSpecVersion = "2020r2";
    protected String ballerinaVersion = "Ballerina 2.0.0";
    protected String implemetationVendor = "WSO2";

    protected BaloWriter() {
    }

    public void write(Package pkg, Path baloPath) {
        try (ZipOutputStream baloOutputStream = new ZipOutputStream(new FileOutputStream(String.valueOf(baloPath)));){
            this.populateBaloArchive(baloOutputStream, pkg);
        }
        catch (IOException e) {
            throw new ProjectException("Failed to create balo :" + e.getMessage(), e);
        }
        catch (BLangCompilerException be) {
            try {
                Files.delete(baloPath);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw be;
        }
    }

    private void populateBaloArchive(ZipOutputStream baloOutputStream, Package pkg) throws IOException {
        this.addBaloJson(baloOutputStream);
        this.addPackageDoc(baloOutputStream, pkg.project().sourceRoot(), pkg.packageName().toString());
        this.addPackageSource(baloOutputStream, pkg);
        Optional<JsonArray> platformLibs = this.addPlatformLibs(baloOutputStream, pkg);
        this.addPackageJson(baloOutputStream, pkg, platformLibs);
        this.addDependenciesJson(baloOutputStream, pkg);
    }

    private void addBaloJson(ZipOutputStream baloOutputStream) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String baloJson = gson.toJson(new BaloJson());
        try {
            this.putZipEntry(baloOutputStream, Paths.get("balo.json", new String[0]), new ByteArrayInputStream(baloJson.getBytes(Charset.defaultCharset())));
        }
        catch (IOException e) {
            throw new ProjectException("Failed to write 'balo.json' file: " + e.getMessage(), e);
        }
    }

    private void addPackageJson(ZipOutputStream baloOutputStream, Package pkg, Optional<JsonArray> platformLibs) {
        PackageJson packageJson = new PackageJson(pkg.packageOrg().toString(), pkg.packageName().toString(), pkg.packageVersion().toString());
        PackageManifest packageManifest = pkg.manifest();
        packageJson.setLicenses((List)packageManifest.getValue("license"));
        packageJson.setAuthors((List)packageManifest.getValue("authors"));
        packageJson.setSourceRepository((String)packageManifest.getValue("repository"));
        packageJson.setKeywords((List)packageManifest.getValue("keywords"));
        packageJson.setPlatform(this.target);
        packageJson.setLanguageSpecVersion(this.langSpecVersion);
        packageJson.setBallerinaVersion(this.ballerinaVersion);
        packageJson.setImplementationVendor(this.implemetationVendor);
        if (!platformLibs.isEmpty()) {
            packageJson.setPlatformDependencies(platformLibs.get());
        }
        Gson gson = new GsonBuilder().registerTypeHierarchyAdapter(Collection.class, new JsonCollectionsAdaptor()).registerTypeHierarchyAdapter(String.class, new JsonStringsAdaptor()).setPrettyPrinting().create();
        try {
            this.putZipEntry(baloOutputStream, Paths.get("package.json", new String[0]), new ByteArrayInputStream(gson.toJson(packageJson).getBytes(Charset.defaultCharset())));
        }
        catch (IOException e) {
            throw new ProjectException("Failed to write 'package.json' file: " + e.getMessage(), e);
        }
    }

    private void addPackageDoc(ZipOutputStream baloOutputStream, Path packageSourceDir, String pkgName) throws IOException {
        File modulesSourceDir;
        File[] directoryListing;
        String packageMdFileName = "Package.md";
        String moduleMdFileName = "Module.md";
        Path packageMd = packageSourceDir.resolve("Package.md");
        Path docsDirInBalo = Paths.get("docs", new String[0]);
        if (packageMd.toFile().exists()) {
            Path packageMdInBalo = docsDirInBalo.resolve("Package.md");
            this.putZipEntry(baloOutputStream, packageMdInBalo, new FileInputStream(String.valueOf(packageMd)));
        }
        Path defaultModuleMd = packageSourceDir.resolve("Module.md");
        Path modulesDirInBaloDocs = docsDirInBalo.resolve(MODULES_ROOT);
        if (defaultModuleMd.toFile().exists()) {
            Path defaultModuleMdInBaloDocs = modulesDirInBaloDocs.resolve(pkgName).resolve("Module.md");
            this.putZipEntry(baloOutputStream, defaultModuleMdInBaloDocs, new FileInputStream(String.valueOf(defaultModuleMd)));
        }
        if ((directoryListing = (modulesSourceDir = new File(String.valueOf(packageSourceDir.resolve(MODULES_ROOT)))).listFiles()) != null) {
            for (File moduleDir : directoryListing) {
                Path otherModuleMd;
                if (!moduleDir.isDirectory() || !(otherModuleMd = packageSourceDir.resolve(MODULES_ROOT).resolve(moduleDir.getName()).resolve("Module.md")).toFile().exists()) continue;
                Path otherModuleMdInBaloDocs = modulesDirInBaloDocs.resolve(pkgName + "." + moduleDir.getName()).resolve("Module.md");
                this.putZipEntry(baloOutputStream, otherModuleMdInBaloDocs, new FileInputStream(String.valueOf(otherModuleMd)));
            }
        }
    }

    private void addPackageSource(ZipOutputStream baloOutputStream, Package pkg) throws IOException {
        for (ModuleId moduleId : pkg.moduleIds()) {
            Module module = pkg.module(moduleId);
            Path moduleRoot = pkg.project().sourceRoot();
            if (module.moduleName() != pkg.getDefaultModule().moduleName()) {
                moduleRoot = moduleRoot.resolve(MODULES_ROOT).resolve(module.moduleName().moduleNamePart());
            }
            Path resourcesPathInBalo = Paths.get(MODULES_ROOT, module.moduleName().toString(), RESOURCE_DIR_NAME);
            this.putDirectoryToZipFile(moduleRoot.resolve(RESOURCE_DIR_NAME), resourcesPathInBalo, baloOutputStream);
            for (DocumentId docId : module.documentIds()) {
                Document document = module.document(docId);
                if (!document.name().endsWith(BLANG_SOURCE_EXT)) continue;
                Path documentPath = Paths.get(MODULES_ROOT, module.moduleName().toString(), document.name());
                char[] documentContent = document.textDocument().toCharArray();
                this.putZipEntry(baloOutputStream, documentPath, new ByteArrayInputStream(new String(documentContent).getBytes(StandardCharsets.UTF_8)));
            }
        }
    }

    private void addDependenciesJson(ZipOutputStream baloOutputStream, Package pkg) {
        PackageCache packageCache = pkg.project().projectEnvironmentContext().getService(PackageCache.class);
        List<Dependency> packageDependencyGraph = this.getPackageDependencies(pkg.getResolution().dependencyGraph());
        List<io.ballerina.projects.internal.balo.ModuleDependency> moduleDependencyGraph = this.getModuleDependencies(pkg, packageCache);
        DependencyGraphJson depGraphJson = new DependencyGraphJson(packageDependencyGraph, moduleDependencyGraph);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try {
            this.putZipEntry(baloOutputStream, Paths.get("dependency-graph.json", new String[0]), new ByteArrayInputStream(gson.toJson(depGraphJson).getBytes(Charset.defaultCharset())));
        }
        catch (IOException e) {
            throw new ProjectException("Failed to write 'dependency-graph.json' file: " + e.getMessage(), e);
        }
    }

    private List<Dependency> getPackageDependencies(DependencyGraph<ResolvedPackageDependency> dependencyGraph) {
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        for (ResolvedPackageDependency resolvedDep : dependencyGraph.getNodes()) {
            if (resolvedDep.scope() == PackageDependencyScope.TEST_ONLY) continue;
            PackageContext packageContext = resolvedDep.packageInstance().packageContext();
            Dependency dependency = new Dependency(packageContext.packageOrg().toString(), packageContext.packageName().toString(), packageContext.packageVersion().toString());
            ArrayList<Dependency> dependencyList = new ArrayList<Dependency>();
            Collection<ResolvedPackageDependency> pkgDependencies = dependencyGraph.getDirectDependencies(resolvedDep);
            for (ResolvedPackageDependency resolvedTransitiveDep : pkgDependencies) {
                if (resolvedTransitiveDep.scope() == PackageDependencyScope.TEST_ONLY) continue;
                PackageContext dependencyPkgContext = resolvedTransitiveDep.packageInstance().packageContext();
                Dependency dep = new Dependency(dependencyPkgContext.packageOrg().toString(), dependencyPkgContext.packageName().toString(), dependencyPkgContext.packageVersion().toString());
                dependencyList.add(dep);
            }
            dependency.setDependencies(dependencyList);
            dependencies.add(dependency);
        }
        return dependencies;
    }

    private List<io.ballerina.projects.internal.balo.ModuleDependency> getModuleDependencies(Package pkg, PackageCache packageCache) {
        ArrayList<io.ballerina.projects.internal.balo.ModuleDependency> modules = new ArrayList<io.ballerina.projects.internal.balo.ModuleDependency>();
        for (ModuleId moduleId : pkg.moduleIds()) {
            Module module = pkg.module(moduleId);
            ArrayList<io.ballerina.projects.internal.balo.ModuleDependency> moduleDependencies = new ArrayList<io.ballerina.projects.internal.balo.ModuleDependency>();
            for (ModuleDependency moduleDependency : module.moduleDependencies()) {
                if (moduleDependency.packageDependency().scope() == PackageDependencyScope.TEST_ONLY) continue;
                Package pkgDependency = packageCache.getPackageOrThrow(moduleDependency.packageDependency().packageId());
                Module moduleInPkgDependency = pkgDependency.module(moduleDependency.moduleId());
                moduleDependencies.add(this.createModuleDependencyEntry(pkgDependency, moduleInPkgDependency, Collections.emptyList()));
            }
            modules.add(this.createModuleDependencyEntry(pkg, module, moduleDependencies));
        }
        return modules;
    }

    private io.ballerina.projects.internal.balo.ModuleDependency createModuleDependencyEntry(Package pkg, Module module, List<io.ballerina.projects.internal.balo.ModuleDependency> moduleDependencies) {
        return new io.ballerina.projects.internal.balo.ModuleDependency(pkg.packageOrg().value(), pkg.packageName().value(), pkg.packageVersion().toString(), module.moduleName().toString(), moduleDependencies);
    }

    protected void putZipEntry(ZipOutputStream baloOutputStream, Path fileName, InputStream in) throws IOException {
        ZipEntry entry = new ZipEntry(this.convertPathSeperator(fileName));
        baloOutputStream.putNextEntry(entry);
        IOUtils.copy(in, baloOutputStream);
        IOUtils.closeQuietly(in);
    }

    protected void putDirectoryToZipFile(Path sourceDir, Path pathInZipFile, ZipOutputStream out) throws IOException {
        File[] files;
        if (sourceDir.toFile().exists() && (files = new File(sourceDir.toString()).listFiles()) != null && files.length > 0) {
            for (File file : files) {
                if (file.isDirectory()) {
                    this.putDirectoryToZipFile(sourceDir.resolve(file.getName()), pathInZipFile, out);
                    continue;
                }
                Path fileNameInBalo = pathInZipFile.resolve(sourceDir.relativize(Paths.get(file.getPath(), new String[0])));
                this.putZipEntry(out, fileNameInBalo, new FileInputStream(sourceDir + File.separator + file.getName()));
            }
        }
    }

    protected abstract Optional<JsonArray> addPlatformLibs(ZipOutputStream var1, Package var2) throws IOException;

    private String convertPathSeperator(Path file) {
        if (file == null) {
            return null;
        }
        if (File.separatorChar == '\\') {
            Object replaced = "";
            replaced = Optional.ofNullable(file.getFileName()).orElse(Paths.get("", new String[0])).toString();
            for (Path parent = file.getParent(); parent != null; parent = parent.getParent()) {
                replaced = parent.getFileName() + "/" + (String)replaced;
            }
            return replaced;
        }
        return file.toString();
    }
}

