/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import io.ballerina.projects.ProjectException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.programfile.PackageFileWriter;

class BirWriter {
    private BirWriter() {
    }

    public static void write(BLangPackage bLangPackage, Path birFilePath) {
        BirWriter.write(bLangPackage, birFilePath, true);
    }

    static void write(BLangPackage bLangPackage, Path birFilePath, boolean forceOverwrite) {
        try {
            byte[] pkgBirBinaryContent = PackageFileWriter.writePackage(bLangPackage.symbol.birPackageFile);
            if (forceOverwrite) {
                Files.write(birFilePath, pkgBirBinaryContent, new OpenOption[0]);
            } else {
                Files.write(birFilePath, pkgBirBinaryContent, StandardOpenOption.CREATE_NEW);
            }
        }
        catch (IOException e) {
            String msg = "error writing the compiled module(BIR) of '" + bLangPackage.packageID + "' to '" + birFilePath + "': " + e.getMessage();
            throw new ProjectException(msg, e);
        }
    }
}

