/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import io.ballerina.projects.ModuleId;
import java.util.Objects;
import java.util.UUID;

public final class DocumentId {
    private final UUID id;
    private final String documentPath;
    private final ModuleId moduleId;

    private DocumentId(UUID id, String documentPath, ModuleId moduleId) {
        this.id = id;
        this.documentPath = documentPath;
        this.moduleId = moduleId;
    }

    public static DocumentId create(String documentPath, ModuleId moduleId) {
        return new DocumentId(UUID.randomUUID(), documentPath, moduleId);
    }

    public UUID id() {
        return this.id;
    }

    public ModuleId moduleId() {
        return this.moduleId;
    }

    public String toString() {
        return "DocumentId{id=" + this.id + ", documentPath='" + this.documentPath + "', moduleId=" + this.moduleId + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentId that = (DocumentId)o;
        return this.id.equals(that.id) && this.moduleId.equals(that.moduleId);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.moduleId);
    }
}

