/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import io.ballerina.projects.CompilationCache;
import io.ballerina.projects.CompilerBackend;
import io.ballerina.projects.DiagnosticResult;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.EmitResult;
import io.ballerina.projects.JBallerinaBaloWriter;
import io.ballerina.projects.JarLibrary;
import io.ballerina.projects.JarResolver;
import io.ballerina.projects.JdkVersion;
import io.ballerina.projects.Module;
import io.ballerina.projects.ModuleContext;
import io.ballerina.projects.ModuleName;
import io.ballerina.projects.Package;
import io.ballerina.projects.PackageCompilation;
import io.ballerina.projects.PackageContext;
import io.ballerina.projects.PackageId;
import io.ballerina.projects.PackageManifest;
import io.ballerina.projects.PackageResolution;
import io.ballerina.projects.PlatformLibrary;
import io.ballerina.projects.PlatformLibraryScope;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.ProjectKind;
import io.ballerina.projects.TestAnnotationProcessor;
import io.ballerina.projects.environment.PackageCache;
import io.ballerina.projects.environment.ProjectEnvironment;
import io.ballerina.projects.internal.DefaultDiagnosticResult;
import io.ballerina.projects.internal.jballerina.JarWriter;
import io.ballerina.projects.testsuite.TestSuite;
import io.ballerina.projects.testsuite.TesterinaRegistry;
import io.ballerina.projects.util.FileUtils;
import io.ballerina.projects.util.ProjectUtils;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.Location;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import org.apache.commons.compress.archivers.jar.JarArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntryPredicate;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.ballerinalang.compiler.CompilerOptionName;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.tree.SimpleVariableNode;
import org.wso2.ballerinalang.compiler.CompiledJarFile;
import org.wso2.ballerinalang.compiler.bir.codegen.CodeGenerator;
import org.wso2.ballerinalang.compiler.semantics.analyzer.ObservabilitySymbolCollectorRunner;
import org.wso2.ballerinalang.compiler.spi.ObservabilitySymbolCollector;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.CompilerOptions;
import org.wso2.ballerinalang.util.Lists;

public class JBallerinaBackend
extends CompilerBackend {
    private static final String JAR_FILE_EXTENSION = ".jar";
    private static final String TEST_JAR_FILE_NAME_SUFFIX = "-testable";
    private static final String JAR_FILE_NAME_SUFFIX = "";
    private static final HashSet<String> excludeExtensions = new HashSet<String>(Lists.of("DSA", "SF"));
    private final PackageResolution pkgResolution;
    private final JdkVersion jdkVersion;
    private final PackageContext packageContext;
    private final PackageCache packageCache;
    private final CompilerContext compilerContext;
    private final CodeGenerator jvmCodeGenerator;
    private final JarResolver jarResolver;
    private final CompilerOptions compilerOptions;
    private DiagnosticResult diagnosticResult;
    private boolean codeGenCompleted;

    public static JBallerinaBackend from(PackageCompilation packageCompilation, JdkVersion jdkVersion) {
        return packageCompilation.getCompilerBackend(jdkVersion, targetPlatform -> new JBallerinaBackend(packageCompilation, jdkVersion));
    }

    private JBallerinaBackend(PackageCompilation packageCompilation, JdkVersion jdkVersion) {
        this.jdkVersion = jdkVersion;
        this.packageContext = packageCompilation.packageContext();
        this.pkgResolution = this.packageContext.getResolution();
        this.jarResolver = new JarResolver(this, this.packageContext.getResolution());
        ProjectEnvironment projectEnvContext = this.packageContext.project().projectEnvironmentContext();
        this.packageCache = projectEnvContext.getService(PackageCache.class);
        this.compilerContext = projectEnvContext.getService(CompilerContext.class);
        this.jvmCodeGenerator = CodeGenerator.getInstance(this.compilerContext);
        this.compilerOptions = CompilerOptions.getInstance(this.compilerContext);
        TesterinaRegistry.reset();
        if (this.packageContext.compilationOptions().observabilityIncluded()) {
            ObservabilitySymbolCollector observabilitySymbolCollector = ObservabilitySymbolCollectorRunner.getInstance(this.compilerContext);
            observabilitySymbolCollector.process(this.packageContext.project());
        }
        this.performCodeGen();
    }

    private void performCodeGen() {
        if (this.codeGenCompleted) {
            return;
        }
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        for (ModuleContext moduleContext : this.pkgResolution.topologicallySortedModuleList()) {
            moduleContext.generatePlatformSpecificCode(this.compilerContext, this);
            diagnostics.addAll(moduleContext.diagnostics());
        }
        this.diagnosticResult = new DefaultDiagnosticResult(diagnostics);
        this.codeGenCompleted = true;
    }

    public DiagnosticResult diagnosticResult() {
        return this.diagnosticResult;
    }

    public EmitResult emit(OutputType outputType, Path filePath) {
        if (this.diagnosticResult.hasErrors()) {
            return new EmitResult(false, this.diagnosticResult);
        }
        switch (outputType) {
            case EXEC: {
                this.emitExecutable(filePath);
                break;
            }
            case BALO: {
                this.emitBalo(filePath);
                break;
            }
            default: {
                throw new RuntimeException("Unexpected output type: " + outputType);
            }
        }
        return new EmitResult(true, this.diagnosticResult);
    }

    private void emitBalo(Path filePath) {
        JBallerinaBaloWriter writer = new JBallerinaBaloWriter(this);
        Package pkg = this.packageCache.getPackageOrThrow(this.packageContext.packageId());
        writer.write(pkg, filePath);
    }

    @Override
    public Collection<PlatformLibrary> platformLibraryDependencies(PackageId packageId) {
        return this.getPlatformLibraries(packageId);
    }

    @Override
    public Collection<PlatformLibrary> platformLibraryDependencies(PackageId packageId, PlatformLibraryScope scope) {
        return this.getPlatformLibraries(packageId).stream().filter(platformLibrary -> platformLibrary.scope() == scope).collect(Collectors.toList());
    }

    private List<PlatformLibrary> getPlatformLibraries(PackageId packageId) {
        Package pkg = this.packageCache.getPackageOrThrow(packageId);
        PackageManifest.Platform javaPlatform = pkg.manifest().platform(this.jdkVersion.code());
        if (javaPlatform == null || javaPlatform.dependencies().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<PlatformLibrary> platformLibraries = new ArrayList<PlatformLibrary>();
        for (Map<String, Object> dependency : javaPlatform.dependencies()) {
            String dependencyFilePath = (String)dependency.get("path");
            String artifactId = (String)dependency.get("artifactId");
            String version = (String)dependency.get("version");
            String groupId = (String)dependency.get("groupId");
            Path jarPath = Paths.get(dependencyFilePath, new String[0]);
            if (!jarPath.isAbsolute()) {
                jarPath = pkg.project().sourceRoot().resolve(jarPath);
            }
            PlatformLibraryScope scope = this.getPlatformLibraryScope(dependency);
            platformLibraries.add(new JarLibrary(jarPath, scope, artifactId, groupId, version));
        }
        return platformLibraries;
    }

    @Override
    public PlatformLibrary codeGeneratedLibrary(PackageId packageId, ModuleName moduleName) {
        return this.codeGeneratedLibrary(packageId, moduleName, PlatformLibraryScope.DEFAULT, JAR_FILE_NAME_SUFFIX);
    }

    @Override
    public PlatformLibrary codeGeneratedTestLibrary(PackageId packageId, ModuleName moduleName) {
        return this.codeGeneratedLibrary(packageId, moduleName, PlatformLibraryScope.DEFAULT, TEST_JAR_FILE_NAME_SUFFIX);
    }

    @Override
    public PlatformLibrary runtimeLibrary() {
        return new JarLibrary(ProjectUtils.getBallerinaRTJarPath(), PlatformLibraryScope.DEFAULT);
    }

    @Override
    public CompilerBackend.TargetPlatform targetPlatform() {
        return this.jdkVersion;
    }

    @Override
    public void performCodeGen(ModuleContext moduleContext, CompilationCache compilationCache) {
        BLangPackage bLangPackage = moduleContext.bLangPackage();
        CompiledJarFile compiledJarFile = this.jvmCodeGenerator.generate(moduleContext.moduleId(), this, bLangPackage);
        String jarFileName = this.getJarFileName(moduleContext);
        try {
            ByteArrayOutputStream byteStream = JarWriter.write(compiledJarFile);
            compilationCache.cachePlatformSpecificLibrary(this, jarFileName, byteStream);
        }
        catch (IOException e) {
            throw new ProjectException("Failed to cache generated jar, module: " + moduleContext.moduleName());
        }
        if (Boolean.parseBoolean(this.compilerOptions.get(CompilerOptionName.SKIP_TESTS))) {
            return;
        }
        if (!bLangPackage.hasTestablePackage()) {
            return;
        }
        String testJarFileName = jarFileName + TEST_JAR_FILE_NAME_SUFFIX;
        CompiledJarFile compiledTestJarFile = this.jvmCodeGenerator.generateTestModule(moduleContext.moduleId(), this, bLangPackage.testablePkgs.get(0));
        try {
            ByteArrayOutputStream byteStream = JarWriter.write(compiledTestJarFile);
            compilationCache.cachePlatformSpecificLibrary(this, testJarFileName, byteStream);
        }
        catch (IOException e) {
            throw new ProjectException("Failed to cache generated test jar, module: " + moduleContext.moduleName());
        }
    }

    @Override
    public String libraryFileExtension() {
        return JAR_FILE_EXTENSION;
    }

    public JarResolver jarResolver() {
        return this.jarResolver;
    }

    public Optional<TestSuite> testSuite(Module module) {
        if (module.project().kind() != ProjectKind.SINGLE_FILE_PROJECT && !module.moduleContext().bLangPackage().hasTestablePackage()) {
            return Optional.empty();
        }
        if (Boolean.getBoolean(this.compilerOptions.get(CompilerOptionName.SKIP_TESTS))) {
            return Optional.empty();
        }
        return Optional.of(this.generateTestSuite(module.moduleContext(), this.compilerContext));
    }

    private TestSuite generateTestSuite(ModuleContext moduleContext, CompilerContext compilerContext) {
        BLangPackage testablePkg;
        BLangPackage bLangPackage = moduleContext.bLangPackage();
        TestSuite testSuite = new TestSuite(bLangPackage.packageID.name.value, bLangPackage.packageID.toString(), bLangPackage.packageID.orgName.value, bLangPackage.packageID.version.value);
        TesterinaRegistry.getInstance().getTestSuites().put(moduleContext.descriptor().name().toString(), testSuite);
        testSuite.setInitFunctionName(bLangPackage.initFunction.name.value);
        testSuite.setStartFunctionName(bLangPackage.startFunction.name.value);
        testSuite.setStopFunctionName(bLangPackage.stopFunction.name.value);
        testSuite.setPackageName(bLangPackage.packageID.toString());
        testSuite.setSourceRootPath(moduleContext.project().sourceRoot().toString());
        bLangPackage.functions.forEach(function -> {
            Location pos = function.pos;
            if (pos != null && !function.getFlags().contains((Object)Flag.RESOURCE) && !function.getFlags().contains((Object)Flag.REMOTE)) {
                String className = pos.lineRange().filePath().replace(".bal", JAR_FILE_NAME_SUFFIX).replace("/", ".");
                String functionClassName = JarResolver.getQualifiedClassName(bLangPackage.packageID.orgName.value, bLangPackage.packageID.name.value, bLangPackage.packageID.version.value, className);
                testSuite.addTestUtilityFunction(function.name.value, functionClassName);
            }
        });
        if (moduleContext.project().kind() == ProjectKind.SINGLE_FILE_PROJECT) {
            testablePkg = bLangPackage;
        } else {
            testablePkg = bLangPackage.getTestablePkg();
            testSuite.setTestInitFunctionName(testablePkg.initFunction.name.value);
            testSuite.setTestStartFunctionName(testablePkg.startFunction.name.value);
            testSuite.setTestStopFunctionName(testablePkg.stopFunction.name.value);
            testablePkg.functions.forEach(function -> {
                Location location = function.pos;
                if (location != null && !function.getFlags().contains((Object)Flag.RESOURCE) && !function.getFlags().contains((Object)Flag.REMOTE)) {
                    String className = location.lineRange().filePath().replace(".bal", JAR_FILE_NAME_SUFFIX).replace("/", ".");
                    String functionClassName = JarResolver.getQualifiedClassName(bLangPackage.packageID.orgName.value, bLangPackage.packageID.name.value, bLangPackage.packageID.version.value, className);
                    testSuite.addTestUtilityFunction(function.name.value, functionClassName);
                }
            });
        }
        TestAnnotationProcessor testAnnotationProcessor = new TestAnnotationProcessor();
        testAnnotationProcessor.init(compilerContext, testablePkg);
        testablePkg.functions.forEach(testAnnotationProcessor::processFunction);
        testablePkg.topLevelNodes.stream().filter(topLevelNode -> topLevelNode instanceof BLangSimpleVariable).map(topLevelNode -> (SimpleVariableNode)topLevelNode).forEach(testAnnotationProcessor::processMockFunction);
        return testSuite;
    }

    private String getJarFileName(ModuleContext moduleContext) {
        String jarName;
        if (moduleContext.project().kind() == ProjectKind.SINGLE_FILE_PROJECT) {
            DocumentId documentId = moduleContext.srcDocumentIds().iterator().next();
            String documentName = moduleContext.documentContext(documentId).name();
            jarName = FileUtils.getFileNameWithoutExtension(documentName);
        } else {
            jarName = moduleContext.moduleName().toString();
        }
        return jarName;
    }

    private void assembleExecutableJar(Path executableFilePath, Manifest manifest, Collection<Path> jarFilePaths) throws IOException {
        HashSet<String> copiedEntries = new HashSet<String>();
        HashMap<String, StringBuilder> serviceEntries = new HashMap<String, StringBuilder>();
        try (ZipArchiveOutputStream outStream = new ZipArchiveOutputStream(new BufferedOutputStream(new FileOutputStream(executableFilePath.toString())));){
            this.writeManifest(manifest, outStream);
            for (Path path : jarFilePaths) {
                this.copyJar(outStream, path, copiedEntries, serviceEntries);
            }
            for (Map.Entry entry : serviceEntries.entrySet()) {
                String s = (String)entry.getKey();
                StringBuilder service = (StringBuilder)entry.getValue();
                JarArchiveEntry e = new JarArchiveEntry(s);
                outStream.putArchiveEntry(e);
                outStream.write(service.toString().getBytes(StandardCharsets.UTF_8));
                outStream.closeArchiveEntry();
            }
        }
    }

    private void writeManifest(Manifest manifest, ZipArchiveOutputStream outStream) throws IOException {
        JarArchiveEntry e = new JarArchiveEntry("META-INF/MANIFEST.MF");
        outStream.putArchiveEntry(e);
        manifest.write(new BufferedOutputStream(outStream));
        outStream.closeArchiveEntry();
    }

    private Manifest createManifest() {
        String mainClassName;
        PlatformLibrary rootModuleJarFile = this.codeGeneratedLibrary(this.packageContext.packageId(), this.packageContext.defaultModuleContext().moduleName());
        try (JarInputStream jarStream = new JarInputStream(Files.newInputStream(rootModuleJarFile.path(), new OpenOption[0]));){
            Manifest mf = jarStream.getManifest();
            mainClassName = (String)mf.getMainAttributes().get(Attributes.Name.MAIN_CLASS);
        }
        catch (IOException e) {
            throw new RuntimeException("Generated jar file cannot be found for the module: " + this.packageContext.defaultModuleContext().moduleName());
        }
        Manifest manifest = new Manifest();
        Attributes mainAttributes = manifest.getMainAttributes();
        mainAttributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        mainAttributes.put(Attributes.Name.MAIN_CLASS, mainClassName);
        return manifest;
    }

    private void copyJar(ZipArchiveOutputStream outStream, Path jarFilePath, HashSet<String> copiedEntries, HashMap<String, StringBuilder> services) throws IOException {
        ZipFile zipFile = new ZipFile(jarFilePath.toFile());
        ZipArchiveEntryPredicate predicate = entry -> {
            String entryName = entry.getName();
            if (entryName.equals("META-INF/MANIFEST.MF")) {
                return false;
            }
            if (entryName.startsWith("META-INF/services")) {
                StringBuilder s = (StringBuilder)services.get(entryName);
                if (s == null) {
                    s = new StringBuilder();
                    services.put(entryName, s);
                }
                char c = '\n';
                try (BufferedInputStream inStream = new BufferedInputStream(zipFile.getInputStream(entry));){
                    int len;
                    while ((len = inStream.read()) != -1) {
                        c = (char)len;
                        s.append(c);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                if (c != '\n') {
                    s.append('\n');
                }
                return false;
            }
            if (JBallerinaBackend.isCopiedOrExcludedEntry(entryName, copiedEntries)) {
                return false;
            }
            copiedEntries.add(entryName);
            return true;
        };
        zipFile.copyRawEntries(outStream, predicate);
        zipFile.close();
    }

    private static boolean isCopiedOrExcludedEntry(String entryName, HashSet<String> copiedEntries) {
        return copiedEntries.contains(entryName) || excludeExtensions.contains(entryName.substring(entryName.lastIndexOf(".") + 1));
    }

    private PlatformLibrary codeGeneratedLibrary(PackageId packageId, ModuleName moduleName, PlatformLibraryScope scope, String fileNameSuffix) {
        Package pkg = this.packageCache.getPackageOrThrow(packageId);
        ProjectEnvironment projectEnvironment = pkg.project().projectEnvironmentContext();
        CompilationCache compilationCache = projectEnvironment.getService(CompilationCache.class);
        String jarFileName = this.getJarFileName(pkg.packageContext().moduleContext(moduleName)) + fileNameSuffix;
        Optional<Path> platformSpecificLibrary = compilationCache.getPlatformSpecificLibrary(this, jarFileName);
        return new JarLibrary(platformSpecificLibrary.orElseThrow(() -> new IllegalStateException("Cannot find the generated jar library for module: " + moduleName)), scope);
    }

    private void emitExecutable(Path executableFilePath) {
        Manifest manifest = this.createManifest();
        Collection<Path> jarLibraryPaths = this.jarResolver.getJarFilePathsRequiredForExecution();
        try {
            this.assembleExecutableJar(executableFilePath, manifest, jarLibraryPaths);
            if (this.packageContext.compilationOptions().observabilityIncluded()) {
                ObservabilitySymbolCollector observabilitySymbolCollector = ObservabilitySymbolCollectorRunner.getInstance(this.compilerContext);
                observabilitySymbolCollector.writeToExecutable(executableFilePath);
            }
        }
        catch (IOException e) {
            throw new ProjectException("error while creating the executable jar file for package: " + this.packageContext.packageName(), e);
        }
    }

    private PlatformLibraryScope getPlatformLibraryScope(Map<String, Object> dependency) {
        PlatformLibraryScope scope;
        String scopeValue = (String)dependency.get("scope");
        if (scopeValue == null || scopeValue.isEmpty()) {
            scope = PlatformLibraryScope.DEFAULT;
        } else if (scopeValue.equals(PlatformLibraryScope.TEST_ONLY.getStringValue())) {
            scope = PlatformLibraryScope.TEST_ONLY;
        } else {
            throw new ProjectException("Invalid scope '" + scopeValue + "' is defined with the platform-specific library path: " + dependency.get("path"));
        }
        return scope;
    }

    JdkVersion jdkVersion() {
        return this.jdkVersion;
    }

    public static enum OutputType {
        EXEC("exec"),
        BALO("balo");

        private String value;

        private OutputType(String value) {
            this.value = value;
        }
    }
}

