/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import io.ballerina.projects.BaloWriter;
import io.ballerina.projects.JBallerinaBackend;
import io.ballerina.projects.JarLibrary;
import io.ballerina.projects.Package;
import io.ballerina.projects.PlatformLibrary;
import io.ballerina.projects.PlatformLibraryScope;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Optional;
import java.util.zip.ZipOutputStream;

public class JBallerinaBaloWriter
extends BaloWriter {
    JBallerinaBackend backend;

    public JBallerinaBaloWriter(JBallerinaBackend backend) {
        this.backend = backend;
        this.target = backend.jdkVersion().code();
    }

    @Override
    protected Optional<JsonArray> addPlatformLibs(ZipOutputStream baloOutputStream, Package pkg) throws IOException {
        Collection<PlatformLibrary> jars = this.backend.platformLibraryDependencies(pkg.packageId(), PlatformLibraryScope.DEFAULT);
        if (jars.isEmpty()) {
            return Optional.empty();
        }
        JsonArray newPlatformLibs = new JsonArray();
        for (PlatformLibrary platformLibrary : jars) {
            JarLibrary jar = (JarLibrary)platformLibrary;
            Path libPath = jar.path();
            String fileName = Optional.ofNullable(libPath.getFileName()).map(p -> p.toString()).orElse("annon");
            Path entryPath = Paths.get("platform", new String[0]).resolve(this.target).resolve(fileName);
            this.putZipEntry(baloOutputStream, entryPath, new FileInputStream(libPath.toString()));
            JsonObject newDependency = new JsonObject();
            newDependency.addProperty("path", entryPath.toString());
            if (jar.artifactId().isPresent() && jar.groupId().isPresent() && jar.version().isPresent()) {
                newDependency.addProperty("artifactId", jar.artifactId().get());
                newDependency.addProperty("groupId", jar.groupId().get());
                newDependency.addProperty("version", jar.version().get());
            }
            newPlatformLibs.add(newDependency);
        }
        return Optional.of(newPlatformLibs);
    }
}

