/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import io.ballerina.projects.JBallerinaBackend;
import io.ballerina.projects.ModuleContext;
import io.ballerina.projects.ModuleId;
import io.ballerina.projects.ModuleName;
import io.ballerina.projects.PackageContext;
import io.ballerina.projects.PackageDependencyScope;
import io.ballerina.projects.PackageId;
import io.ballerina.projects.PackageResolution;
import io.ballerina.projects.PlatformLibrary;
import io.ballerina.projects.PlatformLibraryScope;
import io.ballerina.projects.util.ProjectUtils;
import io.ballerina.runtime.api.utils.IdentifierUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class JarResolver {
    private final JBallerinaBackend jBalBackend;
    private final PackageResolution pkgResolution;
    private final PackageContext rootPackageContext;
    private ClassLoader classLoaderWithAllJars;

    JarResolver(JBallerinaBackend jBalBackend, PackageResolution pkgResolution) {
        this.jBalBackend = jBalBackend;
        this.pkgResolution = pkgResolution;
        this.rootPackageContext = pkgResolution.packageContext();
    }

    public Collection<Path> getJarFilePathsRequiredForExecution() {
        ArrayList<Path> jarFilePaths = new ArrayList<Path>();
        this.addCodeGeneratedLibraryPaths(this.rootPackageContext, jarFilePaths);
        this.addPlatformLibraryPaths(this.rootPackageContext, PlatformLibraryScope.DEFAULT, jarFilePaths);
        this.pkgResolution.allDependencies().stream().filter(pkgDep -> pkgDep.scope() != PackageDependencyScope.TEST_ONLY).map(pkgDep -> pkgDep.packageInstance().packageContext()).forEach(pkgContext -> {
            this.addCodeGeneratedLibraryPaths((PackageContext)pkgContext, (List<Path>)jarFilePaths);
            this.addPlatformLibraryPaths((PackageContext)pkgContext, PlatformLibraryScope.DEFAULT, (List<Path>)jarFilePaths);
        });
        jarFilePaths.add(this.jBalBackend.runtimeLibrary().path());
        if (this.rootPackageContext.compilationOptions().observabilityIncluded()) {
            jarFilePaths.add(ProjectUtils.getChoreoRuntimeJarPath());
        }
        return jarFilePaths;
    }

    private void addCodeGeneratedLibraryPaths(PackageContext packageContext, List<Path> libraryPaths) {
        for (ModuleId moduleId : packageContext.moduleIds()) {
            ModuleContext moduleContext = packageContext.moduleContext(moduleId);
            PlatformLibrary generatedJarLibrary = this.jBalBackend.codeGeneratedLibrary(packageContext.packageId(), moduleContext.moduleName());
            libraryPaths.add(generatedJarLibrary.path());
        }
    }

    private void addPlatformLibraryPaths(PackageContext packageContext, PlatformLibraryScope scope, List<Path> libraryPaths) {
        Collection<PlatformLibrary> otherJarDependencies = this.jBalBackend.platformLibraryDependencies(packageContext.packageId(), scope);
        for (PlatformLibrary otherJarDependency : otherJarDependencies) {
            libraryPaths.add(otherJarDependency.path());
        }
    }

    public Collection<Path> getJarFilePathsRequiredForTestExecution(ModuleName moduleName) {
        ArrayList<Path> allJarFileForTestExec = new ArrayList<Path>(this.getJarFilePathsRequiredForExecution());
        if (!this.rootPackageContext.manifest().org().anonymous()) {
            PackageId rootPackageId = this.rootPackageContext.packageId();
            PlatformLibrary generatedTestJar = this.jBalBackend.codeGeneratedTestLibrary(rootPackageId, moduleName);
            allJarFileForTestExec.add(generatedTestJar.path());
            PlatformLibrary generatedJar = this.jBalBackend.codeGeneratedLibrary(rootPackageId, moduleName);
            allJarFileForTestExec.remove(generatedJar.path());
        }
        this.addPlatformLibraryPaths(this.rootPackageContext, PlatformLibraryScope.TEST_ONLY, allJarFileForTestExec);
        this.pkgResolution.allDependencies().stream().filter(pkgDep -> pkgDep.scope() == PackageDependencyScope.TEST_ONLY).map(pkgDep -> pkgDep.packageInstance().packageContext()).forEach(pkgContext -> {
            this.addCodeGeneratedLibraryPaths((PackageContext)pkgContext, (List<Path>)allJarFileForTestExec);
            this.addPlatformLibraryPaths((PackageContext)pkgContext, PlatformLibraryScope.DEFAULT, (List<Path>)allJarFileForTestExec);
        });
        allJarFileForTestExec.addAll(ProjectUtils.testDependencies());
        return allJarFileForTestExec;
    }

    public ClassLoader getClassLoaderWithRequiredJarFilesForExecution() {
        if (this.classLoaderWithAllJars != null) {
            return this.classLoaderWithAllJars;
        }
        this.classLoaderWithAllJars = this.createClassLoader(this.getJarFilePathsRequiredForExecution());
        return this.classLoaderWithAllJars;
    }

    public ClassLoader getClassLoaderWithRequiredJarFilesForTestExecution(ModuleName moduleName) {
        return this.createClassLoader(this.getJarFilePathsRequiredForTestExecution(moduleName));
    }

    private URLClassLoader createClassLoader(Collection<Path> jarFilePaths) {
        if (this.jBalBackend.diagnosticResult().hasErrors()) {
            throw new IllegalStateException("Cannot create a ClassLoader: this compilation has errors.");
        }
        ArrayList<URL> urlList = new ArrayList<URL>(jarFilePaths.size());
        for (Path jarFilePath : jarFilePaths) {
            try {
                urlList.add(jarFilePath.toUri().toURL());
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Failed to create classloader with all jar files", e);
            }
        }
        return AccessController.doPrivileged(() -> new URLClassLoader(urlList.toArray(new URL[0]), ClassLoader.getSystemClassLoader()));
    }

    public static String getQualifiedClassName(String orgName, String packageName, String version, String className) {
        if (!".".equals(packageName)) {
            className = IdentifierUtils.encodeNonFunctionIdentifier(packageName) + "." + version.replace('.', '_') + "." + (String)className;
        }
        if (!"$anon".equals(orgName)) {
            className = IdentifierUtils.encodeNonFunctionIdentifier(orgName) + "." + (String)className;
        }
        return className;
    }
}

