/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import io.ballerina.projects.Document;
import io.ballerina.projects.DocumentConfig;
import io.ballerina.projects.DocumentContext;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.ModuleCompilation;
import io.ballerina.projects.ModuleContext;
import io.ballerina.projects.ModuleDependency;
import io.ballerina.projects.ModuleDescriptor;
import io.ballerina.projects.ModuleId;
import io.ballerina.projects.ModuleName;
import io.ballerina.projects.Package;
import io.ballerina.projects.Project;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class Module {
    private final ModuleContext moduleContext;
    private final Package packageInstance;
    private final Map<DocumentId, Document> srcDocs;
    private final Map<DocumentId, Document> testSrcDocs;
    private final Function<DocumentId, Document> populateDocumentFunc;

    Module(ModuleContext moduleContext, Package packageInstance) {
        this.moduleContext = moduleContext;
        this.packageInstance = packageInstance;
        this.srcDocs = new ConcurrentHashMap<DocumentId, Document>();
        this.testSrcDocs = new ConcurrentHashMap<DocumentId, Document>();
        this.populateDocumentFunc = documentId -> new Document(this.moduleContext.documentContext((DocumentId)documentId), this);
    }

    static Module from(ModuleContext moduleContext, Package packageInstance) {
        return new Module(moduleContext, packageInstance);
    }

    public Package packageInstance() {
        return this.packageInstance;
    }

    public ModuleId moduleId() {
        return this.moduleContext.moduleId();
    }

    public ModuleName moduleName() {
        return this.moduleContext.moduleName();
    }

    public ModuleDescriptor descriptor() {
        return this.moduleContext.descriptor();
    }

    public Collection<DocumentId> documentIds() {
        return this.moduleContext.srcDocumentIds();
    }

    public Iterable<Document> documents() {
        return new DocumentIterable(this.srcDocs.values());
    }

    public Collection<DocumentId> testDocumentIds() {
        return this.moduleContext.testSrcDocumentIds();
    }

    public Iterable<Document> testDocuments() {
        return new DocumentIterable(this.testSrcDocs.values());
    }

    public Document document(DocumentId documentId) {
        if (this.documentIds().contains(documentId)) {
            return this.srcDocs.computeIfAbsent(documentId, this.populateDocumentFunc);
        }
        return this.testSrcDocs.computeIfAbsent(documentId, this.populateDocumentFunc);
    }

    public ModuleCompilation getCompilation() {
        return this.packageInstance.packageContext().getModuleCompilation(this.moduleContext);
    }

    public Collection<ModuleDependency> moduleDependencies() {
        return this.moduleContext.dependencies();
    }

    public boolean isDefaultModule() {
        return this.moduleContext.isDefaultModule();
    }

    public Project project() {
        return this.moduleContext.project();
    }

    public Modifier modify() {
        return new Modifier(this);
    }

    ModuleContext moduleContext() {
        return this.moduleContext;
    }

    public static class Modifier {
        private ModuleId moduleId;
        private ModuleDescriptor moduleDescriptor;
        private Map<DocumentId, DocumentContext> srcDocContextMap;
        private Map<DocumentId, DocumentContext> testDocContextMap;
        private boolean isDefaultModule;
        private final List<ModuleDescriptor> dependencies;
        private Package packageInstance;
        private Project project;

        private Modifier(Module oldModule) {
            this.moduleId = oldModule.moduleId();
            this.moduleDescriptor = oldModule.descriptor();
            this.srcDocContextMap = this.copySrcDocs(oldModule);
            this.testDocContextMap = this.copyTestDocs(oldModule);
            this.isDefaultModule = oldModule.isDefaultModule();
            this.dependencies = oldModule.moduleContext().moduleDescDependencies();
            this.packageInstance = oldModule.packageInstance;
            this.project = oldModule.project();
        }

        Modifier updateDocument(DocumentContext newDocContext) {
            if (this.srcDocContextMap.containsKey(newDocContext.documentId())) {
                this.srcDocContextMap.put(newDocContext.documentId(), newDocContext);
            } else {
                this.testDocContextMap.put(newDocContext.documentId(), newDocContext);
            }
            return this;
        }

        public Modifier addDocument(DocumentConfig documentConfig) {
            DocumentContext newDocumentContext = DocumentContext.from(documentConfig);
            this.srcDocContextMap.put(newDocumentContext.documentId(), newDocumentContext);
            return this;
        }

        public Modifier addTestDocument(DocumentConfig documentConfig) {
            DocumentContext newDocumentContext = DocumentContext.from(documentConfig);
            this.testDocContextMap.put(newDocumentContext.documentId(), newDocumentContext);
            return this;
        }

        public Modifier removeDocument(DocumentId documentId) {
            if (this.srcDocContextMap.containsKey(documentId)) {
                this.srcDocContextMap.remove(documentId);
            } else {
                this.testDocContextMap.remove(documentId);
            }
            return this;
        }

        public Module apply() {
            return this.createNewModule(this.srcDocContextMap, this.testDocContextMap);
        }

        private Map<DocumentId, DocumentContext> copySrcDocs(Module oldModule) {
            HashMap<DocumentId, DocumentContext> srcDocContextMap = new HashMap<DocumentId, DocumentContext>();
            for (DocumentId documentId : oldModule.moduleContext.srcDocumentIds()) {
                srcDocContextMap.put(documentId, oldModule.moduleContext.documentContext(documentId));
            }
            return srcDocContextMap;
        }

        private Map<DocumentId, DocumentContext> copyTestDocs(Module oldModule) {
            HashMap<DocumentId, DocumentContext> testDocContextMap = new HashMap<DocumentId, DocumentContext>();
            for (DocumentId documentId : oldModule.moduleContext.testSrcDocumentIds()) {
                testDocContextMap.put(documentId, oldModule.moduleContext.documentContext(documentId));
            }
            return testDocContextMap;
        }

        private Module createNewModule(Map<DocumentId, DocumentContext> srcDocContextMap, Map<DocumentId, DocumentContext> testDocContextMap) {
            ModuleContext newModuleContext = new ModuleContext(this.project, this.moduleId, this.moduleDescriptor, this.isDefaultModule, srcDocContextMap, testDocContextMap, this.dependencies);
            Package newPackage = this.packageInstance.modify().updateModule(newModuleContext).apply();
            return newPackage.module(this.moduleId);
        }
    }

    private static class DocumentIterable
    implements Iterable {
        private final Collection<Document> documentList;

        public DocumentIterable(Collection<Document> documentList) {
            this.documentList = documentList;
        }

        public Iterator<Document> iterator() {
            return this.documentList.iterator();
        }

        public Spliterator spliterator() {
            return this.documentList.spliterator();
        }
    }
}

