/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import io.ballerina.projects.PackageName;
import io.ballerina.projects.PackageOrg;
import io.ballerina.projects.PackageVersion;
import java.util.Objects;

public class PackageDescriptor {
    private static final String LANG_LIB_PACKAGE_NAME_PREFIX = "lang.";
    private final PackageName packageName;
    private final PackageOrg packageOrg;
    private final PackageVersion packageVersion;

    private PackageDescriptor(PackageOrg packageOrg, PackageName packageName, PackageVersion packageVersion) {
        this.packageName = packageName;
        this.packageOrg = packageOrg;
        this.packageVersion = packageVersion;
    }

    public static PackageDescriptor from(PackageOrg packageOrg, PackageName packageName, PackageVersion packageVersion) {
        return new PackageDescriptor(packageOrg, packageName, packageVersion);
    }

    public PackageName name() {
        return this.packageName;
    }

    public PackageOrg org() {
        return this.packageOrg;
    }

    public PackageVersion version() {
        return this.packageVersion;
    }

    public boolean isLangLibPackage() {
        return this.org().isBallerinaOrg() && this.packageName.value().startsWith(LANG_LIB_PACKAGE_NAME_PREFIX);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        PackageDescriptor that = (PackageDescriptor)other;
        return this.packageName.equals(that.packageName) && this.packageOrg.equals(that.packageOrg) && Objects.equals(this.packageVersion, that.packageVersion);
    }

    public int hashCode() {
        return Objects.hash(this.packageName, this.packageOrg, this.packageVersion);
    }

    public String toString() {
        String pkgStr = this.packageOrg + ":" + this.packageName;
        if (this.packageVersion == null) {
            return pkgStr;
        }
        return pkgStr + ":" + this.packageVersion;
    }
}

