/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import com.github.zafarkhaja.semver.ParseException;
import com.github.zafarkhaja.semver.UnexpectedCharacterException;
import com.github.zafarkhaja.semver.Version;
import io.ballerina.projects.ProjectException;
import java.util.Objects;

public class SemanticVersion {
    private final Version version;

    private SemanticVersion(Version version) {
        this.version = version;
    }

    public static SemanticVersion from(String versionString) {
        try {
            Version v = Version.valueOf(versionString);
            return new SemanticVersion(v);
        }
        catch (IllegalArgumentException e) {
            throw new ProjectException("Version cannot be empty");
        }
        catch (UnexpectedCharacterException e) {
            throw new ProjectException("Invalid version: '" + versionString + "'. " + e.toString());
        }
        catch (ParseException e) {
            throw new ProjectException("Invalid version: '" + versionString + "'. " + e.toString());
        }
    }

    public int major() {
        return this.version.getMajorVersion();
    }

    public int minor() {
        return this.version.getMinorVersion();
    }

    public int patch() {
        return this.version.getPatchVersion();
    }

    public String preReleasePart() {
        return this.version.getPreReleaseVersion();
    }

    public String buildMetadata() {
        return this.version.getBuildMetadata();
    }

    public boolean isStable() {
        if (this.major() == 0) {
            return false;
        }
        String preReleaseComp = this.version.getPreReleaseVersion();
        return preReleaseComp == null || preReleaseComp.trim().isEmpty();
    }

    public boolean greaterThan(SemanticVersion other) {
        return this.version.greaterThan(other.version);
    }

    public boolean greaterThanOrEqualTo(SemanticVersion other) {
        return this.version.greaterThanOrEqualTo(other.version);
    }

    public boolean lessThan(SemanticVersion other) {
        return this.version.lessThan(other.version);
    }

    public boolean lessThanOrEqualTo(SemanticVersion other) {
        return this.version.lessThanOrEqualTo(other.version);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        SemanticVersion otherSemVer = (SemanticVersion)other;
        return this.version.equals(otherSemVer.version);
    }

    public String toString() {
        return this.version.toString();
    }

    public int hashCode() {
        return this.version.hashCode();
    }

    public VersionCompatibilityResult compareTo(SemanticVersion other) {
        Objects.requireNonNull(other);
        if (this.equals(other)) {
            return VersionCompatibilityResult.EQUAL;
        }
        if (!this.isStable() || !other.isStable()) {
            return VersionCompatibilityResult.INCOMPATIBLE;
        }
        if (this.major() != other.major()) {
            return VersionCompatibilityResult.INCOMPATIBLE;
        }
        int result = this.version.compareTo(other.version);
        if (result < 0) {
            return VersionCompatibilityResult.LESS_THAN;
        }
        return VersionCompatibilityResult.GREATER_THAN;
    }

    public static enum VersionCompatibilityResult {
        INCOMPATIBLE,
        EQUAL,
        LESS_THAN,
        GREATER_THAN;

    }
}

