/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.internal;

import io.ballerina.projects.DependencyGraph;
import io.ballerina.projects.ModuleId;
import io.ballerina.projects.PackageDescriptor;
import io.ballerina.projects.internal.ModuleData;
import java.nio.file.Path;
import java.util.List;

public class PackageData {
    private final Path packagePath;
    private final ModuleData defaultModule;
    private final List<ModuleData> otherModules;
    private final DependencyGraph<PackageDescriptor> packageDesDependencyGraph;
    private final DependencyGraph<ModuleId> moduleDependencyGraph;

    private PackageData(Path packagePath, ModuleData defaultModule, List<ModuleData> otherModules, DependencyGraph<PackageDescriptor> packageDesDependencyGraph, DependencyGraph<ModuleId> moduleDependencyGraph) {
        this.packagePath = packagePath;
        this.defaultModule = defaultModule;
        this.otherModules = otherModules;
        this.packageDesDependencyGraph = packageDesDependencyGraph;
        this.moduleDependencyGraph = moduleDependencyGraph;
    }

    public static PackageData from(Path packagePath, ModuleData defaultModule, List<ModuleData> otherModules) {
        return new PackageData(packagePath, defaultModule, otherModules, DependencyGraph.emptyGraph(), DependencyGraph.emptyGraph());
    }

    public static PackageData from(Path packagePath, ModuleData defaultModule, List<ModuleData> otherModules, DependencyGraph<PackageDescriptor> packageDesDependencyGraph, DependencyGraph<ModuleId> moduleDependencyGraph) {
        return new PackageData(packagePath, defaultModule, otherModules, packageDesDependencyGraph, moduleDependencyGraph);
    }

    public Path packagePath() {
        return this.packagePath;
    }

    public ModuleData defaultModule() {
        return this.defaultModule;
    }

    public List<ModuleData> otherModules() {
        return this.otherModules;
    }

    public DependencyGraph<PackageDescriptor> packageDescriptorDependencyGraph() {
        return this.packageDesDependencyGraph;
    }

    public DependencyGraph<ModuleId> moduleDependencyGraph() {
        return this.moduleDependencyGraph;
    }
}

