/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.internal;

import io.ballerina.projects.BuildOptions;
import io.ballerina.projects.BuildOptionsBuilder;
import io.ballerina.projects.PackageManifest;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.internal.BallerinaTomlProcessor;
import io.ballerina.projects.internal.DocumentData;
import io.ballerina.projects.internal.ModuleData;
import io.ballerina.projects.internal.PackageData;
import io.ballerina.projects.util.ProjectUtils;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ProjectFiles {
    public static final PathMatcher BAL_EXTENSION_MATCHER = FileSystems.getDefault().getPathMatcher("glob:**.bal");
    public static final PathMatcher BALR_EXTENSION_MATCHER = FileSystems.getDefault().getPathMatcher("glob:**.balo");

    private ProjectFiles() {
    }

    public static PackageData loadSingleFileProjectPackageData(Path filePath) {
        DocumentData documentData = ProjectFiles.loadDocument(filePath);
        ModuleData defaultModule = ModuleData.from(filePath, ".", Collections.singletonList(documentData), Collections.emptyList());
        return PackageData.from(filePath, defaultModule, Collections.emptyList());
    }

    public static PackageData loadBuildProjectPackageData(Path packageDirPath) {
        ModuleData defaultModule = ProjectFiles.loadModule(packageDirPath);
        List<ModuleData> otherModules = ProjectFiles.loadOtherModules(packageDirPath);
        return PackageData.from(packageDirPath, defaultModule, otherModules);
    }

    private static List<ModuleData> loadOtherModules(Path packageDirPath) {
        List<ModuleData> list;
        block9: {
            Path modulesDirPath = packageDirPath.resolve("modules");
            if (!Files.isDirectory(modulesDirPath, new LinkOption[0])) {
                return Collections.emptyList();
            }
            Stream<Path> pathStream = Files.walk(modulesDirPath, 1, new FileVisitOption[0]);
            try {
                list = pathStream.filter(path -> !path.equals(modulesDirPath)).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(path -> {
                    if (!ProjectUtils.validateModuleName(path.toFile().getName())) {
                        throw new ProjectException("Invalid module name : '" + path.getFileName() + "' :\nModule name can only contain alphanumerics, underscores and periods and the maximum length is 256 characters");
                    }
                    return true;
                }).map(ProjectFiles::loadModule).collect(Collectors.toList());
                if (pathStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (pathStream != null) {
                        try {
                            pathStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ProjectException(e);
                }
            }
            pathStream.close();
        }
        return list;
    }

    private static ModuleData loadModule(Path moduleDirPath) {
        List<DocumentData> srcDocs = ProjectFiles.loadDocuments(moduleDirPath);
        Path testDirPath = moduleDirPath.resolve("tests");
        List<DocumentData> testSrcDocs = Files.isDirectory(testDirPath, new LinkOption[0]) ? ProjectFiles.loadTestDocuments(testDirPath) : Collections.emptyList();
        return ModuleData.from(moduleDirPath, moduleDirPath.toFile().getName(), srcDocs, testSrcDocs);
    }

    public static List<DocumentData> loadDocuments(Path dirPath) {
        List<DocumentData> list;
        block8: {
            Stream<Path> pathStream = Files.walk(dirPath, 1, new FileVisitOption[0]);
            try {
                list = pathStream.filter(BAL_EXTENSION_MATCHER::matches).map(ProjectFiles::loadDocument).collect(Collectors.toList());
                if (pathStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (pathStream != null) {
                        try {
                            pathStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ProjectException(e);
                }
            }
            pathStream.close();
        }
        return list;
    }

    private static List<DocumentData> loadTestDocuments(Path dirPath) {
        List<DocumentData> list;
        block8: {
            Stream<Path> pathStream = Files.walk(dirPath, 1, new FileVisitOption[0]);
            try {
                list = pathStream.filter(BAL_EXTENSION_MATCHER::matches).map(ProjectFiles::loadTestDocument).collect(Collectors.toList());
                if (pathStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (pathStream != null) {
                        try {
                            pathStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ProjectException(e);
                }
            }
            pathStream.close();
        }
        return list;
    }

    public static DocumentData loadDocument(Path documentFilePath) {
        String content;
        try {
            content = Files.readString(documentFilePath, Charset.defaultCharset());
        }
        catch (IOException e) {
            throw new ProjectException(e);
        }
        return DocumentData.from(Optional.of(documentFilePath.getFileName()).get().toString(), content);
    }

    private static DocumentData loadTestDocument(Path documentFilePath) {
        String content;
        try {
            content = Files.readString(documentFilePath, Charset.defaultCharset());
        }
        catch (IOException e) {
            throw new ProjectException(e);
        }
        String documentName = Optional.of(documentFilePath.getFileName()).get().toString();
        return DocumentData.from("tests/" + documentName, content);
    }

    public static PackageManifest createPackageManifest(Path ballerinaTomlFilePath) {
        return BallerinaTomlProcessor.parseAsPackageManifest(ballerinaTomlFilePath);
    }

    public static BuildOptions createBuildOptions(Path projectPath, BuildOptions theirOptions) {
        Path ballerinaTomlFilePath = projectPath.resolve("Ballerina.toml");
        BuildOptions defaultBuildOptions = BallerinaTomlProcessor.parse(ballerinaTomlFilePath).getBuildOptions();
        if (defaultBuildOptions == null) {
            defaultBuildOptions = new BuildOptionsBuilder().build();
        }
        return defaultBuildOptions.acceptTheirs(theirOptions);
    }

    public static void validateBuildProjectDirPath(Path projectDirPath) {
        if (Files.notExists(projectDirPath, new LinkOption[0])) {
            throw new ProjectException("The directory does not exist: " + projectDirPath);
        }
        if (!Files.isDirectory(projectDirPath, new LinkOption[0])) {
            throw new ProjectException("Invalid Ballerina package directory: " + projectDirPath);
        }
        if (!ProjectUtils.isBallerinaProject(projectDirPath)) {
            throw new ProjectException("Invalid Ballerina package directory: " + projectDirPath + ", cannot find 'Ballerina.toml' file.");
        }
        if (ProjectUtils.findProjectRoot(projectDirPath.toAbsolutePath().getParent()) != null) {
            throw new ProjectException("Provided path is already within a Ballerina package: " + projectDirPath);
        }
        if (!(projectDirPath.toFile().canRead() && projectDirPath.toFile().canWrite() && projectDirPath.toFile().canExecute())) {
            throw new ProjectException("Insufficient privileges to path: " + projectDirPath);
        }
    }

    public static void validateSingleFileProjectFilePath(Path filePath) {
        if (Files.notExists(filePath, new LinkOption[0])) {
            throw new ProjectException("The file does not exist: " + filePath);
        }
        if (!Files.isRegularFile(filePath, new LinkOption[0]) || !BAL_EXTENSION_MATCHER.matches(filePath)) {
            throw new ProjectException("Invalid Ballerina source file(.bal): " + filePath);
        }
        Path projectRoot = ProjectUtils.findProjectRoot(filePath);
        if (null != projectRoot) {
            Path absFilePath = filePath.toAbsolutePath();
            if (projectRoot.equals(Optional.of(absFilePath.getParent()).get())) {
                throw new ProjectException("The source file '" + filePath + "' belongs to a Ballerina package.");
            }
            Path modulesRoot = projectRoot.resolve("modules");
            Path parent = absFilePath.getParent();
            if (parent != null && modulesRoot.equals(Optional.of(parent.getParent()).get())) {
                throw new ProjectException("The source file '" + filePath + "' belongs to a Ballerina package.");
            }
        }
    }

    public static void validateBalrProjectPath(Path balrPath) {
        if (Files.notExists(balrPath, new LinkOption[0])) {
            throw new ProjectException("Given .balr file does not exist: " + balrPath);
        }
        if (!Files.isRegularFile(balrPath, new LinkOption[0]) || !BALR_EXTENSION_MATCHER.matches(balrPath)) {
            throw new ProjectException("Invalid .balr file: " + balrPath);
        }
        if (!balrPath.toFile().canRead()) {
            throw new ProjectException("insufficient privileges to balo: " + balrPath);
        }
    }
}

