/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.internal.repositories;

import io.ballerina.projects.JdkVersion;
import io.ballerina.projects.Package;
import io.ballerina.projects.PackageVersion;
import io.ballerina.projects.ProjectEnvironmentBuilder;
import io.ballerina.projects.balo.BaloProject;
import io.ballerina.projects.environment.Environment;
import io.ballerina.projects.environment.PackageRepository;
import io.ballerina.projects.environment.ResolutionRequest;
import io.ballerina.projects.repos.FileSystemCache;
import io.ballerina.projects.util.ProjectUtils;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class FileSystemRepository
implements PackageRepository {
    Path balo;
    private final Path cacheDir;
    private final Environment environment;

    public FileSystemRepository(Environment environment, Path cacheDirectory) {
        this.cacheDir = cacheDirectory;
        this.balo = cacheDirectory.resolve("balo");
        this.environment = environment;
    }

    @Override
    public Optional<Package> getPackage(ResolutionRequest resolutionRequest) {
        String packageName = resolutionRequest.packageName().value();
        String orgName = resolutionRequest.orgName().value();
        String version = resolutionRequest.version().isPresent() ? resolutionRequest.version().get().toString() : "0.0.0";
        String baloName = ProjectUtils.getBaloName(orgName, packageName, version, null);
        Path baloPath = this.balo.resolve(orgName).resolve(packageName).resolve(version).resolve(baloName);
        if (!Files.exists(baloPath, new LinkOption[0])) {
            String javaBaloName = ProjectUtils.getBaloName(orgName, packageName, version, JdkVersion.JAVA_11.code());
            baloPath = this.balo.resolve(orgName).resolve(packageName).resolve(version).resolve(javaBaloName);
            if (!Files.exists(baloPath, new LinkOption[0])) {
                return Optional.empty();
            }
        }
        ProjectEnvironmentBuilder environmentBuilder = ProjectEnvironmentBuilder.getBuilder(this.environment);
        environmentBuilder = environmentBuilder.addCompilationCacheFactory(new FileSystemCache.FileSystemCacheFactory(this.cacheDir));
        BaloProject project = BaloProject.loadProject(environmentBuilder, baloPath);
        return Optional.of(project.currentPackage());
    }

    @Override
    public List<PackageVersion> getPackageVersions(ResolutionRequest resolutionRequest) {
        String packageName = resolutionRequest.packageName().value();
        String orgName = resolutionRequest.orgName().value();
        String globFilePart = orgName + "-" + packageName + "-*.balo";
        String glob = "glob:**/" + orgName + "/" + packageName + "/*/" + globFilePart;
        PathMatcher pathMatcher = FileSystems.getDefault().getPathMatcher(glob);
        ArrayList<Path> versions = new ArrayList<Path>();
        try {
            Files.walkFileTree(this.balo.resolve(orgName).resolve(packageName), new SearchModules(pathMatcher, versions));
        }
        catch (IOException e) {
            throw new RuntimeException("Error while accessing Distribution cache: " + e.getMessage());
        }
        return this.pathToVersions(versions);
    }

    @Override
    public Map<String, List<String>> getPackages() {
        HashMap<String, List<String>> packagesMap = new HashMap<String, List<String>>();
        File[] orgDirs = this.balo.toFile().listFiles();
        if (orgDirs == null) {
            return packagesMap;
        }
        for (File file : orgDirs) {
            if (!file.isDirectory()) continue;
            String orgName = file.getName();
            File[] filesList = this.balo.resolve(orgName).toFile().listFiles();
            if (filesList == null) {
                return packagesMap;
            }
            ArrayList<CallSite> pkgList = new ArrayList<CallSite>();
            for (File pkgDir : filesList) {
                File[] pkgs;
                if (!pkgDir.isDirectory() || pkgDir.isHidden() || (pkgs = this.balo.resolve(orgName).resolve(pkgDir.getName()).toFile().listFiles()) == null) continue;
                String version = "";
                for (File listFile : pkgs) {
                    if (listFile.isHidden() || !listFile.isDirectory()) continue;
                    version = listFile.getName();
                    break;
                }
                pkgList.add((CallSite)((Object)(pkgDir.getName() + ":" + version)));
            }
            packagesMap.put(orgName, pkgList);
        }
        return packagesMap;
    }

    private List<PackageVersion> pathToVersions(List<Path> versions) {
        return versions.stream().map(path -> {
            String version = Optional.ofNullable(path.getParent()).map(parent -> parent.getFileName()).map(file -> file.toString()).orElse("0.0.0");
            return PackageVersion.from(version);
        }).collect(Collectors.toList());
    }

    private static class SearchModules
    extends SimpleFileVisitor<Path> {
        private final PathMatcher pathMatcher;
        private final List<Path> versions;

        public SearchModules(PathMatcher pathMatcher, List<Path> versions) {
            this.pathMatcher = pathMatcher;
            this.versions = versions;
        }

        @Override
        public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
            if (this.pathMatcher.matches(path)) {
                this.versions.add(path);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
            return FileVisitResult.CONTINUE;
        }
    }
}

