/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.api;

import io.ballerina.runtime.api.Future;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.Runtime;
import io.ballerina.runtime.api.async.StrandMetadata;
import io.ballerina.runtime.internal.scheduling.State;
import io.ballerina.runtime.internal.scheduling.Strand;
import java.util.Optional;

public class Environment {
    private Strand strand;
    private Module currentModule;

    public Environment(Strand strand) {
        this.strand = strand;
    }

    public Environment(Strand strand, Module currentModule) {
        this.strand = strand;
        this.currentModule = currentModule;
    }

    public Future markAsync() {
        this.strand.blockedOnExtern = true;
        this.strand.setState(State.BLOCK_AND_YIELD);
        return new Future(this.strand);
    }

    public Runtime getRuntime() {
        return new Runtime(this.strand.scheduler);
    }

    public Module getCurrentModule() {
        return this.currentModule;
    }

    public int getStrandId() {
        return this.strand.getId();
    }

    public Optional<String> getStrandName() {
        return this.strand.getName();
    }

    public StrandMetadata getStrandMetadata() {
        return this.strand.getMetadata();
    }

    public void setStrandLocal(String key, Object value) {
        this.strand.setProperty(key, value);
    }

    public Object getStrandLocal(String key) {
        return this.strand.getProperty(key);
    }
}

