/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.api.creators;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.FunctionType;
import io.ballerina.runtime.api.types.MapType;
import io.ballerina.runtime.api.types.StreamType;
import io.ballerina.runtime.api.types.TableType;
import io.ballerina.runtime.api.types.TupleType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BDecimal;
import io.ballerina.runtime.api.values.BFunctionPointer;
import io.ballerina.runtime.api.values.BHandle;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BMapInitialValueEntry;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BStream;
import io.ballerina.runtime.api.values.BStreamingJson;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTable;
import io.ballerina.runtime.api.values.BTypedesc;
import io.ballerina.runtime.api.values.BXml;
import io.ballerina.runtime.api.values.BXmlItem;
import io.ballerina.runtime.api.values.BXmlQName;
import io.ballerina.runtime.api.values.BXmlSequence;
import io.ballerina.runtime.internal.DecimalValueKind;
import io.ballerina.runtime.internal.JsonDataSource;
import io.ballerina.runtime.internal.ValueUtils;
import io.ballerina.runtime.internal.XmlFactory;
import io.ballerina.runtime.internal.values.ArrayValueImpl;
import io.ballerina.runtime.internal.values.DecimalValue;
import io.ballerina.runtime.internal.values.FPValue;
import io.ballerina.runtime.internal.values.HandleValue;
import io.ballerina.runtime.internal.values.MapValueImpl;
import io.ballerina.runtime.internal.values.MappingInitialValueEntry;
import io.ballerina.runtime.internal.values.StreamValue;
import io.ballerina.runtime.internal.values.StreamingJsonValue;
import io.ballerina.runtime.internal.values.TableValueImpl;
import io.ballerina.runtime.internal.values.TupleValueImpl;
import io.ballerina.runtime.internal.values.TypedescValueImpl;
import io.ballerina.runtime.internal.values.XmlItem;
import io.ballerina.runtime.internal.values.XmlQName;
import io.ballerina.runtime.internal.values.XmlSequence;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.xml.namespace.QName;

public class ValueCreator {
    public static BArray createArrayValue(ArrayType type) {
        return new ArrayValueImpl(type);
    }

    public static BArray createTupleValue(TupleType type) {
        return new TupleValueImpl(type);
    }

    public static BArray createArrayValue(long[] values) {
        return new ArrayValueImpl(values);
    }

    public static BArray createArrayValue(boolean[] values) {
        return new ArrayValueImpl(values);
    }

    public static BArray createArrayValue(byte[] values) {
        return new ArrayValueImpl(values);
    }

    public static BArray createArrayValue(double[] values) {
        return new ArrayValueImpl(values);
    }

    public static BArray createArrayValue(BString[] values) {
        return new ArrayValueImpl(values);
    }

    public static BArray createArrayValue(Object[] values, ArrayType type) {
        return new ArrayValueImpl(values, type);
    }

    public static BArray createArrayValue(ArrayType type, int length) {
        return new ArrayValueImpl(type, length);
    }

    public static BDecimal createDecimalValue(BigDecimal value) {
        return new DecimalValue(value);
    }

    public static BDecimal createDecimalValue(String value) {
        return new DecimalValue(value);
    }

    public static BDecimal createDecimalValue(String value, DecimalValueKind valueKind) {
        return new DecimalValue(value, valueKind);
    }

    public static BFunctionPointer createFPValue(Function function, FunctionType type) {
        return new FPValue(function, type, null, false);
    }

    public static BFunctionPointer createFPValue(Function function, FunctionType type, String strandName) {
        return new FPValue(function, type, strandName, false);
    }

    public static BStreamingJson createStreamingJsonValue(JsonDataSource datasource) {
        return new StreamingJsonValue(datasource);
    }

    public static BStream createStreamValue(StreamType type) {
        return new StreamValue(type);
    }

    public static BStream createStreamValue(StreamType type, BObject iteratorObj) {
        return new StreamValue(type, iteratorObj);
    }

    public static BTypedesc createTypedescValue(Type describingType) {
        return new TypedescValueImpl(describingType);
    }

    public static BXmlItem createXmlItem() {
        return new XmlItem(new QName(null), new XmlSequence());
    }

    public static BXmlItem createXmlItem(QName name, BXmlSequence children) {
        return new XmlItem(name, (XmlSequence)children);
    }

    public static BXmlItem createXmlItem(QName name) {
        return new XmlItem(name);
    }

    public static BXmlItem createXmlItem(QName name, boolean readonly) {
        return new XmlItem(name, readonly);
    }

    public static BXmlItem createXmlItem(QName name, BXmlSequence children, boolean readonly) {
        return new XmlItem(name, (XmlSequence)children, readonly);
    }

    public static BXml createXmlValue(String xmlValue) {
        return XmlFactory.parse(xmlValue);
    }

    public static BXml createXmlValue(InputStream inputStream) {
        return XmlFactory.parse(inputStream);
    }

    @Deprecated
    public static BXml createXmlValue(BXmlQName startTagName, BXmlQName endTagName, String defaultNsUri) {
        return XmlFactory.createXMLElement(startTagName, endTagName, defaultNsUri);
    }

    @Deprecated
    public static BXml createXmlValue(BXmlQName startTagName, String defaultNsUri) {
        return XmlFactory.createXMLElement(startTagName, defaultNsUri);
    }

    public static BXml createXmlValue(BXmlQName startTagName, BString defaultNsUriVal) {
        return XmlFactory.createXMLElement(startTagName, defaultNsUriVal);
    }

    @Deprecated
    public static BXml createXmlValue(BXmlQName startTagName, String defaultNsUri, boolean readonly) {
        return XmlFactory.createXMLElement(startTagName, defaultNsUri, readonly);
    }

    public static BXml createXmlValue(BXmlQName startTagName, BString defaultNsUriVal, boolean readonly) {
        return XmlFactory.createXMLElement(startTagName, defaultNsUriVal, readonly);
    }

    public static BXmlQName createXmlQName(String localName, String uri, String prefix) {
        return new XmlQName(localName, uri, prefix);
    }

    public static BXmlQName createXmlQName(BString localName, BString uri, BString prefix) {
        return new XmlQName(localName, uri, prefix);
    }

    public static BXmlQName createXmlQName(String qNameStr) {
        return new XmlQName(qNameStr);
    }

    public static BXmlQName createXmlQName(BString qNameStr) {
        return new XmlQName(qNameStr);
    }

    public static BXmlSequence createXmlSequence() {
        return new XmlSequence();
    }

    public static BXmlSequence createXmlSequence(BArray sequence) {
        ArrayList<BXml> children = new ArrayList<BXml>();
        for (Object value : sequence.getValues()) {
            children.add((BXml)value);
        }
        return new XmlSequence(children);
    }

    public static BXmlSequence createXmlSequence(List<BXml> sequence) {
        return new XmlSequence(sequence);
    }

    public static BXmlSequence createXmlSequence(BXml child) {
        return new XmlSequence(child);
    }

    @Deprecated
    public static BXml createXmlComment(String content) {
        return XmlFactory.createXMLComment(content);
    }

    public static BXml createXmlComment(BString content) {
        return XmlFactory.createXMLComment(content.getValue());
    }

    @Deprecated
    public static BXml createXmlComment(String content, boolean readonly) {
        return XmlFactory.createXMLComment(content, readonly);
    }

    public static BXml createXmlComment(BString content, boolean readonly) {
        return XmlFactory.createXMLComment(content, readonly);
    }

    @Deprecated
    public static BXml createXmlText(String content) {
        return XmlFactory.createXMLText(content);
    }

    public static BXml createXmlText(BString content) {
        return XmlFactory.createXMLText(content);
    }

    @Deprecated
    public static BXml createXmlProcessingInstruction(String tartget, String data) {
        return XmlFactory.createXMLProcessingInstruction(data, tartget);
    }

    public static BXml createXmlProcessingInstruction(BString tartget, BString data) {
        return XmlFactory.createXMLProcessingInstruction(tartget, data);
    }

    @Deprecated
    public static BXml createXmlProcessingInstruction(String target, String data, boolean readonly) {
        return XmlFactory.createXMLProcessingInstruction(data, target, readonly);
    }

    public static BXml createXmlProcessingInstruction(BString target, BString data, boolean readonly) {
        return XmlFactory.createXMLProcessingInstruction(target, data, readonly);
    }

    public static BMap<BString, Object> createMapValue() {
        return new MapValueImpl<BString, Object>();
    }

    public static BMap<BString, Object> createMapValue(Type mapType) {
        return new MapValueImpl<BString, Object>(mapType);
    }

    public static BMap<BString, Object> createMapValue(MapType mapType, BMapInitialValueEntry[] keyValues) {
        return new MapValueImpl<BString, Object>(mapType, keyValues);
    }

    public static BMapInitialValueEntry createKeyFieldEntry(Object key, Object value) {
        return new MappingInitialValueEntry.KeyValueEntry(key, value);
    }

    public static BMapInitialValueEntry createSpreadFieldEntry(BMap mappingValue) {
        return new MappingInitialValueEntry.SpreadFieldEntry(mappingValue);
    }

    public static BMap<BString, Object> createRecordValue(Module packageId, String recordTypeName) {
        return ValueUtils.createRecordValue(packageId, recordTypeName);
    }

    public static BMap<BString, Object> createRecordValue(Module packageId, String recordTypeName, Map<String, Object> valueMap) {
        return ValueUtils.createRecordValue(packageId, recordTypeName, valueMap);
    }

    public static BMap<BString, Object> createRecordValue(BMap<BString, Object> record, Object ... values) {
        return ValueUtils.createRecordValue(record, values);
    }

    public static BObject createObjectValue(Module packageId, String objectTypeName, Object ... fieldValues) {
        return ValueUtils.createObjectValue(packageId, objectTypeName, fieldValues);
    }

    public static BHandle createHandleValue(Object value) {
        return new HandleValue(value);
    }

    public static BTable createTableValue(TableType tableType) {
        return new TableValueImpl(tableType);
    }
}

