/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.api.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;

public class IdentifierUtils {
    private static final String UNICODE_REGEX = "\\\\u\\{([a-fA-F0-9]+)\\}";
    public static final Pattern UNICODE_PATTERN = Pattern.compile("\\\\u\\{([a-fA-F0-9]+)\\}");
    private static final String CHAR_PREFIX = "$";
    private static final String ESCAPE_PREFIX = "\\";
    private static final String JVM_RESERVED_CHAR_SET = "\\.:;[]/<>";
    private static final String ENCODABLE_CHAR_SET = "\\.:;[]/<>$";
    private static final Pattern UNESCAPED_SPECIAL_CHAR_SET = Pattern.compile("(?<!\\\\)(?:\\\\\\\\)*([$&+,:;=\\?@#|/' \\[\\}\\]<\\>.\"^*{}~`()%!-])");
    private static final String GENERATED_METHOD_PREFIX = "$gen$";

    private IdentifierUtils() {
    }

    private static String encodeSpecialCharacters(String identifier) {
        StringBuilder sb = new StringBuilder();
        int index = 0;
        while (index < identifier.length()) {
            if (IdentifierUtils.isQuotedIdentifier(identifier, index)) {
                String unicodePoint = CHAR_PREFIX + String.format("%04d", identifier.charAt(index + 1));
                sb.append(unicodePoint);
                index += 2;
                continue;
            }
            sb.append(identifier.charAt(index));
            ++index;
        }
        return sb.toString();
    }

    private static boolean isEncodableGeneratedIdentifer(String identifier, int index) {
        return JVM_RESERVED_CHAR_SET.contains(Character.toString(identifier.charAt(index)));
    }

    private static boolean isQuotedIdentifier(String identifier, int index) {
        return identifier.charAt(index) == '\\' && index + 1 < identifier.length() && ENCODABLE_CHAR_SET.contains(Character.toString(identifier.charAt(index + 1)));
    }

    public static String escapeSpecialCharacters(String identifier) {
        return UNESCAPED_SPECIAL_CHAR_SET.matcher(identifier).replaceAll("\\\\$1");
    }

    private static String encodeIdentifier(String identifier) {
        if (identifier.contains(ESCAPE_PREFIX)) {
            identifier = IdentifierUtils.encodeSpecialCharacters(identifier);
        }
        return StringEscapeUtils.unescapeJava(identifier);
    }

    private static Identifier encodeGeneratedName(String identifier) {
        StringBuilder sb = new StringBuilder();
        boolean isEncoded = false;
        for (int index = 0; index < identifier.length(); ++index) {
            if (IdentifierUtils.isEncodableGeneratedIdentifer(identifier, index)) {
                String unicodePoint = CHAR_PREFIX + String.format("%04d", identifier.charAt(index));
                sb.append(unicodePoint);
                isEncoded = true;
                continue;
            }
            sb.append(identifier.charAt(index));
        }
        return new Identifier(sb.toString(), isEncoded);
    }

    public static String decodeIdentifier(String encodedIdentifier) {
        if (encodedIdentifier == null) {
            return encodedIdentifier;
        }
        StringBuilder sb = new StringBuilder();
        int index = 0;
        while (index < encodedIdentifier.length()) {
            if (encodedIdentifier.charAt(index) == '$' && index + 4 < encodedIdentifier.length()) {
                if (IdentifierUtils.isUnicodePoint(encodedIdentifier, index)) {
                    sb.append((char)Integer.parseInt(encodedIdentifier.substring(index + 1, index + 5)));
                    index += 5;
                    continue;
                }
                sb.append(encodedIdentifier.charAt(index));
                ++index;
                continue;
            }
            sb.append(encodedIdentifier.charAt(index));
            ++index;
        }
        return IdentifierUtils.decodeGeneratedMethodName(sb.toString());
    }

    private static String decodeGeneratedMethodName(String decodedName) {
        return decodedName.startsWith(GENERATED_METHOD_PREFIX) ? decodedName.substring(GENERATED_METHOD_PREFIX.length()) : decodedName;
    }

    public static String unescapeUnicodeCodepoints(String identifier) {
        Matcher matcher = UNICODE_PATTERN.matcher(identifier);
        StringBuffer buffer = new StringBuffer(identifier.length());
        while (matcher.find()) {
            String ch = String.valueOf((char)Integer.parseInt(matcher.group(1), 16));
            matcher.appendReplacement(buffer, Matcher.quoteReplacement(ch));
        }
        matcher.appendTail(buffer);
        return String.valueOf(buffer);
    }

    private static boolean isUnicodePoint(String encodedName, int index) {
        return IdentifierUtils.containsOnlyDigits(encodedName.substring(index + 1, index + 5));
    }

    private static boolean containsOnlyDigits(String digitString) {
        for (int i = 0; i < digitString.length(); ++i) {
            if (Character.isDigit(digitString.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String encodeFunctionIdentifier(String functionName) {
        functionName = IdentifierUtils.encodeIdentifier(functionName);
        Identifier encodedName = IdentifierUtils.encodeGeneratedName(functionName);
        return encodedName.isEncoded ? GENERATED_METHOD_PREFIX + encodedName.name : functionName;
    }

    public static String encodeNonFunctionIdentifier(String pkgName) {
        pkgName = IdentifierUtils.encodeIdentifier(pkgName);
        Identifier encodedName = IdentifierUtils.encodeGeneratedName(pkgName);
        return encodedName.name;
    }

    private static class Identifier {
        boolean isEncoded;
        String name;

        Identifier(String name, boolean isEncoded) {
            this.name = name;
            this.isEncoded = isEncoded;
        }
    }
}

