/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal;

import io.ballerina.runtime.api.types.MemberFunctionType;
import io.ballerina.runtime.api.types.ResourceFunctionType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.scheduling.Strand;
import io.ballerina.runtime.internal.types.BAnnotatableType;
import io.ballerina.runtime.internal.types.BMemberFunctionType;
import io.ballerina.runtime.internal.types.BObjectType;
import io.ballerina.runtime.internal.types.BServiceType;
import io.ballerina.runtime.internal.values.FPValue;
import io.ballerina.runtime.internal.values.MapValue;

public class AnnotationUtils {
    public static void processAnnotations(MapValue globalAnnotMap, Type bType, Strand strand) {
        if (!(bType instanceof BAnnotatableType)) {
            return;
        }
        BAnnotatableType type = (BAnnotatableType)bType;
        BString annotationKey = StringUtils.fromString(type.getAnnotationKey());
        if (globalAnnotMap.containsKey(annotationKey)) {
            type.setAnnotations((MapValue)globalAnnotMap.get(annotationKey));
        }
        if (type.getTag() != 35) {
            return;
        }
        BObjectType objectType = (BObjectType)type;
        for (MemberFunctionType attachedFunction : objectType.getAttachedFunctions()) {
            annotationKey = StringUtils.fromString(attachedFunction.getAnnotationKey());
            if (!globalAnnotMap.containsKey(annotationKey)) continue;
            ((BMemberFunctionType)attachedFunction).setAnnotations((MapValue)globalAnnotMap.get(annotationKey));
        }
    }

    public static void processObjectCtorAnnotations(MapValue globalAnnotMap, BObjectType bType, Strand strand) {
        BString annotationKey = StringUtils.fromString(bType.getAnnotationKey());
        if (globalAnnotMap.containsKey(annotationKey)) {
            Object v = globalAnnotMap.get(annotationKey);
            Object annotValue = ((FPValue)v).call(new Object[]{strand});
            bType.setAnnotations((MapValue)annotValue);
        }
        for (MemberFunctionType attachedFunction : bType.getAttachedFunctions()) {
            AnnotationUtils.processObjectMethodLambdaAnnotation(globalAnnotMap, strand, attachedFunction);
        }
        if (bType instanceof BServiceType) {
            BServiceType bServiceType = (BServiceType)bType;
            for (ResourceFunctionType resourceFunction : bServiceType.getResourceFunctions()) {
                AnnotationUtils.processObjectMethodLambdaAnnotation(globalAnnotMap, strand, resourceFunction);
            }
        }
    }

    private static void processObjectMethodLambdaAnnotation(MapValue globalAnnotMap, Strand strand, MemberFunctionType attachedFunction) {
        BString annotationKey = StringUtils.fromString(attachedFunction.getAnnotationKey());
        if (globalAnnotMap.containsKey(annotationKey)) {
            ((BMemberFunctionType)attachedFunction).setAnnotations((MapValue)((FPValue)globalAnnotMap.get(annotationKey)).call(new Object[]{strand}));
        }
    }

    public static void processFPValueAnnotations(FPValue fpValue, MapValue globalAnnotMap, String name) {
        BAnnotatableType type = (BAnnotatableType)fpValue.getType();
        BString nameKey = StringUtils.fromString(name);
        if (globalAnnotMap.containsKey(nameKey)) {
            type.setAnnotations((MapValue)globalAnnotMap.get(nameKey));
        }
    }

    public static boolean isConcurrent(FPValue fpValue) {
        return fpValue.isConcurrent;
    }

    public static String getStrandName(FPValue fpValue, String defaultName) {
        if (fpValue.strandName != null) {
            return fpValue.strandName;
        }
        return defaultName;
    }
}

