/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal;

import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.util.exceptions.BallerinaErrorReasons;

public class MathUtils {
    private static final BString DIVIDE_BY_ZERO_ERROR = StringUtils.fromString(" / by zero");
    private static final BString INT_RANGE_OVERFLOW_ERROR = StringUtils.fromString(" int range overflow");

    public static long divide(long numerator, long denominator) {
        try {
            if (numerator == Long.MIN_VALUE && denominator == -1L) {
                throw ErrorCreator.createError(BallerinaErrorReasons.NUMBER_OVERFLOW, INT_RANGE_OVERFLOW_ERROR);
            }
            return numerator / denominator;
        }
        catch (ArithmeticException e) {
            if (denominator == 0L) {
                throw ErrorCreator.createError(BallerinaErrorReasons.DIVISION_BY_ZERO_ERROR, DIVIDE_BY_ZERO_ERROR);
            }
            throw ErrorCreator.createError(BallerinaErrorReasons.ARITHMETIC_OPERATION_ERROR, StringUtils.fromString(e.getMessage()));
        }
    }

    public static long remainder(long numerator, long denominator) {
        try {
            return numerator % denominator;
        }
        catch (ArithmeticException e) {
            if (denominator == 0L) {
                throw ErrorCreator.createError(BallerinaErrorReasons.DIVISION_BY_ZERO_ERROR, DIVIDE_BY_ZERO_ERROR);
            }
            throw ErrorCreator.createError(BallerinaErrorReasons.ARITHMETIC_OPERATION_ERROR, StringUtils.fromString(e.getMessage()));
        }
    }
}

