/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal;

import io.ballerina.runtime.api.PredefinedTypes;
import io.ballerina.runtime.api.types.Field;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BIterator;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTable;
import io.ballerina.runtime.internal.JsonDataSource;
import io.ballerina.runtime.internal.JsonGenerator;
import io.ballerina.runtime.internal.JsonParser;
import io.ballerina.runtime.internal.types.BArrayType;
import io.ballerina.runtime.internal.types.BField;
import io.ballerina.runtime.internal.types.BMapType;
import io.ballerina.runtime.internal.types.BStructureType;
import io.ballerina.runtime.internal.util.exceptions.BallerinaException;
import io.ballerina.runtime.internal.values.ArrayValueImpl;
import io.ballerina.runtime.internal.values.DecimalValue;
import io.ballerina.runtime.internal.values.MapValue;
import io.ballerina.runtime.internal.values.MapValueImpl;
import io.ballerina.runtime.internal.values.TupleValueImpl;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.Map;

public class TableJsonDataSource
implements JsonDataSource {
    private BTable tableValue;
    private JSONObjectGenerator objGen;

    public TableJsonDataSource(BTable tableValue) {
        this(tableValue, new DefaultJSONObjectGenerator());
    }

    private TableJsonDataSource(BTable tableValue, JSONObjectGenerator objGen) {
        this.tableValue = tableValue;
        this.objGen = objGen;
    }

    @Override
    public void serialize(JsonGenerator gen) throws IOException {
        gen.writeStartArray();
        while (this.hasNext()) {
            gen.serialize(this.next());
        }
        gen.writeEndArray();
    }

    @Override
    public boolean hasNext() {
        return this.tableValue.getIterator().hasNext();
    }

    @Override
    public Object next() {
        return this.tableValue.getIterator().next();
    }

    @Override
    public Object build() {
        ArrayValueImpl values = new ArrayValueImpl(new BArrayType(PredefinedTypes.TYPE_JSON));
        BIterator<?> itr = this.tableValue.getIterator();
        while (itr.hasNext()) {
            TupleValueImpl tupleValue = (TupleValueImpl)itr.next();
            MapValueImpl record = (MapValueImpl)tupleValue.get(0L);
            try {
                values.append(this.objGen.transform(record));
            }
            catch (IOException e) {
                throw new BallerinaException(e);
            }
        }
        return values;
    }

    private static void constructJsonData(MapValueImpl record, MapValue<BString, Object> jsonObject, String name, int typeTag, BField[] structFields, int index) {
        BString key = StringUtils.fromString(name);
        switch (typeTag) {
            case 5: {
                jsonObject.put(StringUtils.fromString(name), record.getStringValue(key));
                break;
            }
            case 1: {
                Long intVal = record.getIntValue(key);
                jsonObject.put(StringUtils.fromString(name), intVal);
                break;
            }
            case 3: {
                Double floatVal = record.getFloatValue(key);
                jsonObject.put(StringUtils.fromString(name), floatVal);
                break;
            }
            case 4: {
                DecimalValue decimalVal = (DecimalValue)record.get(key);
                jsonObject.put(StringUtils.fromString(name), decimalVal);
                break;
            }
            case 6: {
                Boolean boolVal = record.getBooleanValue(key);
                jsonObject.put(StringUtils.fromString(name), boolVal);
                break;
            }
            case 20: {
                jsonObject.put(StringUtils.fromString(name), TableJsonDataSource.getDataArray(record, key));
                break;
            }
            case 7: {
                jsonObject.put(StringUtils.fromString(name), record.getStringValue(key) == null ? null : JsonParser.parse(record.getStringValue(key).toString()));
                break;
            }
            case 12: 
            case 35: {
                jsonObject.put(StringUtils.fromString(name), TableJsonDataSource.getStructData(record.getMapValue(key), structFields, index, key));
                break;
            }
            case 8: {
                BString strVal = StringUtils.fromString(StringUtils.getStringValue(record.get(key), null));
                jsonObject.put(StringUtils.fromString(name), strVal);
                break;
            }
            default: {
                jsonObject.put(StringUtils.fromString(name), record.getStringValue(key));
            }
        }
    }

    private static Object getStructData(BMap data, BField[] structFields, int index, BString key) {
        Type internalType;
        if (structFields == null) {
            ArrayValueImpl jsonArray = new ArrayValueImpl(new BArrayType(PredefinedTypes.TYPE_JSON));
            if (data != null) {
                BArray dataArray = data.getArrayValue(key);
                for (int i = 0; i < dataArray.size(); ++i) {
                    Object value = dataArray.get(i);
                    if (value instanceof String) {
                        jsonArray.append(value);
                        continue;
                    }
                    if (value instanceof Boolean) {
                        jsonArray.append(value);
                        continue;
                    }
                    if (value instanceof Long) {
                        jsonArray.append(value);
                        continue;
                    }
                    if (value instanceof Double) {
                        jsonArray.append(value);
                        continue;
                    }
                    if (value instanceof Integer) {
                        jsonArray.append(value);
                        continue;
                    }
                    if (value instanceof Float) {
                        jsonArray.append(value);
                        continue;
                    }
                    if (!(value instanceof DecimalValue)) continue;
                    jsonArray.append(((DecimalValue)value).floatValue());
                }
            }
            return jsonArray;
        }
        MapValueImpl<BString, Object> jsonData = new MapValueImpl<BString, Object>(new BMapType(PredefinedTypes.TYPE_JSON));
        boolean structError = true;
        if (data != null && ((internalType = structFields[index].type).getTag() == 35 || internalType.getTag() == 12)) {
            BField[] internalStructFields = ((BStructureType)internalType).getFields().values().toArray(new BField[0]);
            for (int i = 0; i < internalStructFields.length; ++i) {
                BString internalKeyName = StringUtils.fromString(internalStructFields[i].name);
                Object value = data.get(internalKeyName);
                if (value instanceof BigDecimal) {
                    jsonData.put(StringUtils.fromString(internalStructFields[i].name), ((BigDecimal)value).doubleValue());
                } else if (value instanceof MapValueImpl) {
                    jsonData.put(StringUtils.fromString(internalStructFields[i].name), TableJsonDataSource.getStructData((MapValueImpl)value, internalStructFields, i, internalKeyName));
                } else {
                    jsonData.put(StringUtils.fromString(internalStructFields[i].name), value);
                }
                structError = false;
            }
        }
        if (structError) {
            throw new BallerinaException("error in constructing the json object from struct type data");
        }
        return jsonData;
    }

    private static Object getDataArray(MapValue df, BString key) {
        BArray dataArray = df.getArrayValue(key);
        ArrayValueImpl jsonArray = new ArrayValueImpl(new BArrayType(PredefinedTypes.TYPE_JSON));
        for (int i = 0; i < dataArray.size(); ++i) {
            jsonArray.append(dataArray.get(i));
        }
        return jsonArray;
    }

    public static interface JSONObjectGenerator {
        public Object transform(MapValueImpl var1) throws IOException;
    }

    private static class DefaultJSONObjectGenerator
    implements JSONObjectGenerator {
        private DefaultJSONObjectGenerator() {
        }

        @Override
        public Object transform(MapValueImpl record) {
            MapValueImpl<BString, Object> objNode = new MapValueImpl<BString, Object>(new BMapType(PredefinedTypes.TYPE_JSON));
            BStructureType structType = (BStructureType)record.getType();
            BField[] structFields = null;
            if (structType != null) {
                structFields = structType.getFields().values().toArray(new BField[0]);
            }
            Map<String, Field> internalStructFields = structType.getFields();
            if (structFields.length > 0) {
                Iterator<Map.Entry<String, Field>> itr = internalStructFields.entrySet().iterator();
                for (int i = 0; i < internalStructFields.size(); ++i) {
                    Field internalStructField = itr.next().getValue();
                    int type = internalStructField.getFieldType().getTag();
                    String fieldName = internalStructField.getFieldName();
                    TableJsonDataSource.constructJsonData(record, objNode, fieldName, type, structFields, i);
                }
            }
            return objNode;
        }
    }
}

