/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal;

import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.internal.CycleUtils;
import io.ballerina.runtime.internal.TypeChecker;
import io.ballerina.runtime.internal.util.exceptions.BLangExceptionHelper;
import io.ballerina.runtime.internal.util.exceptions.BallerinaErrorReasons;
import io.ballerina.runtime.internal.util.exceptions.RuntimeErrors;
import io.ballerina.runtime.internal.values.ArrayValue;
import io.ballerina.runtime.internal.values.IteratorValue;
import io.ballerina.runtime.internal.values.MapValue;
import io.ballerina.runtime.internal.values.RefValue;
import io.ballerina.runtime.internal.values.TableValue;
import java.util.Map;

public class TableUtils {
    public static Long hash(Object obj, CycleUtils.Node parent) {
        long result = 0L;
        if (obj == null) {
            return 0L;
        }
        if (obj instanceof RefValue) {
            CycleUtils.Node node = new CycleUtils.Node(obj, parent);
            if (node.hasCyclesSoFar()) {
                throw ErrorCreator.createError(BallerinaErrorReasons.TABLE_KEY_CYCLIC_VALUE_REFERENCE_ERROR, BLangExceptionHelper.getErrorMessage(RuntimeErrors.CYCLIC_VALUE_REFERENCE, TypeChecker.getType(obj)));
            }
            RefValue refValue = (RefValue)obj;
            Type refType = refValue.getType();
            if (refType.getTag() == 15 || refType.getTag() == 12) {
                MapValue mapValue = (MapValue)refValue;
                for (Map.Entry entry : mapValue.entrySet()) {
                    result = 31L * result + TableUtils.hash(entry.getKey(), node) + (entry.getValue() == null ? 0L : TableUtils.hash(entry.getValue(), node));
                }
                return result;
            }
            if (refType.getTag() == 20 || refType.getTag() == 32) {
                ArrayValue arrayValue = (ArrayValue)refValue;
                IteratorValue arrayIterator = arrayValue.getIterator();
                while (arrayIterator.hasNext()) {
                    result = 31L * result + TableUtils.hash(arrayIterator.next(), node);
                }
                return result;
            }
            if (refType.getTag() == 8 || refType.getTag() == 47 || refType.getTag() == 50 || refType.getTag() == 28 || refType.getTag() == 49 || refType.getTag() == 48 || refType.getTag() == 26) {
                return refValue.toString().hashCode();
            }
            return obj.hashCode();
        }
        return obj.hashCode();
    }

    public static void handleTableStore(TableValue<Object, Object> tableValue, Object key, Object value) {
        tableValue.put(key, value);
    }
}

