/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal;

import io.ballerina.runtime.api.PredefinedTypes;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.flags.SymbolFlags;
import io.ballerina.runtime.api.types.Field;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.ErrorUtils;
import io.ballerina.runtime.internal.TypeChecker;
import io.ballerina.runtime.internal.commons.TypeValuePair;
import io.ballerina.runtime.internal.types.BArrayType;
import io.ballerina.runtime.internal.types.BMapType;
import io.ballerina.runtime.internal.types.BRecordType;
import io.ballerina.runtime.internal.types.BTableType;
import io.ballerina.runtime.internal.types.BUnionType;
import io.ballerina.runtime.internal.util.exceptions.BLangExceptionHelper;
import io.ballerina.runtime.internal.util.exceptions.BallerinaErrorReasons;
import io.ballerina.runtime.internal.util.exceptions.RuntimeErrors;
import io.ballerina.runtime.internal.values.ArrayValue;
import io.ballerina.runtime.internal.values.DecimalValue;
import io.ballerina.runtime.internal.values.MapValue;
import io.ballerina.runtime.internal.values.MapValueImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;

public class TypeConverter {
    private static final String NaN = "NaN";
    private static final String POSITIVE_INFINITY = "Infinity";
    private static final String NEGATIVE_INFINITY = "-Infinity";

    public static Object convertValues(Type targetType, Object inputValue) {
        Type inputType = TypeChecker.getType(inputValue);
        switch (targetType.getTag()) {
            case 1: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                return TypeConverter.anyToInt(inputValue, () -> ErrorUtils.createNumericConversionError(inputValue, PredefinedTypes.TYPE_INT));
            }
            case 4: {
                return TypeConverter.anyToDecimal(inputValue, () -> ErrorUtils.createNumericConversionError(inputValue, PredefinedTypes.TYPE_DECIMAL));
            }
            case 3: {
                return TypeConverter.anyToFloat(inputValue, () -> ErrorUtils.createNumericConversionError(inputValue, PredefinedTypes.TYPE_FLOAT));
            }
            case 5: {
                return StringUtils.fromString(TypeConverter.anyToString(inputValue));
            }
            case 6: {
                return TypeConverter.anyToBoolean(inputValue, () -> ErrorUtils.createNumericConversionError(inputValue, PredefinedTypes.TYPE_BOOLEAN));
            }
            case 2: {
                return TypeConverter.anyToByte(inputValue, () -> ErrorUtils.createNumericConversionError(inputValue, PredefinedTypes.TYPE_BYTE));
            }
        }
        throw ErrorCreator.createError(BallerinaErrorReasons.NUMBER_CONVERSION_ERROR, BLangExceptionHelper.getErrorMessage(RuntimeErrors.INCOMPATIBLE_SIMPLE_TYPE_CONVERT_OPERATION, inputType, inputValue, targetType));
    }

    public static Object castValues(Type targetType, Object inputValue) {
        switch (targetType.getTag()) {
            case 1: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                return TypeConverter.anyToIntCast(inputValue, () -> ErrorUtils.createTypeCastError(inputValue, PredefinedTypes.TYPE_INT));
            }
            case 4: {
                return TypeConverter.anyToDecimal(inputValue, () -> ErrorUtils.createTypeCastError(inputValue, PredefinedTypes.TYPE_DECIMAL));
            }
            case 3: {
                return TypeConverter.anyToFloatCast(inputValue, () -> ErrorUtils.createTypeCastError(inputValue, PredefinedTypes.TYPE_FLOAT));
            }
            case 5: {
                return TypeConverter.anyToStringCast(inputValue, () -> ErrorUtils.createTypeCastError(inputValue, PredefinedTypes.TYPE_STRING));
            }
            case 6: {
                return TypeConverter.anyToBooleanCast(inputValue, () -> ErrorUtils.createTypeCastError(inputValue, PredefinedTypes.TYPE_BOOLEAN));
            }
            case 2: {
                return TypeConverter.anyToByteCast(inputValue, () -> ErrorUtils.createTypeCastError(inputValue, PredefinedTypes.TYPE_BYTE));
            }
        }
        throw ErrorUtils.createTypeCastError(inputValue, targetType);
    }

    static boolean isConvertibleToByte(Object value) {
        Type inputType = TypeChecker.getType(value);
        switch (inputType.getTag()) {
            case 2: {
                return true;
            }
            case 1: {
                return TypeChecker.isByteLiteral((Long)value);
            }
            case 3: {
                Double doubleValue = (Double)value;
                return TypeConverter.isFloatWithinIntRange(doubleValue) && TypeChecker.isByteLiteral(doubleValue.longValue());
            }
            case 4: {
                return DecimalValue.isDecimalWithinIntRange((BigDecimal)value) && TypeChecker.isByteLiteral(((BigDecimal)value).longValue());
            }
        }
        return false;
    }

    static boolean isConvertibleToInt(Object value) {
        Type inputType = TypeChecker.getType(value);
        switch (inputType.getTag()) {
            case 1: 
            case 2: {
                return true;
            }
            case 3: {
                return TypeConverter.isFloatWithinIntRange((Double)value);
            }
            case 4: {
                return DecimalValue.isDecimalWithinIntRange((BigDecimal)value);
            }
        }
        return false;
    }

    static boolean isConvertibleToIntSubType(Object value, Type targetType) {
        long val;
        Type inputType = TypeChecker.getType(value);
        switch (inputType.getTag()) {
            case 1: 
            case 2: {
                val = ((Number)value).longValue();
                break;
            }
            case 3: {
                if (!TypeConverter.isFloatWithinIntRange((Double)value)) {
                    return false;
                }
                val = TypeConverter.floatToInt((Double)value);
                break;
            }
            case 4: {
                if (!DecimalValue.isDecimalWithinIntRange((BigDecimal)value)) {
                    return false;
                }
                val = ((BigDecimal)value).intValue();
                break;
            }
            default: {
                return false;
            }
        }
        switch (targetType.getTag()) {
            case 40: {
                return TypeChecker.isSigned32LiteralValue(val);
            }
            case 41: {
                return TypeChecker.isSigned16LiteralValue(val);
            }
            case 42: {
                return TypeChecker.isSigned8LiteralValue(val);
            }
            case 43: {
                return TypeChecker.isUnsigned32LiteralValue(val);
            }
            case 44: {
                return TypeChecker.isUnsigned16LiteralValue(val);
            }
            case 45: {
                return TypeChecker.isUnsigned8LiteralValue(val);
            }
        }
        return false;
    }

    static boolean isConvertibleToChar(Object value) {
        Type inputType = TypeChecker.getType(value);
        if (inputType.getTag() == 5) {
            return TypeChecker.isCharLiteralValue(value);
        }
        return false;
    }

    static boolean isConvertibleToFloatingPointTypes(Object value) {
        Type inputType = TypeChecker.getType(value);
        switch (inputType.getTag()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    public static List<Type> getConvertibleTypes(Object inputValue, Type targetType) {
        return TypeConverter.getConvertibleTypes(inputValue, targetType, new ArrayList<TypeValuePair>());
    }

    public static List<Type> getConvertibleTypes(Object inputValue, Type targetType, List<TypeValuePair> unresolvedValues) {
        ArrayList<Type> convertibleTypes = new ArrayList<Type>();
        int targetTypeTag = targetType.getTag();
        switch (targetTypeTag) {
            case 21: {
                for (Type memType : ((BUnionType)targetType).getMemberTypes()) {
                    convertibleTypes.addAll(TypeConverter.getConvertibleTypes(inputValue, memType, unresolvedValues));
                }
                break;
            }
            case 12: {
                if (!TypeConverter.isConvertibleToRecordType(inputValue, (BRecordType)targetType, false, unresolvedValues)) break;
                convertibleTypes.add(targetType);
                break;
            }
            case 11: {
                Type matchingType = TypeConverter.resolveMatchingTypeForUnion(inputValue, targetType);
                if (matchingType == null) break;
                convertibleTypes.add(matchingType);
                break;
            }
            default: {
                if (!TypeChecker.checkIsLikeType(inputValue, targetType, true)) break;
                convertibleTypes.add(targetType);
            }
        }
        return convertibleTypes;
    }

    public static List<Type> getConvertibleTypesFromJson(Object value, Type targetType, List<TypeValuePair> unresolvedValues) {
        ArrayList<Type> convertibleTypes = new ArrayList<Type>();
        int targetTypeTag = targetType.getTag();
        convertibleTypes.addAll(TypeConverter.getConvertibleTypes(value, targetType));
        if (convertibleTypes.size() == 0) {
            switch (targetTypeTag) {
                case 12: {
                    if (!TypeConverter.isConvertibleToRecordType(value, (BRecordType)targetType, true, unresolvedValues)) break;
                    convertibleTypes.add(targetType);
                    break;
                }
                case 9: {
                    if (((BTableType)targetType).getConstrainedType().getTag() != 12 && ((BTableType)targetType).getConstrainedType().getTag() != 15) break;
                    convertibleTypes.add(targetType);
                    break;
                }
                case 8: 
                case 47: 
                case 48: 
                case 49: 
                case 50: {
                    if (TypeChecker.getType(value).getTag() != 5) break;
                    convertibleTypes.add(targetType);
                }
            }
        }
        return convertibleTypes;
    }

    private static boolean isConvertibleToRecordType(Object sourceValue, BRecordType targetType, boolean isFromJson, List<TypeValuePair> unresolvedValues) {
        if (!(sourceValue instanceof MapValueImpl)) {
            return false;
        }
        TypeValuePair typeValuePair = new TypeValuePair(sourceValue, targetType);
        if (unresolvedValues.contains(typeValuePair)) {
            return true;
        }
        unresolvedValues.add(typeValuePair);
        HashMap<String, Type> targetFieldTypes = new HashMap<String, Type>();
        Type restFieldType = targetType.restFieldType;
        for (Map.Entry<String, Field> field : targetType.getFields().entrySet()) {
            targetFieldTypes.put(field.getKey(), field.getValue().getFieldType());
        }
        MapValueImpl sourceMapValueImpl = (MapValueImpl)sourceValue;
        for (Map.Entry targetTypeEntry : targetFieldTypes.entrySet()) {
            Field targetField;
            String fieldName = targetTypeEntry.getKey().toString();
            if (sourceMapValueImpl.containsKey(StringUtils.fromString(fieldName)) || !SymbolFlags.isFlagOn((targetField = targetType.getFields().get(fieldName)).getFlags(), 256L)) continue;
            return false;
        }
        Iterator iterator = sourceMapValueImpl.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry object;
            Map.Entry valueEntry = object = iterator.next();
            String fieldName = valueEntry.getKey().toString();
            if (isFromJson) {
                if (targetFieldTypes.containsKey(fieldName)) {
                    if (TypeConverter.getConvertibleTypesFromJson(valueEntry.getValue(), (Type)targetFieldTypes.get(fieldName), unresolvedValues).size() == 1) continue;
                    return false;
                }
                if (!targetType.sealed) {
                    if (TypeConverter.getConvertibleTypesFromJson(valueEntry.getValue(), restFieldType, unresolvedValues).size() == 1) continue;
                    return false;
                }
                return false;
            }
            if (targetFieldTypes.containsKey(fieldName)) {
                if (TypeConverter.getConvertibleTypes(valueEntry.getValue(), (Type)targetFieldTypes.get(fieldName), unresolvedValues).size() == 1) continue;
                return false;
            }
            if (!targetType.sealed) {
                if (TypeConverter.getConvertibleTypes(valueEntry.getValue(), restFieldType, unresolvedValues).size() == 1) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    static long anyToInt(Object sourceVal, Supplier<BError> errorFunc) {
        if (sourceVal instanceof Long) {
            return (Long)sourceVal;
        }
        if (sourceVal instanceof Double) {
            return TypeConverter.floatToInt((Double)sourceVal);
        }
        if (sourceVal instanceof Integer) {
            return ((Integer)sourceVal).longValue();
        }
        if (sourceVal instanceof Boolean) {
            return (Boolean)sourceVal != false ? 1L : 0L;
        }
        if (sourceVal instanceof DecimalValue) {
            return ((DecimalValue)sourceVal).intValue();
        }
        if (sourceVal instanceof String) {
            try {
                return Long.parseLong((String)sourceVal);
            }
            catch (NumberFormatException e) {
                throw errorFunc.get();
            }
        }
        throw errorFunc.get();
    }

    static long anyToIntCast(Object sourceVal, Supplier<BError> errorFunc) {
        if (sourceVal instanceof Long) {
            return (Long)sourceVal;
        }
        if (sourceVal instanceof Double) {
            return TypeConverter.floatToInt((Double)sourceVal);
        }
        if (sourceVal instanceof Integer) {
            return ((Integer)sourceVal).longValue();
        }
        if (sourceVal instanceof Boolean) {
            return (Boolean)sourceVal != false ? 1L : 0L;
        }
        if (sourceVal instanceof DecimalValue) {
            return ((DecimalValue)sourceVal).intValue();
        }
        throw errorFunc.get();
    }

    static long anyToIntSubTypeCast(Object sourceVal, Type type, Supplier<BError> errorFunc) {
        long value = TypeConverter.anyToIntCast(sourceVal, errorFunc);
        if (type == PredefinedTypes.TYPE_INT_SIGNED_32 && TypeChecker.isSigned32LiteralValue(value)) {
            return value;
        }
        if (type == PredefinedTypes.TYPE_INT_SIGNED_16 && TypeChecker.isSigned16LiteralValue(value)) {
            return value;
        }
        if (type == PredefinedTypes.TYPE_INT_SIGNED_8 && TypeChecker.isSigned8LiteralValue(value)) {
            return value;
        }
        if (type == PredefinedTypes.TYPE_INT_UNSIGNED_32 && TypeChecker.isUnsigned32LiteralValue(value)) {
            return value;
        }
        if (type == PredefinedTypes.TYPE_INT_UNSIGNED_16 && TypeChecker.isUnsigned16LiteralValue(value)) {
            return value;
        }
        if (type == PredefinedTypes.TYPE_INT_UNSIGNED_8 && TypeChecker.isUnsigned8LiteralValue(value)) {
            return value;
        }
        throw errorFunc.get();
    }

    static double anyToFloat(Object sourceVal, Supplier<BError> errorFunc) {
        if (sourceVal instanceof Long) {
            return ((Long)sourceVal).doubleValue();
        }
        if (sourceVal instanceof Double) {
            return (Double)sourceVal;
        }
        if (sourceVal instanceof Integer) {
            return ((Integer)sourceVal).floatValue();
        }
        if (sourceVal instanceof Boolean) {
            return (Boolean)sourceVal != false ? 1.0 : 0.0;
        }
        if (sourceVal instanceof DecimalValue) {
            return ((DecimalValue)sourceVal).floatValue();
        }
        if (sourceVal instanceof String) {
            try {
                return Double.parseDouble((String)sourceVal);
            }
            catch (NumberFormatException e) {
                throw errorFunc.get();
            }
        }
        throw errorFunc.get();
    }

    static double anyToFloatCast(Object sourceVal, Supplier<BError> errorFunc) {
        if (sourceVal instanceof Long) {
            return ((Long)sourceVal).doubleValue();
        }
        if (sourceVal instanceof Double) {
            return (Double)sourceVal;
        }
        if (sourceVal instanceof Integer) {
            return ((Integer)sourceVal).floatValue();
        }
        if (sourceVal instanceof Boolean) {
            return (Boolean)sourceVal != false ? 1.0 : 0.0;
        }
        if (sourceVal instanceof DecimalValue) {
            return ((DecimalValue)sourceVal).floatValue();
        }
        throw errorFunc.get();
    }

    static boolean anyToBoolean(Object sourceVal, Supplier<BError> errorFunc) {
        if (sourceVal instanceof Long) {
            return (Long)sourceVal != 0L;
        }
        if (sourceVal instanceof Double) {
            return (Double)sourceVal != 0.0;
        }
        if (sourceVal instanceof Integer) {
            return (Integer)sourceVal != 0;
        }
        if (sourceVal instanceof Boolean) {
            return (Boolean)sourceVal;
        }
        if (sourceVal instanceof DecimalValue) {
            return ((DecimalValue)sourceVal).booleanValue();
        }
        if (sourceVal instanceof String) {
            try {
                return Boolean.parseBoolean((String)sourceVal);
            }
            catch (NumberFormatException e) {
                throw errorFunc.get();
            }
        }
        throw errorFunc.get();
    }

    static boolean anyToBooleanCast(Object sourceVal, Supplier<BError> errorFunc) {
        if (sourceVal instanceof Boolean) {
            return (Boolean)sourceVal;
        }
        throw errorFunc.get();
    }

    public static int intToByte(long sourceVal) {
        if (!TypeChecker.isByteLiteral(sourceVal)) {
            throw ErrorUtils.createNumericConversionError(sourceVal, PredefinedTypes.TYPE_BYTE);
        }
        return Long.valueOf(sourceVal).intValue();
    }

    public static long intToSigned32(long sourceVal) {
        if (!TypeChecker.isSigned32LiteralValue(sourceVal)) {
            throw ErrorUtils.createNumericConversionError(sourceVal, PredefinedTypes.TYPE_INT_SIGNED_32);
        }
        return sourceVal;
    }

    public static long intToSigned16(long sourceVal) {
        if (!TypeChecker.isSigned16LiteralValue(sourceVal)) {
            throw ErrorUtils.createNumericConversionError(sourceVal, PredefinedTypes.TYPE_INT_SIGNED_16);
        }
        return sourceVal;
    }

    public static long intToSigned8(long sourceVal) {
        if (!TypeChecker.isSigned8LiteralValue(sourceVal)) {
            throw ErrorUtils.createNumericConversionError(sourceVal, PredefinedTypes.TYPE_INT_SIGNED_8);
        }
        return sourceVal;
    }

    public static long intToUnsigned32(long sourceVal) {
        if (!TypeChecker.isUnsigned32LiteralValue(sourceVal)) {
            throw ErrorUtils.createNumericConversionError(sourceVal, PredefinedTypes.TYPE_INT_UNSIGNED_32);
        }
        return sourceVal;
    }

    public static long intToUnsigned16(long sourceVal) {
        if (!TypeChecker.isUnsigned16LiteralValue(sourceVal)) {
            throw ErrorUtils.createNumericConversionError(sourceVal, PredefinedTypes.TYPE_INT_UNSIGNED_16);
        }
        return sourceVal;
    }

    public static long intToUnsigned8(long sourceVal) {
        if (!TypeChecker.isUnsigned8LiteralValue(sourceVal)) {
            throw ErrorUtils.createNumericConversionError(sourceVal, PredefinedTypes.TYPE_INT_UNSIGNED_8);
        }
        return sourceVal;
    }

    public static long floatToSigned32(double sourceVal) {
        return TypeConverter.intToSigned32(TypeConverter.floatToInt(sourceVal));
    }

    public static long floatToSigned16(double sourceVal) {
        return TypeConverter.intToSigned16(TypeConverter.floatToInt(sourceVal));
    }

    public static long floatToSigned8(double sourceVal) {
        return TypeConverter.intToSigned8(TypeConverter.floatToInt(sourceVal));
    }

    public static long floatToUnsigned32(double sourceVal) {
        return TypeConverter.intToUnsigned32(TypeConverter.floatToInt(sourceVal));
    }

    public static long floatToUnsigned16(double sourceVal) {
        return TypeConverter.intToUnsigned16(TypeConverter.floatToInt(sourceVal));
    }

    public static long floatToUnsigned8(double sourceVal) {
        return TypeConverter.intToUnsigned8(TypeConverter.floatToInt(sourceVal));
    }

    public static BString stringToChar(Object sourceVal) {
        if (!TypeChecker.isCharLiteralValue(sourceVal)) {
            throw ErrorUtils.createNumericConversionError(sourceVal, PredefinedTypes.TYPE_STRING_CHAR);
        }
        return StringUtils.fromString(Objects.toString(sourceVal));
    }

    public static BString anyToChar(Object sourceVal) {
        String value = Objects.toString(sourceVal);
        return TypeConverter.stringToChar(value);
    }

    public static int floatToByte(double sourceVal) {
        TypeConverter.checkIsValidFloat(sourceVal, PredefinedTypes.TYPE_BYTE);
        long intVal = Math.round(sourceVal);
        if (!TypeChecker.isByteLiteral(intVal)) {
            throw ErrorUtils.createNumericConversionError(sourceVal, PredefinedTypes.TYPE_BYTE);
        }
        return (int)intVal;
    }

    public static long floatToInt(double sourceVal) {
        TypeConverter.checkIsValidFloat(sourceVal, PredefinedTypes.TYPE_INT);
        if (!TypeConverter.isFloatWithinIntRange(sourceVal)) {
            throw ErrorUtils.createNumericConversionError(sourceVal, PredefinedTypes.TYPE_INT);
        }
        return (long)Math.rint(sourceVal);
    }

    private static void checkIsValidFloat(double sourceVal, Type targetType) {
        if (Double.isNaN(sourceVal)) {
            throw ErrorUtils.createNumericConversionError(NaN, PredefinedTypes.TYPE_FLOAT, targetType);
        }
        if (Double.isInfinite(sourceVal)) {
            String value = sourceVal > 0.0 ? POSITIVE_INFINITY : NEGATIVE_INFINITY;
            throw ErrorUtils.createNumericConversionError(value, PredefinedTypes.TYPE_FLOAT, targetType);
        }
    }

    static int anyToByte(Object sourceVal, Supplier<BError> errorFunc) {
        if (sourceVal instanceof Long) {
            return TypeConverter.intToByte((Long)sourceVal);
        }
        if (sourceVal instanceof Double) {
            return TypeConverter.floatToByte((Double)sourceVal);
        }
        if (sourceVal instanceof Integer) {
            return (Integer)sourceVal;
        }
        if (sourceVal instanceof Boolean) {
            return (Boolean)sourceVal != false ? 1 : 0;
        }
        if (sourceVal instanceof DecimalValue) {
            return ((DecimalValue)sourceVal).byteValue();
        }
        if (sourceVal instanceof String) {
            try {
                return Integer.parseInt((String)sourceVal);
            }
            catch (NumberFormatException e) {
                throw errorFunc.get();
            }
        }
        throw errorFunc.get();
    }

    static int anyToByteCast(Object sourceVal, Supplier<BError> errorFunc) {
        if (sourceVal instanceof Long) {
            return TypeConverter.intToByte((Long)sourceVal);
        }
        if (sourceVal instanceof Byte) {
            return ((Byte)sourceVal).intValue();
        }
        if (sourceVal instanceof Double) {
            return TypeConverter.floatToByte((Double)sourceVal);
        }
        if (sourceVal instanceof Integer) {
            return (Integer)sourceVal;
        }
        if (sourceVal instanceof Boolean) {
            return (Boolean)sourceVal != false ? 1 : 0;
        }
        if (sourceVal instanceof DecimalValue) {
            return ((DecimalValue)sourceVal).byteValue();
        }
        throw errorFunc.get();
    }

    private static String anyToString(Object sourceVal) {
        if (sourceVal instanceof Long) {
            return Long.toString((Long)sourceVal);
        }
        if (sourceVal instanceof Double) {
            return Double.toString((Double)sourceVal);
        }
        if (sourceVal instanceof Integer) {
            return Long.toString(((Integer)sourceVal).intValue());
        }
        if (sourceVal instanceof Boolean) {
            return Boolean.toString((Boolean)sourceVal);
        }
        if (sourceVal instanceof DecimalValue) {
            return ((DecimalValue)sourceVal).stringValue(null);
        }
        if (sourceVal instanceof String) {
            return (String)sourceVal;
        }
        if (sourceVal == null) {
            return "()";
        }
        throw ErrorUtils.createNumericConversionError(sourceVal, PredefinedTypes.TYPE_STRING);
    }

    private static String anyToStringCast(Object sourceVal, Supplier<BError> errorFunc) {
        if (sourceVal instanceof String) {
            return (String)sourceVal;
        }
        throw errorFunc.get();
    }

    static DecimalValue anyToDecimal(Object sourceVal, Supplier<BError> errorFunc) {
        if (sourceVal instanceof Long) {
            return DecimalValue.valueOf((Long)sourceVal);
        }
        if (sourceVal instanceof Double) {
            return DecimalValue.valueOf((Double)sourceVal);
        }
        if (sourceVal instanceof Integer) {
            return DecimalValue.valueOf((Integer)sourceVal);
        }
        if (sourceVal instanceof Boolean) {
            return DecimalValue.valueOf((Boolean)sourceVal);
        }
        if (sourceVal instanceof DecimalValue) {
            return (DecimalValue)sourceVal;
        }
        if (sourceVal instanceof String) {
            return new DecimalValue((String)sourceVal);
        }
        throw errorFunc.get();
    }

    static byte anyToJByteCast(Object sourceVal, Supplier<BError> errorFunc) {
        if (sourceVal instanceof Byte) {
            return (Byte)sourceVal;
        }
        throw errorFunc.get();
    }

    static char anyToJCharCast(Object sourceVal, Supplier<BError> errorFunc) {
        if (sourceVal instanceof Character) {
            return ((Character)sourceVal).charValue();
        }
        throw errorFunc.get();
    }

    static short anyToJShortCast(Object sourceVal, Supplier<BError> errorFunc) {
        if (sourceVal instanceof Short) {
            return (Short)sourceVal;
        }
        throw errorFunc.get();
    }

    static int anyToJIntCast(Object sourceVal, Supplier<BError> errorFunc) {
        if (sourceVal instanceof Integer) {
            return (Integer)sourceVal;
        }
        throw errorFunc.get();
    }

    static long anyToJLongCast(Object sourceVal, Supplier<BError> errorFunc) {
        if (sourceVal instanceof Long) {
            return (Long)sourceVal;
        }
        throw errorFunc.get();
    }

    static float anyToJFloatCast(Object sourceVal, Supplier<BError> errorFunc) {
        if (sourceVal instanceof Float) {
            return ((Float)sourceVal).floatValue();
        }
        throw errorFunc.get();
    }

    static double anyToJDoubleCast(Object sourceVal, Supplier<BError> errorFunc) {
        if (sourceVal instanceof Double) {
            return (Double)sourceVal;
        }
        throw errorFunc.get();
    }

    static boolean anyToJBooleanCast(Object sourceVal, Supplier<BError> errorFunc) {
        if (sourceVal instanceof Boolean) {
            return (Boolean)sourceVal;
        }
        throw errorFunc.get();
    }

    public static long jFloatToBInt(float sourceVal) {
        TypeConverter.checkIsValidFloat(sourceVal, PredefinedTypes.TYPE_INT);
        if (!TypeConverter.isFloatWithinIntRange(sourceVal)) {
            throw ErrorUtils.createNumericConversionError(Float.valueOf(sourceVal), PredefinedTypes.TYPE_INT);
        }
        return (long)Math.rint(sourceVal);
    }

    public static long jDoubleToBInt(double sourceVal) {
        TypeConverter.checkIsValidFloat(sourceVal, PredefinedTypes.TYPE_INT);
        if (!TypeConverter.isFloatWithinIntRange(sourceVal)) {
            throw ErrorUtils.createNumericConversionError(sourceVal, PredefinedTypes.TYPE_INT);
        }
        return (long)Math.rint(sourceVal);
    }

    private static boolean isFloatWithinIntRange(double doubleValue) {
        return doubleValue < 9.223372036854776E18 && doubleValue > -9.223372036854776E18;
    }

    public static Type resolveMatchingTypeForUnion(Object value, Type type) {
        if (value instanceof ArrayValue && ((ArrayValue)value).getType().getTag() == 20 && !TypeConverter.isDeepStampingRequiredForArray(((ArrayValue)value).getType())) {
            return ((ArrayValue)value).getType();
        }
        if (value instanceof MapValue && ((MapValue)value).getType().getTag() == 15 && !TypeConverter.isDeepStampingRequiredForMap(((MapValue)value).getType())) {
            return ((MapValue)value).getType();
        }
        if (value == null && type.isNilable()) {
            return PredefinedTypes.TYPE_NULL;
        }
        if (TypeChecker.checkIsLikeType(value, PredefinedTypes.TYPE_INT)) {
            return PredefinedTypes.TYPE_INT;
        }
        if (TypeChecker.checkIsLikeType(value, PredefinedTypes.TYPE_FLOAT)) {
            return PredefinedTypes.TYPE_FLOAT;
        }
        if (TypeChecker.checkIsLikeType(value, PredefinedTypes.TYPE_STRING)) {
            return PredefinedTypes.TYPE_STRING;
        }
        if (TypeChecker.checkIsLikeType(value, PredefinedTypes.TYPE_BOOLEAN)) {
            return PredefinedTypes.TYPE_BOOLEAN;
        }
        if (TypeChecker.checkIsLikeType(value, PredefinedTypes.TYPE_BYTE)) {
            return PredefinedTypes.TYPE_BYTE;
        }
        if (TypeChecker.checkIsLikeType(value, PredefinedTypes.TYPE_DECIMAL)) {
            return PredefinedTypes.TYPE_DECIMAL;
        }
        BArrayType anydataArrayType = new BArrayType(type);
        if (TypeChecker.checkIsLikeType(value, anydataArrayType)) {
            return anydataArrayType;
        }
        if (TypeChecker.checkIsLikeType(value, PredefinedTypes.TYPE_XML)) {
            return PredefinedTypes.TYPE_XML;
        }
        BMapType anydataMapType = new BMapType(type);
        if (TypeChecker.checkIsLikeType(value, anydataMapType)) {
            return anydataMapType;
        }
        return null;
    }

    private static boolean isDeepStampingRequiredForArray(Type sourceType) {
        Type elementType = ((BArrayType)sourceType).getElementType();
        if (elementType != null) {
            if (TypeUtils.isValueType(elementType)) {
                return false;
            }
            if (elementType instanceof BArrayType) {
                return TypeConverter.isDeepStampingRequiredForArray(elementType);
            }
            return true;
        }
        return true;
    }

    private static boolean isDeepStampingRequiredForMap(Type sourceType) {
        Type constrainedType = ((BMapType)sourceType).getConstrainedType();
        if (constrainedType != null) {
            if (TypeUtils.isValueType(constrainedType)) {
                return false;
            }
            if (constrainedType instanceof BMapType) {
                return TypeConverter.isDeepStampingRequiredForMap(constrainedType);
            }
            return true;
        }
        return true;
    }
}

