/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.scheduling;

import io.ballerina.runtime.api.async.StrandMetadata;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BFunctionPointer;
import io.ballerina.runtime.internal.scheduling.AsyncFunctionCallback;
import io.ballerina.runtime.internal.scheduling.Scheduler;
import io.ballerina.runtime.internal.scheduling.State;
import io.ballerina.runtime.internal.scheduling.Strand;
import io.ballerina.runtime.internal.types.BFunctionType;
import io.ballerina.runtime.internal.values.FutureValue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class AsyncUtils {
    public static CompletableFuture<Object> markAsync() {
        Strand strand = Scheduler.getStrand();
        strand.blockedOnExtern = true;
        strand.setState(State.BLOCK_AND_YIELD);
        CompletableFuture<Object> future = new CompletableFuture<Object>();
        future.whenComplete((BiConsumer)new Unblocker(strand));
        return future;
    }

    public static FutureValue invokeFunctionPointerAsync(BFunctionPointer<?, ?> func, String strandName, StrandMetadata metadata, Object[] args, final Function<Object, Object> resultHandleFunction, Scheduler scheduler) {
        AsyncFunctionCallback callback = new AsyncFunctionCallback(){

            @Override
            public void notifySuccess(Object result) {
                this.setReturnValues(resultHandleFunction.apply(this.getFutureResult()));
            }

            @Override
            public void notifyFailure(BError error) {
                this.handleRuntimeErrors(error);
            }
        };
        return AsyncUtils.invokeFunctionPointerAsync(func, Scheduler.getStrand(), strandName, metadata, args, callback, scheduler);
    }

    public static FutureValue invokeFunctionPointerAsync(BFunctionPointer<?, ?> func, Strand parent, String name, StrandMetadata metadata, Object[] args, AsyncFunctionCallback callback, Scheduler scheduler) {
        AsyncUtils.blockStrand(parent);
        FutureValue future = scheduler.createFuture(parent, null, null, ((BFunctionType)func.getType()).retType, name, metadata);
        future.callback = callback;
        callback.setFuture(future);
        callback.setStrand(parent);
        return scheduler.scheduleLocal(args, func, parent, future);
    }

    public static void blockStrand(Strand strand) {
        if (!strand.blockedOnExtern) {
            strand.blockedOnExtern = true;
            strand.setState(State.BLOCK_AND_YIELD);
            strand.returnValue = null;
        }
    }

    public static void invokeFunctionPointerAsyncIteratively(BFunctionPointer<?, ?> func, String strandName, StrandMetadata metadata, int noOfIterations, Supplier<Object[]> argsSupplier, Consumer<Object> futureResultConsumer, Supplier<Object> returnValueSupplier, Scheduler scheduler) {
        if (noOfIterations <= 0) {
            return;
        }
        Strand strand = Scheduler.getStrand();
        AsyncUtils.blockStrand(strand);
        AtomicInteger callCount = new AtomicInteger(0);
        AsyncUtils.scheduleNextFunction(func, strand, strandName, metadata, noOfIterations, callCount, argsSupplier, futureResultConsumer, returnValueSupplier, scheduler);
    }

    private static void scheduleNextFunction(final BFunctionPointer<?, ?> func, final Strand strand, final String strandName, final StrandMetadata metadata, final int noOfIterations, final AtomicInteger callCount, final Supplier<Object[]> argsSupplier, final Consumer<Object> futureResultConsumer, final Supplier<Object> returnValueSupplier, final Scheduler scheduler) {
        AsyncFunctionCallback callback = new AsyncFunctionCallback(){

            @Override
            public void notifySuccess(Object result) {
                futureResultConsumer.accept(this.getFutureResult());
                if (callCount.incrementAndGet() != noOfIterations) {
                    AsyncUtils.scheduleNextFunction(func, strand, strandName, metadata, noOfIterations, callCount, argsSupplier, futureResultConsumer, returnValueSupplier, scheduler);
                } else {
                    this.setReturnValues(returnValueSupplier.get());
                }
            }

            @Override
            public void notifyFailure(BError error) {
                this.handleRuntimeErrors(error);
            }
        };
        AsyncUtils.invokeFunctionPointerAsync(func, strand, strandName, metadata, argsSupplier.get(), callback, scheduler);
    }

    private static class Unblocker
    implements BiConsumer<Object, Throwable> {
        private Strand strand;

        public Unblocker(Strand strand) {
            this.strand = strand;
        }

        @Override
        public void accept(Object returnValue, Throwable throwable) {
            if (throwable == null) {
                this.strand.returnValue = returnValue;
                this.strand.scheduler.unblockStrand(this.strand);
            }
        }
    }
}

