/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.scheduling;

import io.ballerina.runtime.api.PredefinedTypes;
import io.ballerina.runtime.api.async.StrandMetadata;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.internal.TypeChecker;
import io.ballerina.runtime.internal.scheduling.ItemGroup;
import io.ballerina.runtime.internal.scheduling.Scheduler;
import io.ballerina.runtime.internal.scheduling.SchedulerItem;
import io.ballerina.runtime.internal.scheduling.State;
import io.ballerina.runtime.internal.scheduling.WDChannels;
import io.ballerina.runtime.internal.scheduling.WaitAnyContext;
import io.ballerina.runtime.internal.scheduling.WaitContext;
import io.ballerina.runtime.internal.scheduling.WaitMultipleContext;
import io.ballerina.runtime.internal.scheduling.WorkerDataChannel;
import io.ballerina.runtime.internal.values.ChannelDetails;
import io.ballerina.runtime.internal.values.ErrorValue;
import io.ballerina.runtime.internal.values.FutureValue;
import io.ballerina.runtime.internal.values.MapValue;
import io.ballerina.runtime.transactions.TransactionLocalContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class Strand {
    private static AtomicInteger nextStrandId = new AtomicInteger(0);
    private int id = nextStrandId.incrementAndGet();
    private String name;
    private StrandMetadata metadata;
    public Object[] frames;
    public int resumeIndex;
    public Object returnValue;
    public BError panic;
    public Scheduler scheduler;
    public Strand parent;
    public WDChannels wdChannels;
    public FlushDetail flushDetail;
    public boolean blockedOnExtern;
    public Set<ChannelDetails> channelDetails;
    public Set<SchedulerItem> dependants;
    public boolean cancel;
    SchedulerItem schedulerItem;
    List<WaitContext> waitingContexts;
    WaitContext waitContext;
    ItemGroup strandGroup;
    private Map<String, Object> globalProps;
    public TransactionLocalContext currentTrxContext;
    public Stack<TransactionLocalContext> trxContexts;
    private State state;
    private final ReentrantLock strandLock;

    public Strand(String name, StrandMetadata metadata, Scheduler scheduler, Strand parent, Map<String, Object> properties) {
        this.scheduler = scheduler;
        this.wdChannels = new WDChannels();
        this.channelDetails = new HashSet<ChannelDetails>();
        this.state = State.RUNNABLE;
        this.dependants = new HashSet<SchedulerItem>();
        this.strandLock = new ReentrantLock();
        this.waitingContexts = new ArrayList<WaitContext>();
        this.name = name;
        this.metadata = metadata;
        this.trxContexts = new Stack();
        this.parent = parent;
        this.globalProps = properties != null ? properties : (parent != null ? new HashMap<String, Object>(parent.globalProps) : new HashMap<String, Object>());
    }

    public void handleChannelError(ChannelDetails[] channels, ErrorValue error) {
        for (int i = 0; i < channels.length; ++i) {
            ChannelDetails channelDetails = channels[i];
            WorkerDataChannel channel = this.getWorkerDataChannel(channelDetails);
            if (channels[i].send) {
                channel.setSendError(error);
                continue;
            }
            channel.setReceiveError(error);
        }
    }

    @Deprecated
    public Object getProperty(String key) {
        return this.globalProps.get(key);
    }

    @Deprecated
    public void setProperty(String key, Object value) {
        this.globalProps.put(key, value);
    }

    public boolean isInTransaction() {
        return this.currentTrxContext != null && this.currentTrxContext.isTransactional();
    }

    @Deprecated
    public void removeLocalTransactionContext() {
        this.currentTrxContext = null;
    }

    public void removeCurrentTrxContext() {
        if (!this.trxContexts.isEmpty()) {
            this.currentTrxContext = this.trxContexts.pop();
            return;
        }
        this.currentTrxContext = null;
    }

    public void setCurrentTransactionContext(TransactionLocalContext ctx) {
        if (this.currentTrxContext != null) {
            this.trxContexts.push(this.currentTrxContext);
        }
        this.currentTrxContext = ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ErrorValue handleFlush(ChannelDetails[] channels) throws Throwable {
        try {
            if (this.flushDetail == null) {
                this.flushDetail = new FlushDetail(channels);
            }
            this.flushDetail.flushLock.lock();
            if (this.flushDetail.inProgress) {
                if (this.flushDetail.panic != null) {
                    throw this.flushDetail.panic;
                }
                ErrorValue result = this.flushDetail.result;
                this.cleanUpFlush(channels);
                ErrorValue errorValue = result;
                return errorValue;
            }
            this.flushDetail.panic = null;
            this.flushDetail.result = null;
            this.flushDetail.flushChannels = channels;
            for (int i = 0; i < channels.length; ++i) {
                ErrorValue error = this.getWorkerDataChannel(channels[i]).flushChannel(this);
                if (error != null) {
                    this.cleanUpFlush(channels);
                    ErrorValue errorValue = error;
                    return errorValue;
                }
                if (this.flushDetail.flushedCount != this.flushDetail.flushChannels.length) continue;
                this.cleanUpFlush(channels);
                ErrorValue errorValue = null;
                return errorValue;
            }
            this.flushDetail.inProgress = true;
            this.setState(State.BLOCK_AND_YIELD);
            ErrorValue errorValue = null;
            return errorValue;
        }
        finally {
            this.flushDetail.flushLock.unlock();
        }
    }

    private void cleanUpFlush(ChannelDetails[] channels) {
        this.flushDetail.inProgress = false;
        this.flushDetail.flushedCount = 0;
        this.flushDetail.result = null;
        for (ChannelDetails channel : channels) {
            this.getWorkerDataChannel(channel).removeFlushWait();
        }
    }

    public void handleWaitMultiple(Map<String, FutureValue> keyValues, MapValue target) throws Throwable {
        WaitMultipleContext ctx = new WaitMultipleContext(this.schedulerItem);
        ctx.waitCount.set(keyValues.size());
        ctx.lock();
        for (Map.Entry<String, FutureValue> entry : keyValues.entrySet()) {
            FutureValue future = entry.getValue();
            future.strand.lock();
            if (future.isDone) {
                if (future.panic != null) {
                    ctx.completed = true;
                    ctx.waitCount.set(0);
                    this.setState(State.RUNNABLE);
                    future.strand.unlock();
                    ctx.unLock();
                    throw future.panic;
                }
                ctx.waitCount.decrementAndGet();
                target.put(StringUtils.fromString(entry.getKey()), future.result);
            } else {
                this.setState(State.BLOCK_ON_AND_YIELD);
                entry.getValue().strand.waitingContexts.add(ctx);
            }
            future.strand.unlock();
        }
        if (!this.isBlocked()) {
            ctx.waitCount.set(0);
            ctx.completed = true;
        } else {
            this.waitContext = ctx;
            ctx.intermediate = true;
        }
        ctx.unLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WaitResult handleWaitAny(List<FutureValue> futures) throws Throwable {
        WaitResult waitResult = new WaitResult(false, null);
        WaitAnyContext ctx = new WaitAnyContext(this.schedulerItem);
        ctx.lock();
        ctx.waitCount.set(futures.size());
        Object error = null;
        for (FutureValue future : futures) {
            try {
                future.strand.lock();
                if (future.isDone) {
                    if (future.panic != null) {
                        ctx.completed = true;
                        ctx.unLock();
                        throw future.panic;
                    }
                    if (TypeChecker.checkIsType(future.result, (Type)PredefinedTypes.TYPE_ERROR)) {
                        ctx.waitCount.decrementAndGet();
                        error = future.result;
                        continue;
                    }
                    waitResult = new WaitResult(true, future.result);
                    break;
                }
                future.strand.waitingContexts.add(ctx);
            }
            finally {
                future.strand.unlock();
            }
        }
        if (waitResult.done) {
            ctx.completed = true;
        } else if (ctx.waitCount.get() == 0) {
            ctx.completed = true;
            waitResult = new WaitResult(true, error);
        } else {
            this.waitContext = ctx;
            this.setState(State.BLOCK_ON_AND_YIELD);
        }
        ctx.unLock();
        return waitResult;
    }

    public void updateChannelDetails(ChannelDetails[] channels) {
        for (ChannelDetails channel : channels) {
            this.channelDetails.add(channel);
        }
    }

    private WorkerDataChannel getWorkerDataChannel(ChannelDetails channel) {
        WorkerDataChannel dataChannel = channel.channelInSameStrand ? this.wdChannels.getWorkerDataChannel(channel.name) : this.parent.wdChannels.getWorkerDataChannel(channel.name);
        return dataChannel;
    }

    public void setState(State state) {
        this.lock();
        this.state = state;
        this.unlock();
    }

    public State getState() {
        return this.state;
    }

    public boolean isBlocked() {
        return (this.state.getStatus() & State.BLOCK_AND_YIELD.getStatus()) == State.BLOCK_AND_YIELD.getStatus();
    }

    public boolean isBlockedOn() {
        return (this.state.getStatus() & State.BLOCK_ON_AND_YIELD.getStatus()) == State.BLOCK_ON_AND_YIELD.getStatus();
    }

    public boolean isYielded() {
        return (this.state.getStatus() & State.YIELD.getStatus()) == State.YIELD.getStatus();
    }

    public boolean isBlockedOnExtern() {
        return this.blockedOnExtern;
    }

    public void lock() {
        this.strandLock.lock();
    }

    public void unlock() {
        this.strandLock.unlock();
    }

    public int getId() {
        return this.id;
    }

    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    public StrandMetadata getMetadata() {
        return this.metadata;
    }

    public static class WaitResult {
        public boolean done;
        public Object result;

        public WaitResult(boolean done, Object result) {
            this.done = done;
            this.result = result;
        }
    }

    public static class FlushDetail {
        public ChannelDetails[] flushChannels;
        public int flushedCount;
        public Lock flushLock;
        public ErrorValue result;
        public boolean inProgress;
        public Throwable panic;

        public FlushDetail(ChannelDetails[] flushChannels) {
            this.flushChannels = flushChannels;
            this.flushedCount = 0;
            this.flushLock = new ReentrantLock();
            this.result = null;
            this.inProgress = false;
        }
    }
}

