/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.flags.TypeFlags;
import io.ballerina.runtime.api.types.IntersectionType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.internal.types.BType;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

public class BIntersectionType
extends BType
implements IntersectionType {
    private static final String PADDED_AMPERSAND = " & ";
    private static final String OPENING_PARENTHESIS = "(";
    private static final String CLOSING_PARENTHESIS = ")";
    private List<Type> constituentTypes;
    private Type effectiveType;
    private int typeFlags;
    private final boolean readonly;
    private IntersectionType immutableType;

    public BIntersectionType(Module pkg, Type[] constituentTypes, Type effectiveType, int typeFlags, boolean readonly) {
        super(null, pkg, Object.class);
        this.constituentTypes = Arrays.asList(constituentTypes);
        this.effectiveType = effectiveType;
        this.typeFlags = typeFlags;
        this.readonly = readonly;
        if (readonly) {
            this.immutableType = this;
        }
    }

    public List<Type> getConstituentTypes() {
        return this.constituentTypes;
    }

    @Override
    public <V> V getZeroValue() {
        return this.effectiveType.getZeroValue();
    }

    @Override
    public <V> V getEmptyValue() {
        return this.effectiveType.getEmptyValue();
    }

    @Override
    public int getTag() {
        return 22;
    }

    @Override
    public String toString() {
        StringJoiner joiner = new StringJoiner(PADDED_AMPERSAND, OPENING_PARENTHESIS, CLOSING_PARENTHESIS);
        for (Type constituentType : this.constituentTypes) {
            if (constituentType.getTag() == 10) {
                joiner.add("()");
                continue;
            }
            joiner.add(constituentType.toString());
        }
        return joiner.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BIntersectionType)) {
            return false;
        }
        BIntersectionType that = (BIntersectionType)o;
        if (this.constituentTypes.size() != that.constituentTypes.size()) {
            return false;
        }
        for (int i = 0; i < this.constituentTypes.size(); ++i) {
            if (this.constituentTypes.get(i).equals(that.constituentTypes.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getName() {
        return this.toString();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.constituentTypes);
    }

    @Override
    public boolean isNilable() {
        return TypeFlags.isFlagOn(this.typeFlags, 1);
    }

    @Override
    public boolean isAnydata() {
        return TypeFlags.isFlagOn(this.typeFlags, 2);
    }

    @Override
    public boolean isPureType() {
        return TypeFlags.isFlagOn(this.typeFlags, 4);
    }

    public int getTypeFlags() {
        return this.typeFlags;
    }

    @Override
    public boolean isReadOnly() {
        return this.readonly;
    }

    @Override
    public Type getImmutableType() {
        return this.immutableType;
    }

    @Override
    public void setImmutableType(IntersectionType immutableType) {
        this.immutableType = immutableType;
    }

    @Override
    public Type getEffectiveType() {
        return this.effectiveType;
    }
}

