/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.PredefinedTypes;
import io.ballerina.runtime.api.flags.TypeFlags;
import io.ballerina.runtime.api.types.IntersectionType;
import io.ballerina.runtime.api.types.JsonType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.internal.types.BIntersectionType;
import io.ballerina.runtime.internal.types.BType;
import io.ballerina.runtime.internal.values.MapValueImpl;

public class BJsonType
extends BType
implements JsonType {
    private final boolean readonly;
    private IntersectionType immutableType;

    public BJsonType(String typeName, Module pkg, boolean readonly) {
        super(typeName, pkg, MapValueImpl.class);
        this.readonly = readonly;
        if (!readonly) {
            BJsonType immutableJsonType = new BJsonType("json & readonly", pkg, true);
            this.immutableType = new BIntersectionType(pkg, new Type[]{this, PredefinedTypes.TYPE_READONLY}, immutableJsonType, TypeFlags.asMask(1, 2, 4), true);
        }
    }

    public BJsonType() {
        super("json", null, MapValueImpl.class);
        this.readonly = false;
        BJsonType immutableJsonType = new BJsonType("json & readonly", this.pkg, true);
        this.immutableType = new BIntersectionType(this.pkg, new Type[]{this, PredefinedTypes.TYPE_READONLY}, immutableJsonType, TypeFlags.asMask(1, 2, 4), true);
    }

    @Override
    public <V> V getZeroValue() {
        return null;
    }

    @Override
    public <V> V getEmptyValue() {
        return (V)new MapValueImpl(this);
    }

    @Override
    public int getTag() {
        return 7;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof BJsonType)) {
            return false;
        }
        return super.equals(obj) && this.readonly == ((BJsonType)obj).readonly;
    }

    @Override
    public boolean isNilable() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return this.readonly;
    }

    @Override
    public Type getImmutableType() {
        return this.immutableType;
    }

    @Override
    public void setImmutableType(IntersectionType immutableType) {
        this.immutableType = immutableType;
    }
}

