/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.PredefinedTypes;
import io.ballerina.runtime.api.types.IntersectionType;
import io.ballerina.runtime.api.types.MapType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.internal.types.BType;
import io.ballerina.runtime.internal.values.MapValueImpl;

public class BMapType
extends BType
implements MapType {
    private Type constraint;
    private final boolean readonly;
    private IntersectionType immutableType;

    public BMapType(String typeName, Type constraint, Module pkg) {
        super(typeName, pkg, MapValueImpl.class);
        this.constraint = constraint;
        this.readonly = false;
    }

    public BMapType(String typeName, Type constraint, Module pkg, boolean readonly) {
        super(typeName, pkg, MapValueImpl.class);
        this.constraint = constraint;
        this.readonly = readonly;
    }

    public BMapType(Type constraint) {
        this(constraint, false);
    }

    public BMapType(Type constraint, boolean readonly) {
        super("map", null, MapValueImpl.class);
        this.constraint = constraint;
        this.readonly = readonly;
    }

    @Override
    public Type getConstrainedType() {
        return this.constraint;
    }

    @Deprecated
    public Type getElementType() {
        return this.constraint;
    }

    @Override
    public <V> V getZeroValue() {
        return (V)new MapValueImpl(new BMapType(this.constraint));
    }

    @Override
    public <V> V getEmptyValue() {
        return this.getZeroValue();
    }

    @Override
    public int getTag() {
        return 15;
    }

    @Override
    public String toString() {
        Object stringRep = this.constraint == PredefinedTypes.TYPE_ANY ? super.toString() : "map<" + this.constraint.toString() + ">";
        return !this.readonly ? stringRep : ((String)stringRep).concat(" & readonly");
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj) || !(obj instanceof BMapType)) {
            return false;
        }
        BMapType other = (BMapType)obj;
        if (this.readonly != other.readonly) {
            return false;
        }
        if (this.constraint == other.constraint) {
            return true;
        }
        return this.constraint.equals(other.constraint);
    }

    @Override
    public boolean isAnydata() {
        return this.constraint.isPureType();
    }

    @Override
    public boolean isReadOnly() {
        return this.readonly;
    }

    @Override
    public Type getImmutableType() {
        return this.immutableType;
    }

    @Override
    public void setImmutableType(IntersectionType immutableType) {
        this.immutableType = immutableType;
    }
}

