/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types;

import io.ballerina.runtime.api.types.FunctionType;
import io.ballerina.runtime.api.types.MemberFunctionType;
import io.ballerina.runtime.api.types.ObjectType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.internal.types.BFunctionType;
import io.ballerina.runtime.internal.types.BObjectType;
import java.util.StringJoiner;

public class BMemberFunctionType
extends BFunctionType
implements MemberFunctionType {
    public String funcName;
    public BFunctionType type;
    public BObjectType parentObjectType;

    public BMemberFunctionType(String funcName, BObjectType parent, BFunctionType type, long flags) {
        this.funcName = funcName;
        this.type = type;
        this.parentObjectType = parent;
        this.flags = flags;
    }

    @Override
    public String toString() {
        StringJoiner sj = new StringJoiner(",", "function " + this.funcName + "(", ") returns (" + this.type.retType + ")");
        for (Type type : this.type.paramTypes) {
            sj.add(type.getName());
        }
        return sj.toString();
    }

    @Override
    public Type[] getParameterTypes() {
        return this.type.paramTypes;
    }

    @Override
    public String getName() {
        return this.funcName;
    }

    @Override
    public String getAnnotationKey() {
        return this.parentObjectType.getAnnotationKey() + "." + this.funcName;
    }

    @Override
    public ObjectType getParentObjectType() {
        return this.parentObjectType;
    }

    @Override
    public FunctionType getType() {
        return this.type;
    }
}

