/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.flags.SymbolFlags;
import io.ballerina.runtime.api.types.MemberFunctionType;
import io.ballerina.runtime.api.types.ResourceFunctionType;
import io.ballerina.runtime.api.types.ServiceType;
import io.ballerina.runtime.internal.types.BMemberFunctionType;
import io.ballerina.runtime.internal.types.BObjectType;
import java.util.ArrayList;

public class BServiceType
extends BObjectType
implements ServiceType {
    private ResourceFunctionType[] resourceFunctions;
    private volatile MemberFunctionType[] remoteFunctions;

    public BServiceType(String typeName, Module pkg, long flags) {
        super(typeName, pkg, flags);
    }

    public void setResourceFunctions(ResourceFunctionType[] resourceFunctions) {
        this.resourceFunctions = resourceFunctions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MemberFunctionType[] getRemoteFunctions() {
        if (this.remoteFunctions == null) {
            MemberFunctionType[] funcs = this.getRemoteFunctions(this.getAttachedFunctions());
            BServiceType bServiceType = this;
            synchronized (bServiceType) {
                if (this.remoteFunctions == null) {
                    this.remoteFunctions = funcs;
                }
            }
        }
        return this.remoteFunctions;
    }

    private MemberFunctionType[] getRemoteFunctions(MemberFunctionType[] attachedFunctions) {
        ArrayList<MemberFunctionType> functions = new ArrayList<MemberFunctionType>();
        for (MemberFunctionType funcType : attachedFunctions) {
            if (!SymbolFlags.isFlagOn(((BMemberFunctionType)funcType).flags, 32768L)) continue;
            functions.add(funcType);
        }
        return functions.toArray(new MemberFunctionType[0]);
    }

    @Override
    public ResourceFunctionType[] getResourceFunctions() {
        return this.resourceFunctions;
    }

    @Override
    public int getTag() {
        return 19;
    }
}

