/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types;

import io.ballerina.runtime.api.flags.TypeFlags;
import io.ballerina.runtime.api.types.IntersectionType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.UnionType;
import io.ballerina.runtime.internal.types.BType;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class BUnionType
extends BType
implements UnionType {
    public static final char PIPE = '|';
    private List<Type> memberTypes;
    private Boolean nullable;
    private String cachedToString;
    private int typeFlags;
    private final boolean readonly;
    private IntersectionType immutableType;

    @Deprecated
    public BUnionType() {
        super(null, null, Object.class);
        this.readonly = false;
    }

    public BUnionType(List<Type> memberTypes, int typeFlags) {
        this(memberTypes, typeFlags, false);
    }

    public BUnionType(List<Type> memberTypes, int typeFlags, boolean readonly) {
        super(null, null, Object.class);
        this.memberTypes = memberTypes;
        this.typeFlags = typeFlags;
        this.readonly = readonly;
    }

    public BUnionType(List<Type> memberTypes) {
        this(memberTypes, false);
    }

    public BUnionType(List<Type> memberTypes, boolean readonly) {
        this(memberTypes, 0, readonly);
        boolean nilable = false;
        boolean isAnydata = true;
        boolean isPureType = true;
        for (Type memberType : memberTypes) {
            nilable |= memberType.isNilable();
            isAnydata &= memberType.isAnydata();
            isPureType &= memberType.isPureType();
        }
        if (nilable) {
            this.typeFlags = TypeFlags.addToMask(this.typeFlags, 1);
        }
        if (isAnydata) {
            this.typeFlags = TypeFlags.addToMask(this.typeFlags, 2);
        }
        if (isPureType) {
            this.typeFlags = TypeFlags.addToMask(this.typeFlags, 4);
        }
    }

    public BUnionType(Type[] memberTypes, int typeFlags, boolean readonly) {
        this(Arrays.asList(memberTypes), typeFlags, readonly);
    }

    public BUnionType(Type[] memberTypes, int typeFlags) {
        this(memberTypes, typeFlags, false);
    }

    @Override
    public List<Type> getMemberTypes() {
        return this.memberTypes;
    }

    public boolean isNullable() {
        return this.isNilable();
    }

    @Override
    public <V> V getZeroValue() {
        if (this.isNilable() || this.memberTypes.stream().anyMatch(Type::isNilable)) {
            return null;
        }
        return this.memberTypes.get(0).getZeroValue();
    }

    @Override
    public <V> V getEmptyValue() {
        if (this.isNilable() || this.memberTypes.stream().anyMatch(Type::isNilable)) {
            return null;
        }
        return this.memberTypes.get(0).getEmptyValue();
    }

    @Override
    public int getTag() {
        return 21;
    }

    @Override
    public String toString() {
        if (this.cachedToString == null) {
            StringBuilder sb = new StringBuilder();
            int size = this.memberTypes.size();
            int i = 0;
            while (i < size) {
                sb.append(this.memberTypes.get(i).toString());
                if (++i >= size) continue;
                sb.append('|');
            }
            this.cachedToString = sb.toString();
        }
        return this.cachedToString;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BUnionType)) {
            return false;
        }
        BUnionType that = (BUnionType)o;
        if (this.memberTypes.size() != that.memberTypes.size()) {
            return false;
        }
        for (int i = 0; i < this.memberTypes.size(); ++i) {
            if (this.memberTypes.get(i).equals(that.memberTypes.get(i))) continue;
            return false;
        }
        return this.readonly == that.readonly;
    }

    @Override
    public String getName() {
        return this.toString();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.memberTypes);
    }

    @Override
    public boolean isNilable() {
        if (this.nullable == null) {
            this.nullable = this.checkNillable(this.memberTypes);
        }
        return this.nullable;
    }

    private boolean checkNillable(List<Type> memberTypes) {
        for (Type t : memberTypes) {
            if (!t.isNilable()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAnydata() {
        return TypeFlags.isFlagOn(this.typeFlags, 2);
    }

    @Override
    public boolean isPureType() {
        return TypeFlags.isFlagOn(this.typeFlags, 4);
    }

    public int getTypeFlags() {
        return this.typeFlags;
    }

    @Override
    public boolean isReadOnly() {
        return this.readonly;
    }

    @Override
    public Type getImmutableType() {
        return this.immutableType;
    }

    @Override
    public void setImmutableType(IntersectionType immutableType) {
        this.immutableType = immutableType;
    }
}

