/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.util;

import java.io.PrintStream;

public class CompatibilityChecker {
    private static final String JAVA_VERSION = "java.version";
    private static final String VERSION_ZERO = "0";
    private static final PrintStream stderr = System.err;

    public static void verifyJavaCompatibility(String compiledVersion) {
        String[] runtimeVersionParts;
        String runtimeVersion = System.getProperty(JAVA_VERSION);
        if (compiledVersion == null || runtimeVersion == null || compiledVersion.equals(runtimeVersion)) {
            return;
        }
        String[] compiledVersionParts = compiledVersion.split("\\.|_");
        if (!compiledVersionParts[0].equals((runtimeVersionParts = runtimeVersion.split("\\.|_"))[0])) {
            String compiledMajorVersion = compiledVersionParts.length > 1 ? compiledVersionParts[1] : VERSION_ZERO;
            CompatibilityChecker.logJavaVersionMismatchError(runtimeVersion, compiledVersionParts[0], compiledMajorVersion);
            return;
        }
        if (compiledVersionParts.length == 1 && compiledVersionParts.length == 1) {
            return;
        }
        if (compiledVersionParts.length == 1) {
            if (!runtimeVersionParts[1].equals(VERSION_ZERO)) {
                CompatibilityChecker.logJavaVersionMismatchError(runtimeVersion, compiledVersionParts[0], VERSION_ZERO);
            }
            return;
        }
        if (runtimeVersionParts.length == 1) {
            if (!compiledVersionParts[1].equals(VERSION_ZERO)) {
                CompatibilityChecker.logJavaVersionMismatchError(runtimeVersion, compiledVersionParts[0], compiledVersionParts[1]);
            }
            return;
        }
        if (!compiledVersionParts[1].equals(runtimeVersionParts[1])) {
            CompatibilityChecker.logJavaVersionMismatchError(runtimeVersion, compiledVersionParts[0], compiledVersionParts[1]);
        }
    }

    private static void logJavaVersionMismatchError(String runtimeVersion, String compiledMajorVersion, String compiledMinorVersion) {
        stderr.println("WARNING: Incompatible JRE version '" + runtimeVersion + "' found. This ballerina program supports running on JRE version '" + compiledMajorVersion + "." + compiledMinorVersion + ".*'");
    }
}

