/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.util.exceptions;

import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BString;

public class BallerinaErrorReasons {
    private static final String BALLERINA_PREFIX = "{ballerina}";
    private static final String BALLERINA_ORG_PREFIX = "{ballerina/";
    private static final String CLOSING_CURLY_BRACE = "}";
    public static final BString TYPE_CAST_ERROR = StringUtils.fromString("{ballerina}".concat("TypeCastError"));
    public static final BString NUMBER_CONVERSION_ERROR = StringUtils.fromString("{ballerina}".concat("NumberConversionError"));
    public static final BString JSON_OPERATION_ERROR = StringUtils.fromString("{ballerina}".concat("JSONOperationError"));
    public static final BString DIVISION_BY_ZERO_ERROR = StringUtils.fromString("{ballerina}".concat("DivisionByZero"));
    public static final BString NUMBER_OVERFLOW = StringUtils.fromString("{ballerina}".concat("NumberOverflow"));
    public static final BString ARITHMETIC_OPERATION_ERROR = StringUtils.fromString("{ballerina}".concat("ArithmeticOperationError"));
    public static final BString JAVA_NULL_REFERENCE_ERROR = StringUtils.fromString("{ballerina}".concat("JavaNullReferenceError"));
    public static final String JAVA_CLASS_NOT_FOUND_ERROR = "{ballerina}".concat("JavaClassNotFoundError");
    public static final BString BALLERINA_PREFIXED_CONVERSION_ERROR = StringUtils.fromString("{ballerina}".concat("ConversionError"));
    public static final BString ITERATOR_MUTABILITY_ERROR = StringUtils.fromString("{ballerina}".concat("IteratorMutabilityError"));
    public static final String NUMBER_PARSING_ERROR_IDENTIFIER = "NumberParsingError";
    public static final String BOOLEAN_PARSING_ERROR_IDENTIFIER = "BooleanParsingError";
    public static final String INVALID_UPDATE_ERROR_IDENTIFIER = "InvalidUpdate";
    public static final String INDEX_OUT_OF_RANGE_ERROR_IDENTIFIER = "IndexOutOfRange";
    public static final String INHERENT_TYPE_VIOLATION_ERROR_IDENTIFIER = "InherentTypeViolation";
    public static final String OPERATION_NOT_SUPPORTED_IDENTIFIER = "OperationNotSupported";
    public static final String KEY_NOT_FOUND_ERROR_IDENTIFIER = "KeyNotFound";
    public static final String INVALID_TYPE_TO_SORT = "InvalidTypeToSort";
    public static final BString INDEX_OUT_OF_RANGE_ERROR = StringUtils.fromString("IndexOutOfRange");
    public static final BString OPERATION_NOT_SUPPORTED_ERROR = StringUtils.fromString("OperationNotSupported");
    public static final BString JSON_CONVERSION_ERROR = StringUtils.fromString("{ballerina}".concat("JSONConversionError"));
    public static final BString STACK_OVERFLOW_ERROR = StringUtils.fromString("{ballerina}".concat("StackOverflow"));
    public static final BString CONSTRUCT_FROM_CONVERSION_ERROR = BallerinaErrorReasons.getModulePrefixedReason("lang.typedesc", "ConversionError");
    public static final BString VALUE_LANG_LIB_CONVERSION_ERROR = BallerinaErrorReasons.getModulePrefixedReason("lang.value", "ConversionError");
    public static final BString CONSTRUCT_FROM_CYCLIC_VALUE_REFERENCE_ERROR = BallerinaErrorReasons.getModulePrefixedReason("lang.typedesc", "CyclicValueReferenceError");
    public static final BString VALUE_LANG_LIB_CYCLIC_VALUE_REFERENCE_ERROR = BallerinaErrorReasons.getModulePrefixedReason("lang.value", "CyclicValueReferenceError");
    public static final BString MERGE_JSON_ERROR = BallerinaErrorReasons.getModulePrefixedReason("lang.value", "MergeJsonError");
    public static final BString STRING_OPERATION_ERROR = BallerinaErrorReasons.getModulePrefixedReason("lang.string", "StringOperationError");
    public static final BString XML_OPERATION_ERROR = BallerinaErrorReasons.getModulePrefixedReason("lang.xml", "XMLOperationError");
    public static final BString MAP_KEY_NOT_FOUND_ERROR = BallerinaErrorReasons.getModulePrefixedReason("lang.map", "KeyNotFound");
    public static final BString TABLE_KEY_NOT_FOUND_ERROR = BallerinaErrorReasons.getModulePrefixedReason("lang.table", "KeyNotFound");
    public static final BString TABLE_KEY_CYCLIC_VALUE_REFERENCE_ERROR = BallerinaErrorReasons.getModulePrefixedReason("lang.table", "CyclicValueReferenceError");
    public static final BString TABLE_HAS_A_VALUE_FOR_KEY_ERROR = BallerinaErrorReasons.getModulePrefixedReason("lang.table", "KeyConstraintViolation");
    public static final BString ILLEGAL_LIST_INSERTION_ERROR = BallerinaErrorReasons.getModulePrefixedReason("lang.array", "IllegalListInsertion");
    public static final BString FUTURE_CANCELLED = BallerinaErrorReasons.getModulePrefixedReason("lang.future", "FutureAlreadyCancelled");
    public static final BString ASYNC_CALL_INSIDE_LOCK = StringUtils.fromString("{ballerina}".concat("AsyncCallInsideLockError"));

    public static BString getModulePrefixedReason(String moduleName, String identifier) {
        return StringUtils.fromString(BALLERINA_ORG_PREFIX.concat(moduleName).concat(CLOSING_CURLY_BRACE).concat(identifier));
    }
}

