/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.values;

import io.ballerina.runtime.api.PredefinedTypes;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.XmlValidator;
import io.ballerina.runtime.internal.types.BMapType;
import io.ballerina.runtime.internal.util.exceptions.BLangExceptionHelper;
import io.ballerina.runtime.internal.util.exceptions.BallerinaErrorReasons;
import io.ballerina.runtime.internal.util.exceptions.RuntimeErrors;
import io.ballerina.runtime.internal.values.MapValueImpl;

class AttributeMapValueImpl
extends MapValueImpl<BString, BString> {
    public AttributeMapValueImpl() {
        super(new BMapType(PredefinedTypes.TYPE_STRING));
    }

    public AttributeMapValueImpl(boolean readonly) {
        super(new BMapType(PredefinedTypes.TYPE_STRING));
        if (readonly) {
            this.freezeDirect();
        }
    }

    @Override
    public BString put(BString keyBStr, BString value) {
        if (this.isFrozen()) {
            throw ErrorCreator.createError(BallerinaErrorReasons.getModulePrefixedReason("lang.xml", "InvalidUpdate"), BLangExceptionHelper.getErrorMessage(RuntimeErrors.INVALID_READONLY_VALUE_UPDATE, new Object[0]));
        }
        return this.insertValue(keyBStr, value, false);
    }

    @Override
    public void populateInitialValue(BString key, BString value) {
        this.insertValue(key, value, true);
    }

    void setAttribute(String localName, String namespaceUri, String prefix, String value, boolean onInitialization) {
        PutAttributeFunction func;
        PutAttributeFunction putAttributeFunction = func = onInitialization ? (x$0, x$1) -> super.populateInitialValue(x$0, x$1) : (x$0, x$1) -> {
            BString cfr_ignored_0 = (BString)super.put(x$0, x$1);
        };
        if (localName == null || localName.isEmpty()) {
            throw ErrorCreator.createError(StringUtils.fromString("localname of the attribute cannot be empty"));
        }
        XmlValidator.validateXMLName(localName);
        XmlValidator.validateXMLName(prefix);
        if (namespaceUri == null && prefix != null && prefix.equals("xmlns") || localName.equals("xmlns")) {
            String nsNameDecl = "{http://www.w3.org/2000/xmlns/}" + localName;
            func.put(StringUtils.fromString(nsNameDecl), StringUtils.fromString(value));
            return;
        }
        BString nsOfPrefix = (BString)this.get(StringUtils.fromString("{http://www.w3.org/2000/xmlns/}" + prefix));
        if (namespaceUri != null && nsOfPrefix != null && !namespaceUri.equals(nsOfPrefix.getValue())) {
            String errorMsg = String.format("failed to add attribute '%s:%s'. prefix '%s' is already bound to namespace '%s'", prefix, localName, prefix, nsOfPrefix.getValue());
            throw ErrorCreator.createError(StringUtils.fromString(errorMsg));
        }
        if (namespaceUri == null || namespaceUri.isEmpty()) {
            func.put(StringUtils.fromString(localName), StringUtils.fromString(value));
        } else {
            func.put(StringUtils.fromString("{" + namespaceUri + "}" + localName), StringUtils.fromString(value));
        }
        if (prefix != null && prefix.equals("xmlns")) {
            String xmlnsPrefix = "{http://www.w3.org/2000/xmlns/}" + prefix;
            func.put(StringUtils.fromString(xmlnsPrefix), StringUtils.fromString(namespaceUri));
        }
    }

    private BString insertValue(BString keyBStr, BString value, boolean onInitialization) {
        BString keyToInsert;
        String key = keyBStr.getValue();
        String localName = "";
        String namespaceUri = "";
        int closingCurlyPos = key.lastIndexOf(125);
        if (closingCurlyPos == -1) {
            localName = key;
        } else {
            namespaceUri = key.substring(1, closingCurlyPos);
            localName = key.substring(closingCurlyPos + 1);
        }
        if (localName.isEmpty()) {
            throw ErrorCreator.createError(StringUtils.fromString("localname of the attribute cannot be empty"));
        }
        XmlValidator.validateXMLName(localName);
        BString bString = keyToInsert = namespaceUri.isEmpty() ? StringUtils.fromString(localName) : keyBStr;
        if (!onInitialization) {
            return super.put(keyToInsert, value);
        }
        super.populateInitialValue(keyToInsert, value);
        return null;
    }

    private static interface PutAttributeFunction {
        public void put(BString var1, BString var2);
    }
}

