/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.values;

import io.ballerina.runtime.api.values.BLink;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.values.NonBmpStringValue;
import io.ballerina.runtime.internal.values.StringValue;

public class BmpStringValue
implements StringValue {
    private final String value;

    public BmpStringValue(String value) {
        this.value = value;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public int getCodePoint(int index) {
        return this.value.charAt(index);
    }

    @Override
    public int length() {
        return this.value.length();
    }

    @Override
    public BString concat(BString str) {
        if (str instanceof BmpStringValue) {
            return new BmpStringValue(this.value + ((BmpStringValue)str).value);
        }
        if (str instanceof NonBmpStringValue) {
            return new NonBmpStringValue(this.value + str.getValue(), ((NonBmpStringValue)str).getSurrogates());
        }
        throw new RuntimeException("not impl yet");
    }

    @Override
    public String stringValue(BLink parent) {
        return this.value;
    }

    @Override
    public String informalStringValue(BLink parent) {
        return "\"" + this.toString() + "\"";
    }

    @Override
    public String expressionStringValue(BLink parent) {
        return this.informalStringValue(parent);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object str) {
        if (str == this) {
            return true;
        }
        if (str instanceof BString) {
            return ((BString)str).getValue().equals(this.value);
        }
        return false;
    }

    public String toString() {
        return this.value;
    }

    @Override
    public Long indexOf(BString str, int fromIndex) {
        long index = this.value.indexOf(str.getValue(), fromIndex);
        return index >= 0L ? Long.valueOf(index) : null;
    }

    @Override
    public Long lastIndexOf(BString str, int fromIndex) {
        long index = this.value.lastIndexOf(str.getValue(), fromIndex);
        return index >= 0L ? Long.valueOf(index) : null;
    }

    @Override
    public BString substring(int beginIndex, int endIndex) {
        return new BmpStringValue(this.value.substring(beginIndex, endIndex));
    }
}

