/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.values;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.PredefinedTypes;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.IdentifierUtils;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BLink;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BValue;
import io.ballerina.runtime.internal.CycleUtils;
import io.ballerina.runtime.internal.TypeChecker;
import io.ballerina.runtime.internal.services.ErrorHandlerUtils;
import io.ballerina.runtime.internal.types.BErrorType;
import io.ballerina.runtime.internal.types.BTypeIdSet;
import io.ballerina.runtime.internal.util.exceptions.BallerinaErrorReasons;
import io.ballerina.runtime.internal.values.MapValue;
import io.ballerina.runtime.internal.values.RefValue;
import io.ballerina.runtime.internal.values.StringValue;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;

public class ErrorValue
extends BError
implements RefValue {
    private static final long serialVersionUID = 1L;
    private final Type type;
    private final BString message;
    private final BError cause;
    private final Object details;
    private static final String GENERATE_OBJECT_CLASS_PREFIX = ".$value$";
    private static final String GENERATE_PKG_INIT = "___init_";
    private static final String GENERATE_PKG_START = "___start_";
    private static final String GENERATE_PKG_STOP = "___stop_";
    private static final String INIT_FUNCTION_SUFFIX = "..<init>";
    private static final String START_FUNCTION_SUFFIX = ".<start>";
    private static final String STOP_FUNCTION_SUFFIX = ".<stop>";

    public ErrorValue(BString message, Object details) {
        this(new BErrorType("error", PredefinedTypes.TYPE_ERROR.getPackage(), TypeChecker.getType(details)), message, null, details);
    }

    public ErrorValue(Type type, BString message, BError cause, Object details) {
        super(message);
        this.type = type;
        this.message = message;
        this.cause = cause;
        this.details = details;
    }

    public ErrorValue(Type type, BString message, BError cause, Object details, String typeIdName, Module typeIdPkg) {
        super(message);
        this.type = type;
        this.message = message;
        this.cause = cause;
        this.details = details;
        BTypeIdSet typeIdSet = new BTypeIdSet();
        typeIdSet.add(typeIdPkg, typeIdName, true);
        ((BErrorType)type).setTypeIdSet(typeIdSet);
    }

    @Override
    public String stringValue(BLink parent) {
        CycleUtils.Node linkParent = new CycleUtils.Node(this, parent);
        if (this.isEmptyDetail()) {
            return "error" + this.getModuleNameToString() + "(" + ((StringValue)this.message).informalStringValue(linkParent) + ")";
        }
        return "error" + this.getModuleNameToString() + "(" + ((StringValue)this.message).informalStringValue(linkParent) + this.getCauseToString(linkParent) + this.getDetailsToString(linkParent) + ")";
    }

    @Override
    public String expressionStringValue(BLink parent) {
        CycleUtils.Node linkParent = new CycleUtils.Node(this, parent);
        if (this.isEmptyDetail()) {
            return "error" + this.getModuleNameToBalString() + "(" + ((StringValue)this.message).informalStringValue(linkParent) + ")";
        }
        return "error" + this.getModuleNameToBalString() + "(" + ((StringValue)this.message).expressionStringValue(linkParent) + this.getCauseToBalString(linkParent) + this.getDetailsToBalString(linkParent) + ")";
    }

    private String getCauseToString(BLink parent) {
        if (this.cause != null) {
            return "," + this.cause.informalStringValue(parent);
        }
        return "";
    }

    private String getDetailsToString(BLink parent) {
        StringJoiner sj = new StringJoiner(",");
        block3: for (Object key : ((MapValue)this.details).getKeys()) {
            Object value = ((MapValue)this.details).get(key);
            if (value == null) {
                sj.add(key + "=null");
                continue;
            }
            Type type = TypeChecker.getType(value);
            switch (type.getTag()) {
                case 5: 
                case 8: 
                case 26: 
                case 28: 
                case 47: 
                case 48: 
                case 49: 
                case 50: {
                    sj.add(key + "=" + ((BValue)value).informalStringValue(parent));
                    continue block3;
                }
                default: {
                    sj.add(key + "=" + StringUtils.getStringValue(value, parent));
                }
            }
        }
        return "," + sj.toString();
    }

    private String getModuleNameToString() {
        return this.type.getPackage().getName() == null ? "" : " " + this.type.getName() + " ";
    }

    private String getDetailsToBalString(BLink parent) {
        StringJoiner sj = new StringJoiner(",");
        for (Object key : ((MapValue)this.details).getKeys()) {
            Object value = ((MapValue)this.details).get(key);
            sj.add(key + "=" + StringUtils.getExpressionStringValue(value, parent));
        }
        return "," + sj.toString();
    }

    private String getCauseToBalString(BLink parent) {
        if (this.cause != null) {
            return "," + this.cause.expressionStringValue(parent);
        }
        return "";
    }

    private String getModuleNameToBalString() {
        return this.type.getPackage().getOrg() != null && this.type.getPackage().getOrg().equals("$anon") || this.type.getPackage().getName() == null ? " " + this.type.getName() + " " : String.valueOf(BallerinaErrorReasons.getModulePrefixedReason(this.type.getPackage().getName(), this.type.getName()));
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public Object copy(Map<Object, Object> refs) {
        return this;
    }

    @Override
    public Object frozenCopy(Map<Object, Object> refs) {
        return this;
    }

    @Override
    public void freezeDirect() {
    }

    @Override
    public String toString() {
        return this.stringValue(null);
    }

    @Override
    public BString getErrorMessage() {
        return this.message;
    }

    @Override
    public Object getDetails() {
        if (this.details instanceof RefValue) {
            return ((RefValue)this.details).copy(new HashMap<Object, Object>());
        }
        return this.details;
    }

    @Override
    public BError getCause() {
        return this.cause;
    }

    @Override
    public void printStackTrace() {
        ErrorHandlerUtils.printError("error: " + this.getPrintableStackTrace());
    }

    @Override
    public void printStackTrace(PrintWriter printWriter) {
        printWriter.print("error: " + this.getPrintableStackTrace());
    }

    @Override
    public StackTraceElement[] getStackTrace() {
        StackTraceElement[] stackTrace = super.getStackTrace();
        LinkedList filteredStack = new LinkedList();
        int index = 0;
        for (StackTraceElement stackFrame : stackTrace) {
            Optional<StackTraceElement> stackTraceElement = this.filterStackTraceElement(stackFrame, index++);
            stackTraceElement.ifPresent(filteredStack::add);
        }
        StackTraceElement[] filteredStackArray = new StackTraceElement[filteredStack.size()];
        return filteredStack.toArray(filteredStackArray);
    }

    @Override
    public String getPrintableStackTrace() {
        String errorMsg = this.getPrintableError();
        StringBuilder sb = new StringBuilder();
        sb.append(errorMsg);
        StackTraceElement[] stackTrace = this.getStackTrace();
        if (stackTrace.length == 0) {
            return sb.toString();
        }
        sb.append("\n\tat ");
        this.printStackElement(sb, stackTrace[0], "");
        for (int i = 1; i < stackTrace.length; ++i) {
            this.printStackElement(sb, stackTrace[i], "\n\t   ");
        }
        return sb.toString();
    }

    @Override
    public List<StackTraceElement> getCallStack() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        LinkedList<StackTraceElement> filteredStack = new LinkedList<StackTraceElement>();
        int index = 0;
        for (StackTraceElement stackFrame : stackTrace) {
            Optional<StackTraceElement> stackTraceElement = this.filterStackTraceElement(stackFrame, index++);
            stackTraceElement.ifPresent(filteredStack::add);
        }
        return filteredStack;
    }

    private void printStackElement(StringBuilder sb, StackTraceElement stackTraceElement, String tab) {
        String pkgName = IdentifierUtils.decodeIdentifier(stackTraceElement.getClassName());
        String fileName = stackTraceElement.getFileName();
        fileName = fileName.replace(".bal", "");
        int index = pkgName.lastIndexOf("." + (fileName = fileName.replace("/", "-")));
        if (index != -1) {
            pkgName = pkgName.substring(0, index);
        }
        sb.append(tab);
        if (!pkgName.equals("$_init")) {
            sb.append(pkgName).append(":");
        }
        sb.append(IdentifierUtils.decodeIdentifier(stackTraceElement.getMethodName()));
        sb.append("(").append(stackTraceElement.getFileName());
        sb.append(":").append(stackTraceElement.getLineNumber()).append(")");
    }

    private String getPrintableError() {
        StringJoiner joiner = new StringJoiner(" ");
        joiner.add(this.message.getValue());
        if (this.cause != null) {
            joiner.add("cause: " + this.cause.getMessage());
        }
        if (!this.isEmptyDetail()) {
            joiner.add(this.details.toString());
        }
        return joiner.toString();
    }

    private boolean isEmptyDetail() {
        if (this.details == null) {
            return true;
        }
        return this.details instanceof MapValue && ((MapValue)this.details).isEmpty();
    }

    private Optional<StackTraceElement> filterStackTraceElement(StackTraceElement stackFrame, int currentIndex) {
        String fileName = stackFrame.getFileName();
        int lineNo = stackFrame.getLineNumber();
        if (lineNo < 0) {
            return Optional.empty();
        }
        String className = stackFrame.getClassName();
        String methodName = stackFrame.getMethodName();
        if (className.equals("$_init")) {
            if (currentIndex == 0) {
                return Optional.empty();
            }
            switch (methodName) {
                case "___init_": {
                    methodName = INIT_FUNCTION_SUFFIX;
                    break;
                }
                case "___start_": {
                    methodName = START_FUNCTION_SUFFIX;
                    break;
                }
                case "___stop_": {
                    methodName = STOP_FUNCTION_SUFFIX;
                    break;
                }
                default: {
                    return Optional.empty();
                }
            }
            return Optional.of(new StackTraceElement(this.cleanupClassName(className), methodName, fileName, stackFrame.getLineNumber()));
        }
        if (fileName != null && !fileName.endsWith(".bal")) {
            return Optional.empty();
        }
        return Optional.of(new StackTraceElement(this.cleanupClassName(className), methodName, fileName, stackFrame.getLineNumber()));
    }

    private String cleanupClassName(String className) {
        return className.replace(GENERATE_OBJECT_CLASS_PREFIX, ".");
    }
}

