/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.values;

import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BLink;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.values.BmpStringValue;
import io.ballerina.runtime.internal.values.StringValue;
import java.util.Arrays;

public class NonBmpStringValue
implements StringValue {
    private final String value;
    private final int[] surrogates;

    public NonBmpStringValue(String value, int[] surrogatePairLocations) {
        this.value = value;
        this.surrogates = surrogatePairLocations;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public int getCodePoint(int index) {
        if (index < 0 || index >= this.value.length() - this.surrogates.length) {
            throw new StringIndexOutOfBoundsException(index);
        }
        int offset = index;
        for (int surrogate : this.surrogates) {
            if (surrogate < index) {
                ++offset;
                continue;
            }
            if (surrogate > index) break;
            return Character.toCodePoint(this.value.charAt(offset), this.value.charAt(offset + 1));
        }
        return this.value.charAt(offset);
    }

    @Override
    public int length() {
        return this.value.length() - this.surrogates.length;
    }

    @Override
    public BString concat(BString str) {
        if (str instanceof NonBmpStringValue) {
            NonBmpStringValue other = (NonBmpStringValue)str;
            int[] both = Arrays.copyOf(this.surrogates, this.surrogates.length + other.surrogates.length);
            System.arraycopy(other.surrogates, 0, both, this.surrogates.length, other.surrogates.length);
            return new NonBmpStringValue(this.value + other.value, both);
        }
        if (str instanceof BmpStringValue) {
            BmpStringValue other = (BmpStringValue)str;
            return new NonBmpStringValue(this.value + other.getValue(), this.surrogates);
        }
        throw new RuntimeException("not impl yet");
    }

    @Override
    public String stringValue(BLink parent) {
        return this.value;
    }

    @Override
    public String informalStringValue(BLink parent) {
        return "\"" + this.toString() + "\"";
    }

    @Override
    public String expressionStringValue(BLink parent) {
        return this.informalStringValue(parent);
    }

    public int[] getSurrogates() {
        return (int[])this.surrogates.clone();
    }

    public String toString() {
        return this.value;
    }

    public boolean equals(Object str) {
        if (str == this) {
            return true;
        }
        if (str instanceof BString) {
            return ((BString)str).getValue().equals(this.value);
        }
        return false;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public Long indexOf(BString str, int fromIndex) {
        int offset = this.getOffset(fromIndex);
        long index = this.value.indexOf(str.getValue(), offset);
        if (index < 0L) {
            return null;
        }
        int i = 0;
        while ((long)i < index) {
            char c = this.value.charAt(i);
            if (Character.isHighSurrogate(c)) {
                --index;
            }
            ++i;
        }
        return index;
    }

    @Override
    public Long lastIndexOf(BString str, int fromIndex) {
        int offset = this.getOffset(fromIndex);
        long index = this.value.lastIndexOf(str.getValue(), offset);
        if (index < 0L) {
            return null;
        }
        int i = 0;
        while ((long)i < index) {
            char c = this.value.charAt(i);
            if (Character.isHighSurrogate(c)) {
                --index;
            }
            ++i;
        }
        return index;
    }

    @Override
    public BString substring(int beginIndex, int endIndex) {
        int beginOffset = this.getOffset(beginIndex);
        int endOffset = this.getOffset(endIndex);
        return StringUtils.fromString(this.value.substring(beginOffset, endOffset));
    }

    private int getOffset(int fromIndex) {
        int offset = fromIndex;
        for (int surrogate : this.surrogates) {
            if (surrogate >= fromIndex) break;
            ++offset;
        }
        return offset;
    }
}

