/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.values;

import io.ballerina.runtime.api.PredefinedTypes;
import io.ballerina.runtime.api.values.BLink;
import io.ballerina.runtime.api.values.BStreamingJson;
import io.ballerina.runtime.internal.JsonDataSource;
import io.ballerina.runtime.internal.JsonGenerator;
import io.ballerina.runtime.internal.JsonUtils;
import io.ballerina.runtime.internal.types.BArrayType;
import io.ballerina.runtime.internal.types.BMapType;
import io.ballerina.runtime.internal.values.AbstractArrayValue;
import io.ballerina.runtime.internal.values.ArrayValueImpl;
import io.ballerina.runtime.internal.values.IteratorValue;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Map;

public class StreamingJsonValue
extends ArrayValueImpl
implements BStreamingJson {
    JsonDataSource datasource;

    @Deprecated
    public StreamingJsonValue(JsonDataSource datasource) {
        super(new BArrayType(new BMapType(PredefinedTypes.TYPE_JSON)));
        this.datasource = datasource;
    }

    @Override
    public void add(long index, Object value) {
        while (index >= (long)this.size && this.datasource.hasNext()) {
            this.appendToCache(this.datasource.next());
        }
        super.add(index, value);
    }

    @Override
    public void append(Object value) {
        if (this.datasource.hasNext()) {
            this.buildDatasource();
        }
        super.append(value);
    }

    @Override
    public Object getRefValue(long index) {
        while (index >= (long)this.size && this.datasource.hasNext()) {
            this.appendToCache(this.datasource.next());
        }
        return super.getRefValue(index);
    }

    public void serialize(JsonGenerator gen) {
        try {
            gen.writeStartArray();
            for (int i = 0; i < this.size; ++i) {
                gen.serialize(this.refValues[i]);
            }
            while (this.datasource.hasNext()) {
                gen.serialize(this.datasource.next());
            }
            gen.writeEndArray();
            gen.flush();
        }
        catch (IOException e) {
            throw JsonUtils.createJsonConversionError(e, "error occurred while serializing data");
        }
    }

    @Override
    public void serialize(Writer writer) {
        this.serialize(new JsonGenerator(writer));
    }

    @Override
    public void serialize(OutputStream outputStream) {
        this.serialize(new JsonGenerator(outputStream));
    }

    @Override
    public Object[] getValues() {
        if (this.datasource.hasNext()) {
            this.buildDatasource();
        }
        return this.refValues;
    }

    @Override
    public String toString() {
        if (this.datasource.hasNext()) {
            this.buildDatasource();
        }
        return super.toString();
    }

    @Override
    public String stringValue(BLink parent) {
        if (this.datasource.hasNext()) {
            this.buildDatasource();
        }
        return super.stringValue(parent);
    }

    @Override
    public String expressionStringValue(BLink parent) {
        return this.stringValue(parent);
    }

    @Override
    public int size() {
        if (this.datasource.hasNext()) {
            this.buildDatasource();
        }
        return this.size;
    }

    void appendToCache(Object value) {
        super.add((long)this.size, value);
    }

    @Override
    public String getJSONString() {
        this.buildDatasource();
        return super.getJSONString();
    }

    @Override
    public Object copy(Map<Object, Object> refs) {
        this.buildDatasource();
        return super.copy(refs);
    }

    private void buildDatasource() {
        try {
            while (this.datasource.hasNext()) {
                this.appendToCache(this.datasource.next());
            }
        }
        catch (Throwable t) {
            throw JsonUtils.createJsonConversionError(t, "error occurred while building JSON");
        }
    }

    @Override
    public IteratorValue getIterator() {
        return new AbstractArrayValue.ArrayIterator(this);
    }

    static class StreamingJsonIterator
    implements IteratorValue {
        StreamingJsonValue array;
        long cursor = 0L;

        StreamingJsonIterator(StreamingJsonValue value) {
            this.array = value;
        }

        public Object next() {
            Object value;
            if (this.cursor < (long)this.array.size) {
                value = this.array.get(this.cursor);
            } else {
                value = this.array.datasource.next();
                this.array.appendToCache(value);
            }
            ++this.cursor;
            return value;
        }

        @Override
        public boolean hasNext() {
            if (this.cursor < (long)this.array.size) {
                return true;
            }
            return this.array.datasource.hasNext();
        }
    }
}

