/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.values;

import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.Field;
import io.ballerina.runtime.api.types.TableType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BLink;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.CycleUtils;
import io.ballerina.runtime.internal.IteratorUtils;
import io.ballerina.runtime.internal.TableUtils;
import io.ballerina.runtime.internal.TypeChecker;
import io.ballerina.runtime.internal.types.BMapType;
import io.ballerina.runtime.internal.types.BRecordType;
import io.ballerina.runtime.internal.types.BTableType;
import io.ballerina.runtime.internal.types.BTupleType;
import io.ballerina.runtime.internal.util.exceptions.BLangFreezeException;
import io.ballerina.runtime.internal.util.exceptions.BallerinaErrorReasons;
import io.ballerina.runtime.internal.values.ArrayValue;
import io.ballerina.runtime.internal.values.IteratorValue;
import io.ballerina.runtime.internal.values.MapValue;
import io.ballerina.runtime.internal.values.ReadOnlyUtils;
import io.ballerina.runtime.internal.values.RefValue;
import io.ballerina.runtime.internal.values.TableValue;
import io.ballerina.runtime.internal.values.TableValueImpl;
import io.ballerina.runtime.internal.values.TupleValueImpl;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class TableValueImpl<K, V>
implements TableValue<K, V> {
    private TableType type;
    private Type iteratorNextReturnType;
    private ConcurrentHashMap<Long, Map.Entry<K, V>> entries;
    private LinkedHashMap<Long, V> values;
    private LinkedHashMap<Long, K> keys;
    private String[] fieldNames;
    private ValueHolder valueHolder;
    private long maxIntKey = 0L;
    private LinkedHashMap<Long, Long> indexToKeyMap;
    private LinkedHashMap<Long, Long> keyToIndexMap;
    private long noOfAddedEntries = 0L;
    private boolean nextKeySupported;
    private final Map<String, Object> nativeData = new HashMap<String, Object>();

    public TableValueImpl(TableType type) {
        this.type = type;
        this.entries = new ConcurrentHashMap();
        this.keys = new LinkedHashMap();
        this.values = new LinkedHashMap();
        this.keyToIndexMap = new LinkedHashMap();
        this.indexToKeyMap = new LinkedHashMap();
        this.fieldNames = type.getFieldNames();
        this.valueHolder = type.getFieldNames() != null ? new KeyHashValueHolder() : new ValueHolder();
    }

    public TableValueImpl(BTableType type, ArrayValue data, ArrayValue fieldNames) {
        this(type);
        if (this.fieldNames == null) {
            this.fieldNames = fieldNames.getStringArray();
        }
        this.addData(data);
    }

    private void addData(ArrayValue data) {
        IteratorValue itr = data.getIterator();
        while (itr.hasNext()) {
            Object next = itr.next();
            this.valueHolder.addData(next);
        }
    }

    @Override
    public IteratorValue getIterator() {
        return new TableIterator();
    }

    @Override
    public Object copy(Map<Object, Object> refs) {
        if (this.isFrozen()) {
            return this;
        }
        if (refs.containsKey(this)) {
            return refs.get(this);
        }
        TableValueImpl<K, Object> clone = new TableValueImpl<K, Object>(this.type);
        if (this.fieldNames != null) {
            clone.fieldNames = this.fieldNames;
        }
        IteratorValue itr = this.getIterator();
        while (itr.hasNext()) {
            TupleValueImpl tupleValue = (TupleValueImpl)itr.next();
            Object value = tupleValue.get(1L);
            value = value instanceof RefValue ? ((RefValue)value).copy(refs) : value;
            clone.add(value);
        }
        return clone;
    }

    @Override
    public Object frozenCopy(Map<Object, Object> refs) {
        TableValueImpl copy = (TableValueImpl)this.copy(refs);
        if (!copy.isFrozen()) {
            copy.freezeDirect();
        }
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleFrozenTableValue() {
        TableValueImpl tableValueImpl = this;
        synchronized (tableValueImpl) {
            try {
                if (this.type.isReadOnly()) {
                    ReadOnlyUtils.handleInvalidUpdate("lang.table");
                }
            }
            catch (BLangFreezeException e) {
                throw ErrorCreator.createError(StringUtils.fromString(e.getMessage()), StringUtils.fromString(e.getDetail()));
            }
        }
    }

    @Override
    public V get(Object key) {
        return this.valueHolder.getData(key);
    }

    @Override
    public V put(V value) {
        this.handleFrozenTableValue();
        return this.valueHolder.putData(value);
    }

    @Override
    public V put(K key, V value) {
        this.handleFrozenTableValue();
        return this.valueHolder.putData(key, value);
    }

    @Override
    public void add(V data) {
        this.handleFrozenTableValue();
        this.valueHolder.addData(data);
    }

    @Override
    public V remove(Object key) {
        this.handleFrozenTableValue();
        return this.valueHolder.remove(key);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.valueHolder.containsKey(key);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new LinkedHashSet<Map.Entry<K, V>>(this.entries.values());
    }

    @Override
    public Collection<V> values() {
        return this.values.values();
    }

    @Override
    public void clear() {
        this.handleFrozenTableValue();
        this.entries.clear();
        this.keys.clear();
        this.values.clear();
        this.keyToIndexMap.clear();
        this.indexToKeyMap.clear();
        this.noOfAddedEntries = 0L;
    }

    @Override
    public V getOrThrow(Object key) {
        if (!this.containsKey(key)) {
            throw ErrorCreator.createError(BallerinaErrorReasons.TABLE_KEY_NOT_FOUND_ERROR, StringUtils.fromString("cannot find key '" + key + "'"));
        }
        return this.get(key);
    }

    @Override
    public V removeOrThrow(Object key) {
        this.handleFrozenTableValue();
        if (!this.containsKey(key)) {
            throw ErrorCreator.createError(BallerinaErrorReasons.TABLE_KEY_NOT_FOUND_ERROR, StringUtils.fromString("cannot find key '" + key + "'"));
        }
        return this.remove(key);
    }

    @Override
    public long getNextKey() {
        if (!this.nextKeySupported) {
            throw ErrorCreator.createError(BallerinaErrorReasons.OPERATION_NOT_SUPPORTED_ERROR, StringUtils.fromString("Defined key sequence is not supported with nextKey(). The key sequence should only have an Integer field."));
        }
        return this.keys.size() == 0 ? 0L : this.maxIntKey + 1L;
    }

    @Override
    public Type getKeyType() {
        return this.valueHolder.getKeyType();
    }

    @Override
    public V fillAndGet(Object key) {
        if (this.containsKey(key)) {
            return this.get(key);
        }
        Type expectedType = this.type.getConstrainedType();
        if (!TypeChecker.hasFillerValue(expectedType)) {
            throw ErrorCreator.createError(BallerinaErrorReasons.TABLE_KEY_NOT_FOUND_ERROR, StringUtils.fromString("cannot find key '" + key + "'"));
        }
        Object value = expectedType.getZeroValue();
        this.put(key, value);
        return value;
    }

    @Override
    public K[] getKeys() {
        return this.keys.values().toArray(new Object[0]);
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    @Override
    public void addNativeData(String key, Object data) {
        this.nativeData.put(key, data);
    }

    @Override
    public Object getNativeData(String key) {
        return this.nativeData.get(key);
    }

    @Override
    public void freezeDirect() {
        if (this.isFrozen()) {
            return;
        }
        this.type = (BTableType)ReadOnlyUtils.setImmutableTypeAndGetEffectiveType(this.type);
        this.values().forEach(val -> ((RefValue)val).freezeDirect());
    }

    @Override
    public String stringValue(BLink parent) {
        Iterator<Map.Entry<Long, V>> itr = this.values.entrySet().iterator();
        return this.createStringValueDataEntry(itr, parent);
    }

    @Override
    public String informalStringValue(BLink parent) {
        return this.stringValue(parent);
    }

    @Override
    public String expressionStringValue(BLink parent) {
        Iterator<Map.Entry<Long, V>> itr = this.values.entrySet().iterator();
        return this.createExpressionStringValueDataEntry(itr, parent);
    }

    private String createStringValueDataEntry(Iterator<Map.Entry<Long, V>> itr, BLink parent) {
        StringJoiner sj = new StringJoiner(",");
        while (itr.hasNext()) {
            Map.Entry<Long, V> struct = itr.next();
            sj.add(StringUtils.getStringValue(struct.getValue(), new CycleUtils.Node(this, parent)));
        }
        return "[" + sj.toString() + "]";
    }

    private String createExpressionStringValueDataEntry(Iterator<Map.Entry<Long, V>> itr, BLink parent) {
        StringJoiner sj = new StringJoiner(",");
        StringJoiner keyJoiner = new StringJoiner(",");
        if (this.type.getFieldNames() != null) {
            String[] keysList = this.type.getFieldNames();
            for (int i = 0; i < keysList.length; ++i) {
                keyJoiner.add(keysList[i]);
            }
        }
        while (itr.hasNext()) {
            Map.Entry<Long, V> struct = itr.next();
            sj.add(StringUtils.getExpressionStringValue(struct.getValue(), new CycleUtils.Node(this, parent)));
        }
        return "table key(" + keyJoiner.toString() + ") [" + sj.toString() + "]";
    }

    private Type getTableConstraintField(Type constraintType, String fieldName) {
        if (constraintType.getTag() == 12) {
            Map<String, Field> fieldList = ((BRecordType)constraintType).getFields();
            return fieldList.get(fieldName).getFieldType();
        }
        if (constraintType.getTag() == 15) {
            return ((BMapType)constraintType).getConstrainedType();
        }
        return null;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public Type getIteratorNextReturnType() {
        if (this.iteratorNextReturnType == null) {
            this.iteratorNextReturnType = IteratorUtils.createIteratorNextReturnType(this.type.getConstrainedType());
        }
        return this.iteratorNextReturnType;
    }

    private void updateIndexKeyMappings(Long hash) {
        if (!this.keyToIndexMap.containsKey(hash)) {
            this.keyToIndexMap.put(hash, this.noOfAddedEntries);
            this.indexToKeyMap.put(this.noOfAddedEntries, hash);
            ++this.noOfAddedEntries;
        }
    }

    private void checkInherentTypeViolation(MapValue dataMap, TableType type) {
        if (!TypeChecker.checkIsType(dataMap.getType(), type.getConstrainedType())) {
            BString reason = BallerinaErrorReasons.getModulePrefixedReason("lang.table", "InherentTypeViolation");
            BString detail = StringUtils.fromString("value type '" + dataMap.getType() + "' inconsistent with the inherent table type '" + type + "'");
            throw ErrorCreator.createError(reason, detail);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableValueImpl tableValue = (TableValueImpl)o;
        if (tableValue.type.getTag() != this.type.getTag()) {
            return false;
        }
        if (this.entrySet().size() != tableValue.entrySet().size()) {
            return false;
        }
        return this.entrySet().equals(tableValue.entrySet());
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public Long getIntValue(BString key) {
        return (Long)this.get(key);
    }

    @Override
    public Double getFloatValue(BString key) {
        return (Double)this.get(key);
    }

    @Override
    public BString getStringValue(BString key) {
        return (BString)this.get(key);
    }

    @Override
    public Boolean getBooleanValue(BString key) {
        return (Boolean)this.get(key);
    }

    @Override
    public BMap<?, ?> getMapValue(BString key) {
        return (BMap)this.get(key);
    }

    @Override
    public BObject getObjectValue(BString key) {
        return (BObject)this.get(key);
    }

    @Override
    public BArray getArrayValue(BString key) {
        return (BArray)this.get(key);
    }

    private class KeyHashValueHolder
    extends ValueHolder {
        private io.ballerina.runtime.internal.values.TableValueImpl$KeyHashValueHolder.DefaultKeyWrapper keyWrapper;
        private Type keyType;

        public KeyHashValueHolder() {
            this.keyWrapper = TableValueImpl.this.fieldNames.length > 1 ? new MultiKeyWrapper() : new DefaultKeyWrapper();
        }

        @Override
        public void addData(V data) {
            MapValue dataMap = (MapValue)data;
            TableValueImpl.this.checkInherentTypeViolation(dataMap, TableValueImpl.this.type);
            Object key = this.keyWrapper.wrapKey(dataMap);
            if (this.containsKey(key)) {
                throw ErrorCreator.createError(BallerinaErrorReasons.TABLE_HAS_A_VALUE_FOR_KEY_ERROR, StringUtils.fromString("A value found for key '" + key + "'"));
            }
            if (TableValueImpl.this.nextKeySupported && (TableValueImpl.this.keys.size() == 0 || TableValueImpl.this.maxIntKey < TypeChecker.anyToInt(key))) {
                TableValueImpl.this.maxIntKey = Long.valueOf(TypeChecker.anyToInt(key)).intValue();
            }
            AbstractMap.SimpleEntry entry = new AbstractMap.SimpleEntry(key, data);
            Long hash = TableUtils.hash(key, null);
            this.putData(key, data, entry, hash);
        }

        @Override
        public V getData(K key) {
            return TableValueImpl.this.values.get(TableUtils.hash(key, null));
        }

        @Override
        public V putData(K key, V data) {
            AbstractMap.SimpleEntry entry = new AbstractMap.SimpleEntry(key, data);
            Object actualKey = this.keyWrapper.wrapKey((MapValue)data);
            Long actualHash = TableUtils.hash(actualKey, null);
            Long hash = TableUtils.hash(key, null);
            if (!hash.equals(actualHash)) {
                throw ErrorCreator.createError(BallerinaErrorReasons.TABLE_KEY_NOT_FOUND_ERROR, StringUtils.fromString("The key '" + key + "' not found in value " + data.toString()));
            }
            return this.putData(key, data, entry, hash);
        }

        private V putData(K key, V data, Map.Entry<K, V> entry, Long hash) {
            TableValueImpl.this.entries.put(hash, entry);
            TableValueImpl.this.keys.put(hash, (Long)key);
            TableValueImpl.this.updateIndexKeyMappings(hash);
            return TableValueImpl.this.values.put(hash, data);
        }

        @Override
        public V putData(V data) {
            MapValue dataMap = (MapValue)data;
            TableValueImpl.this.checkInherentTypeViolation(dataMap, TableValueImpl.this.type);
            Object key = this.keyWrapper.wrapKey(dataMap);
            AbstractMap.SimpleEntry entry = new AbstractMap.SimpleEntry(key, data);
            Long hash = TableUtils.hash(key, null);
            return this.putData(key, data, entry, hash);
        }

        @Override
        public V remove(K key) {
            Long hash = TableUtils.hash(key, null);
            TableValueImpl.this.entries.remove(hash);
            TableValueImpl.this.keys.remove(hash);
            Long index = (Long)TableValueImpl.this.keyToIndexMap.remove(hash);
            TableValueImpl.this.indexToKeyMap.remove(index);
            if (index != null && index == TableValueImpl.this.noOfAddedEntries - 1L) {
                --TableValueImpl.this.noOfAddedEntries;
            }
            return TableValueImpl.this.values.remove(hash);
        }

        @Override
        public boolean containsKey(K key) {
            return TableValueImpl.this.keys.containsKey(TableUtils.hash(key, null));
        }

        @Override
        public Type getKeyType() {
            return this.keyType;
        }

        /*
         * Signature claims super is io.ballerina.runtime.internal.values.TableValueImpl$KeyHashValueHolder.DefaultKeyWrapper, not io.ballerina.runtime.internal.values.TableValueImpl$KeyHashValueHolder$DefaultKeyWrapper - discarding signature.
         */
        private class MultiKeyWrapper
        extends DefaultKeyWrapper {
            public MultiKeyWrapper() {
                ArrayList<Type> keyTypes = new ArrayList<Type>();
                Type constraintType = TableValueImpl.this.type.getConstrainedType();
                if (constraintType.getTag() == 12) {
                    BRecordType recordType = (BRecordType)constraintType;
                    Arrays.stream(TableValueImpl.this.fieldNames).forEach(field -> keyTypes.add(recordType.getFields().get(field).getFieldType()));
                } else if (constraintType.getTag() == 15) {
                    BMapType mapType = (BMapType)constraintType;
                    Arrays.stream(TableValueImpl.this.fieldNames).forEach(field -> keyTypes.add(mapType.getConstrainedType()));
                }
                KeyHashValueHolder.this.keyType = new BTupleType(keyTypes);
            }

            @Override
            public K wrapKey(MapValue data) {
                TupleValueImpl arr = (TupleValueImpl)ValueCreator.createTupleValue((BTupleType)KeyHashValueHolder.this.keyType);
                for (int i = 0; i < TableValueImpl.this.fieldNames.length; ++i) {
                    arr.add((long)i, data.get(StringUtils.fromString(TableValueImpl.this.fieldNames[i])));
                }
                return arr;
            }
        }

        private class DefaultKeyWrapper {
            public DefaultKeyWrapper() {
                if (TableValueImpl.this.fieldNames.length == 1) {
                    KeyHashValueHolder.this.keyType = TableValueImpl.this.getTableConstraintField(TableValueImpl.this.type.getConstrainedType(), TableValueImpl.this.fieldNames[0]);
                    if (KeyHashValueHolder.this.keyType != null && KeyHashValueHolder.this.keyType.getTag() == 1) {
                        TableValueImpl.this.nextKeySupported = true;
                    }
                }
            }

            public K wrapKey(MapValue data) {
                return data.get(StringUtils.fromString(TableValueImpl.this.fieldNames[0]));
            }
        }
    }

    private class ValueHolder {
        private ValueHolder() {
        }

        public void addData(V data) {
            this.putData(data);
        }

        public V getData(K key) {
            throw ErrorCreator.createError(BallerinaErrorReasons.TABLE_KEY_NOT_FOUND_ERROR, StringUtils.fromString("cannot find key '" + key + "'"));
        }

        public V putData(K key, V data) {
            throw ErrorCreator.createError(BallerinaErrorReasons.TABLE_KEY_NOT_FOUND_ERROR, StringUtils.fromString("cannot find key '" + key + "'"));
        }

        public V putData(V data) {
            TableValueImpl.this.checkInherentTypeViolation((MapValue)data, TableValueImpl.this.type);
            AbstractMap.SimpleEntry entry = new AbstractMap.SimpleEntry(data, data);
            UUID uuid = UUID.randomUUID();
            TableValueImpl.this.entries.put(Long.valueOf(uuid.hashCode()), entry);
            TableValueImpl.this.updateIndexKeyMappings(Long.valueOf(uuid.hashCode()));
            return TableValueImpl.this.values.put(Long.valueOf(uuid.hashCode()), data);
        }

        public V remove(K key) {
            throw ErrorCreator.createError(BallerinaErrorReasons.TABLE_KEY_NOT_FOUND_ERROR, StringUtils.fromString("cannot find key '" + key + "'"));
        }

        public boolean containsKey(K key) {
            return false;
        }

        public Type getKeyType() {
            throw ErrorCreator.createError(BallerinaErrorReasons.TABLE_KEY_NOT_FOUND_ERROR, StringUtils.fromString("keys are not defined"));
        }
    }

    private class TableIterator<K, V>
    implements IteratorValue {
        private long cursor = 0L;

        TableIterator() {
        }

        public Object next() {
            Long hash = TableValueImpl.this.indexToKeyMap.get(this.cursor);
            if (hash != null) {
                Map.Entry next = TableValueImpl.this.entries.get(hash);
                Object value = next.getValue();
                Object key = next.getKey();
                ArrayList<Type> types = new ArrayList<Type>();
                types.add(TypeChecker.getType(key));
                types.add(TypeChecker.getType(value));
                BTupleType tupleType = new BTupleType(types);
                TupleValueImpl tuple = new TupleValueImpl(tupleType);
                tuple.add(0L, key);
                tuple.add(1L, value);
                ++this.cursor;
                return tuple;
            }
            ++this.cursor;
            return this.next();
        }

        @Override
        public boolean hasNext() {
            return this.cursor < TableValueImpl.this.noOfAddedEntries;
        }
    }
}

