/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.values;

import io.ballerina.runtime.api.PredefinedTypes;
import io.ballerina.runtime.api.constants.RuntimeConstants;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.XmlNodeType;
import io.ballerina.runtime.api.values.BLink;
import io.ballerina.runtime.api.values.BXml;
import io.ballerina.runtime.internal.values.IteratorValue;
import io.ballerina.runtime.internal.values.XmlNonElementItem;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.llom.CharacterDataImpl;

public class XmlText
extends XmlNonElementItem {
    private String data;

    public XmlText(String data) {
        this.data = data;
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public String getItemType() {
        return this.getNodeType().value();
    }

    @Override
    public Object copy(Map<Object, Object> refs) {
        return this;
    }

    @Override
    public Object frozenCopy(Map<Object, Object> refs) {
        return this;
    }

    @Override
    public String getTextValue() {
        return this.data;
    }

    @Override
    public BXml strip() {
        if (!this.data.trim().isEmpty()) {
            return this;
        }
        return new XmlText("");
    }

    @Override
    public XmlNodeType getNodeType() {
        return XmlNodeType.TEXT;
    }

    @Override
    public OMNode value() {
        CharacterDataImpl characterData = new CharacterDataImpl();
        characterData.data = this.data;
        return characterData;
    }

    @Override
    public String stringValue(BLink parent) {
        try {
            return this.data;
        }
        catch (Throwable t) {
            XmlText.handleXmlException("failed to get xml as string: ", t);
            return RuntimeConstants.STRING_NULL_VALUE;
        }
    }

    @Override
    public IteratorValue getIterator() {
        return new IteratorValue(){
            boolean read = false;

            @Override
            public boolean hasNext() {
                return !this.read;
            }

            public Object next() {
                if (!this.read) {
                    this.read = true;
                    return XmlText.this.data;
                }
                throw new NoSuchElementException();
            }
        };
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof XmlText) {
            XmlText that = (XmlText)obj;
            return this.data.equals(that.data);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.data);
    }

    @Override
    public Type getType() {
        return PredefinedTypes.TYPE_TEXT;
    }
}

