/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.observability;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.types.ObjectType;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.scheduling.Scheduler;
import io.ballerina.runtime.internal.values.ErrorValue;
import io.ballerina.runtime.observability.BallerinaObserver;
import io.ballerina.runtime.observability.ObserverContext;
import io.ballerina.runtime.observability.tracer.BSpan;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;
import org.ballerinalang.config.ConfigRegistry;

public class ObserveUtils {
    private static final List<BallerinaObserver> observers = new CopyOnWriteArrayList<BallerinaObserver>();
    private static final boolean enabled;
    private static final boolean metricsEnabled;
    private static final boolean tracingEnabled;

    public static void addObserver(BallerinaObserver observer) {
        observers.add(observer);
    }

    public static void startResourceObservation(Environment env, BString module, BString position, BString serviceName, BString resourcePathOrFunction, BString resourceAccessor, boolean isResource, boolean isRemote) {
        if (!enabled) {
            return;
        }
        ObserverContext observerContext = ObserveUtils.getObserverContextOfCurrentFrame(env);
        if (observerContext == null) {
            observerContext = new ObserverContext();
            ObserveUtils.setObserverContextToCurrentFrame(env, observerContext);
        }
        if (observerContext.isStarted()) {
            ObserverContext newObserverContext = new ObserverContext();
            ObserveUtils.setObserverContextToCurrentFrame(env, newObserverContext);
            newObserverContext.setEntrypointFunctionModule(observerContext.getEntrypointFunctionModule());
            newObserverContext.setEntrypointFunctionPosition(observerContext.getEntrypointFunctionPosition());
            newObserverContext.setParent(observerContext);
            observerContext = newObserverContext;
        } else {
            observerContext.setEntrypointFunctionModule(module.getValue());
            observerContext.setEntrypointFunctionPosition(position.getValue());
        }
        observerContext.setServiceName(serviceName.getValue());
        if (isResource) {
            observerContext.setOperationName(resourceAccessor.getValue() + " " + resourcePathOrFunction.getValue());
            observerContext.addTag("src.service.resource", "true");
            observerContext.addTag("src.resource.accessor", resourceAccessor.getValue());
            observerContext.addTag("src.resource.path", resourcePathOrFunction.getValue());
        } else if (isRemote) {
            observerContext.setOperationName(serviceName.getValue() + ":" + resourcePathOrFunction.getValue());
            observerContext.addTag("src.service.remote", "true");
            observerContext.addTag("src.function.name", resourcePathOrFunction.getValue());
        } else {
            observerContext.setOperationName(serviceName.getValue() + ":" + resourcePathOrFunction.getValue());
            observerContext.addTag("src.function.name", resourcePathOrFunction.getValue());
        }
        observerContext.addTag("src.object.name", serviceName.getValue());
        observerContext.addTag("src.module", module.getValue());
        observerContext.addTag("src.position", position.getValue());
        if (observerContext.getEntrypointFunctionModule() != null) {
            observerContext.addTag("entrypoint.function.module", observerContext.getEntrypointFunctionModule());
        }
        if (observerContext.getEntrypointFunctionPosition() != null) {
            observerContext.addTag("entrypoint.function.position", observerContext.getEntrypointFunctionPosition());
        }
        observerContext.setServer();
        observerContext.setStarted();
        for (BallerinaObserver observer : observers) {
            observer.startServerObservation(observerContext);
        }
    }

    public static void stopObservation(Environment env) {
        if (!enabled) {
            return;
        }
        ObserverContext observerContext = ObserveUtils.getObserverContextOfCurrentFrame(env);
        if (observerContext == null) {
            return;
        }
        if (observerContext.isServer()) {
            observers.forEach(observer -> observer.stopServerObservation(observerContext));
        } else {
            observers.forEach(observer -> observer.stopClientObservation(observerContext));
        }
        ObserveUtils.setObserverContextToCurrentFrame(env, observerContext.getParent());
        observerContext.setFinished();
    }

    public static void reportError(Environment env, ErrorValue errorValue) {
        if (!enabled) {
            return;
        }
        ObserverContext observerContext = ObserveUtils.getObserverContextOfCurrentFrame(env);
        if (observerContext == null) {
            return;
        }
        observers.forEach(observer -> {
            observerContext.addTag("error", "true");
            observerContext.addProperty("bstruct_error", errorValue);
        });
    }

    public static void startCallableObservation(Environment env, BString module, BString position, BObject typeDef, BString functionName, boolean isMainEntryPoint, boolean isRemote, boolean isWorker) {
        if (!enabled) {
            return;
        }
        ObserverContext prevObserverCtx = ObserveUtils.getObserverContextOfCurrentFrame(env);
        ObserverContext newObContext = new ObserverContext();
        ObserveUtils.setObserverContextToCurrentFrame(env, newObContext);
        if (prevObserverCtx != null) {
            newObContext.setServiceName(prevObserverCtx.getServiceName());
            newObContext.setEntrypointFunctionModule(prevObserverCtx.getEntrypointFunctionModule());
            newObContext.setEntrypointFunctionPosition(prevObserverCtx.getEntrypointFunctionPosition());
            newObContext.setParent(prevObserverCtx);
        } else {
            newObContext.setServiceName("Unknown Service");
            newObContext.setEntrypointFunctionModule(module.getValue());
            newObContext.setEntrypointFunctionPosition(position.getValue());
        }
        if (isMainEntryPoint) {
            newObContext.addTag("src.main", "true");
        } else if (isRemote) {
            newObContext.addTag("src.client.remote", "true");
        } else if (isWorker) {
            newObContext.addTag("src.worker", "true");
        }
        if (typeDef != null) {
            ObjectType type = typeDef.getType();
            Module typeModule = type.getPackage();
            String objectName = typeModule.getOrg() + "/" + typeModule.getName() + "/" + type.getName();
            newObContext.setOperationName(objectName + ":" + functionName.getValue());
            newObContext.addTag("src.object.name", objectName);
        } else {
            newObContext.setOperationName(functionName.getValue());
        }
        newObContext.addTag("src.function.name", functionName.getValue());
        newObContext.addTag("src.module", module.getValue());
        newObContext.addTag("src.position", position.getValue());
        if (newObContext.getEntrypointFunctionModule() != null) {
            newObContext.addTag("entrypoint.function.module", newObContext.getEntrypointFunctionModule());
        }
        if (newObContext.getEntrypointFunctionPosition() != null) {
            newObContext.addTag("entrypoint.function.position", newObContext.getEntrypointFunctionPosition());
        }
        newObContext.setStarted();
        for (BallerinaObserver observer : observers) {
            observer.startClientObservation(newObContext);
        }
    }

    public static Map<String, String> getContextProperties(ObserverContext observerContext) {
        BSpan bSpan = (BSpan)observerContext.getProperty("_span_");
        if (bSpan != null) {
            return bSpan.getTraceContext();
        }
        return Collections.emptyMap();
    }

    @Deprecated
    public static void logMessageToActiveSpan(String logLevel, Supplier<String> logMessage, boolean isError) {
        if (!tracingEnabled) {
            return;
        }
        Environment balEnv = new Environment(Scheduler.getStrand());
        ObserverContext observerContext = (ObserverContext)balEnv.getStrandLocal("__observer_context__");
        if (observerContext == null) {
            return;
        }
        BSpan span = (BSpan)observerContext.getProperty("_span_");
        if (span == null) {
            return;
        }
        HashMap<String, Object> logs = new HashMap<String, Object>(1);
        logs.put(logLevel, logMessage.get());
        if (!isError) {
            span.log(logs);
        } else {
            span.logError(logs);
        }
    }

    public static boolean isObservabilityEnabled() {
        return enabled;
    }

    public static boolean isMetricsEnabled() {
        return metricsEnabled;
    }

    public static boolean isTracingEnabled() {
        return tracingEnabled;
    }

    public static ObserverContext getObserverContextOfCurrentFrame(Environment env) {
        if (!enabled) {
            return null;
        }
        return (ObserverContext)env.getStrandLocal("__observer_context__");
    }

    public static void setObserverContextToCurrentFrame(Environment env, ObserverContext observerContext) {
        if (!enabled) {
            return;
        }
        env.setStrandLocal("__observer_context__", observerContext);
    }

    static {
        ConfigRegistry configRegistry = ConfigRegistry.getInstance();
        tracingEnabled = configRegistry.getAsBoolean("b7a.observability.tracing.enabled");
        metricsEnabled = configRegistry.getAsBoolean("b7a.observability.metrics.enabled");
        enabled = metricsEnabled || tracingEnabled;
    }
}

