/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.observability.metrics;

import io.ballerina.runtime.observability.metrics.DefaultMetricRegistry;
import io.ballerina.runtime.observability.metrics.Metric;
import io.ballerina.runtime.observability.metrics.MetricId;
import io.ballerina.runtime.observability.metrics.MetricRegistry;
import io.ballerina.runtime.observability.metrics.Tag;
import io.ballerina.runtime.observability.metrics.Tags;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.ToDoubleFunction;

public interface PolledGauge
extends Metric {
    public static <T> Builder<T> builder(String name, T obj, ToDoubleFunction<T> valueFunction) {
        return new Builder<T>(name, obj, valueFunction);
    }

    @Override
    default public PolledGauge register() {
        return DefaultMetricRegistry.getInstance().register(this);
    }

    @Override
    default public void unregister() {
        DefaultMetricRegistry.getInstance().unregister(this);
    }

    public double getValue();

    public static class Builder<T>
    implements Metric.Builder<Builder<T>, PolledGauge> {
        private final String name;
        private final Set<Tag> tags = new HashSet<Tag>(10);
        private String description;
        private T obj;
        private ToDoubleFunction<T> valueFunction;

        private Builder(String name, T obj, ToDoubleFunction<T> valueFunction) {
            this.name = name;
            this.obj = obj;
            this.valueFunction = valueFunction;
        }

        @Override
        public Builder<T> description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public Builder tags(String ... keyValues) {
            Tags.tags(this.tags, keyValues);
            return this;
        }

        @Override
        public Builder tags(Iterable<Tag> tags) {
            Tags.tags(this.tags, tags);
            return this;
        }

        @Override
        public Builder tag(String key, String value) {
            Tags.tags(this.tags, key, value);
            return this;
        }

        @Override
        public Builder tags(Map<String, String> tags) {
            Tags.tags(this.tags, tags);
            return this;
        }

        @Override
        public PolledGauge register() {
            return this.register(DefaultMetricRegistry.getInstance());
        }

        @Override
        public PolledGauge register(MetricRegistry registry) {
            return registry.polledGauge(new MetricId(this.name, this.description, this.tags), this.obj, this.valueFunction);
        }

        @Override
        public PolledGauge build() {
            return DefaultMetricRegistry.getInstance().getMetricProvider().newPolledGauge(new MetricId(this.name, this.description, this.tags), this.obj, this.valueFunction);
        }
    }
}

