/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.observability.tracer;

import io.ballerina.runtime.observability.tracer.BSpan;
import io.ballerina.runtime.observability.tracer.TracersStore;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMapExtractAdapter;
import io.opentracing.propagation.TextMapInjectAdapter;
import java.util.HashMap;
import java.util.Map;

public class TraceManager {
    private static final TraceManager instance = new TraceManager();
    private final TracersStore tracerStore = TracersStore.getInstance();

    private TraceManager() {
    }

    public static TraceManager getInstance() {
        return instance;
    }

    public void startSpan(BSpan parentBSpan, BSpan activeBSpan) {
        if (activeBSpan != null) {
            String service = activeBSpan.getServiceName();
            String operationName = activeBSpan.getOperationName();
            Span span = parentBSpan != null ? this.startSpan(operationName, parentBSpan.getSpan(), activeBSpan.getTags(), service, false) : this.startSpan(operationName, this.extractSpanContext(activeBSpan.getProperties(), service), activeBSpan.getTags(), service, true);
            activeBSpan.setSpan(span);
        }
    }

    public void finishSpan(BSpan bSpan) {
        bSpan.getSpan().finish();
    }

    public void log(BSpan bSpan, Map<String, Object> fields) {
        bSpan.getSpan().log(fields);
    }

    public void addTags(BSpan bSpan, Map<String, String> tags) {
        tags.forEach((key, value) -> bSpan.getSpan().setTag((String)key, String.valueOf(value)));
    }

    public void addTag(BSpan bSpan, String tagKey, String tagValue) {
        bSpan.getSpan().setTag(tagKey, tagValue);
    }

    public Map<String, String> extractTraceContext(Span span, String serviceName) {
        HashMap<String, String> carrierMap = new HashMap<String, String>();
        Tracer tracer = this.tracerStore.getTracer(serviceName);
        if (tracer != null && span != null) {
            TextMapInjectAdapter requestInjector = new TextMapInjectAdapter(carrierMap);
            tracer.inject(span.context(), Format.Builtin.HTTP_HEADERS, requestInjector);
        }
        return carrierMap;
    }

    private Span startSpan(String spanName, Object spanContextMap, Map<String, String> tags, String serviceName, boolean isParent) {
        Tracer tracer = this.tracerStore.getTracer(serviceName);
        Tracer.SpanBuilder spanBuilder = tracer.buildSpan(spanName);
        for (Map.Entry<String, String> tag : tags.entrySet()) {
            spanBuilder = spanBuilder.withTag(tag.getKey(), tag.getValue());
        }
        if (spanContextMap != null) {
            spanBuilder = isParent ? spanBuilder.asChildOf((SpanContext)spanContextMap) : spanBuilder.asChildOf((Span)spanContextMap);
        }
        return spanBuilder.start();
    }

    private Object extractSpanContext(Map<String, String> traceContext, String serviceName) {
        SpanContext spanContext = null;
        Tracer tracer = this.tracerStore.getTracer(serviceName);
        if (tracer != null) {
            spanContext = tracer.extract(Format.Builtin.HTTP_HEADERS, new TextMapExtractAdapter(traceContext));
        }
        return spanContext;
    }
}

