/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.observability.tracer;

import io.ballerina.runtime.observability.tracer.InvalidConfigurationException;
import io.ballerina.runtime.observability.tracer.OpenTracer;
import io.opentracing.Tracer;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.ballerinalang.config.ConfigRegistry;

public class TracersStore {
    private OpenTracer tracerGenerator;
    private Map<String, Tracer> store;
    private static final PrintStream consoleError = System.err;
    private static final TracersStore instance = new TracersStore();

    public static TracersStore getInstance() {
        return instance;
    }

    private TracersStore() {
    }

    public void loadTracers() {
        ConfigRegistry configRegistry = ConfigRegistry.getInstance();
        if (configRegistry.getAsBoolean("b7a.observability.tracing.enabled")) {
            String overallProviderName = configRegistry.getConfigOrDefault("b7a.observability.provider", "jaeger");
            String tracerName = configRegistry.getConfigOrDefault("b7a.observability.tracing.name", overallProviderName);
            ServiceLoader<OpenTracer> openTracers = ServiceLoader.load(OpenTracer.class);
            for (OpenTracer openTracer : openTracers) {
                if (!tracerName.equalsIgnoreCase(openTracer.getName())) continue;
                this.tracerGenerator = openTracer;
                break;
            }
            if (this.tracerGenerator != null) {
                try {
                    this.tracerGenerator.init();
                }
                catch (InvalidConfigurationException e) {
                    consoleError.println("error: error in observability tracing configurations: " + e.getMessage());
                }
            } else {
                consoleError.println("error: observability enabled but no tracing extension found for name " + tracerName);
            }
        }
        this.store = new HashMap<String, Tracer>();
    }

    public Tracer getTracer(String serviceName) {
        Tracer openTracer = null;
        if (this.store.containsKey(serviceName)) {
            openTracer = this.store.get(serviceName);
        } else if (this.tracerGenerator != null) {
            try {
                openTracer = this.tracerGenerator.getTracer(serviceName);
                this.store.put(serviceName, openTracer);
            }
            catch (Throwable e) {
                consoleError.println("error: error getting tracer for " + serviceName + " service from " + this.tracerGenerator.getName() + ". " + e.getMessage());
            }
        }
        return openTracer;
    }

    public boolean isInitialized() {
        return this.store != null;
    }
}

