/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.transactions;

import com.atomikos.icatch.jta.UserTransactionManager;
import io.ballerina.runtime.api.async.StrandMetadata;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BFunctionPointer;
import io.ballerina.runtime.internal.scheduling.Scheduler;
import io.ballerina.runtime.internal.scheduling.Strand;
import io.ballerina.runtime.transactions.BallerinaTransactionContext;
import io.ballerina.runtime.transactions.TransactionLocalContext;
import io.ballerina.runtime.transactions.XIDGenerator;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.ballerinalang.config.ConfigRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionResourceManager {
    private static TransactionResourceManager transactionResourceManager = null;
    private static UserTransactionManager userTransactionManager = null;
    private static final StrandMetadata COMMIT_METADATA = new StrandMetadata("ballerina", "lang.transaction", "0.0.1", "onCommit");
    private static final StrandMetadata ROLLBACK_METADATA = new StrandMetadata("ballerina", "lang.transaction", "0.0.1", "onRollback");
    private static final String ATOMIKOS_LOG_BASE_PROPERTY = "com.atomikos.icatch.log_base_dir";
    private static final String ATOMIKOS_LOG_NAME_PROPERTY = "com.atomikos.icatch.log_base_name";
    private static final ConfigRegistry CONFIG_REGISTRY = ConfigRegistry.getInstance();
    private static final Logger log = LoggerFactory.getLogger(TransactionResourceManager.class);
    private Map<String, List<BallerinaTransactionContext>> resourceRegistry;
    private Map<String, Transaction> trxRegistry;
    private Map<String, Xid> xidRegistry;
    private Map<String, List<BFunctionPointer>> committedFuncRegistry;
    private Map<String, List<BFunctionPointer>> abortedFuncRegistry;
    private ConcurrentSkipListSet<String> failedResourceParticipantSet = new ConcurrentSkipListSet();
    private ConcurrentSkipListSet<String> failedLocalParticipantSet = new ConcurrentSkipListSet();
    private ConcurrentHashMap<String, ConcurrentSkipListSet<String>> localParticipants = new ConcurrentHashMap();
    private boolean transactionManagerEnabled;
    private static final PrintStream stderr = System.err;
    public Map<BArray, Object> transactionInfoMap;

    private TransactionResourceManager() {
        this.resourceRegistry = new HashMap<String, List<BallerinaTransactionContext>>();
        this.committedFuncRegistry = new HashMap<String, List<BFunctionPointer>>();
        this.abortedFuncRegistry = new HashMap<String, List<BFunctionPointer>>();
        this.transactionInfoMap = new HashMap<BArray, Object>();
        this.transactionManagerEnabled = this.getTransactionManagerEnabled();
        if (this.transactionManagerEnabled) {
            this.trxRegistry = new HashMap<String, Transaction>();
            this.setLogProperties();
            userTransactionManager = new UserTransactionManager();
        } else {
            this.xidRegistry = new HashMap<String, Xid>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TransactionResourceManager getInstance() {
        if (transactionResourceManager != null) return transactionResourceManager;
        Class<TransactionResourceManager> clazz = TransactionResourceManager.class;
        synchronized (TransactionResourceManager.class) {
            if (transactionResourceManager != null) return transactionResourceManager;
            transactionResourceManager = new TransactionResourceManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return transactionResourceManager;
        }
    }

    private void setLogProperties() {
        Path projectRoot = TransactionResourceManager.findProjectRoot(Paths.get(System.getProperty("user.dir"), new String[0]));
        if (projectRoot != null) {
            String logDir = this.getTransactionLogDirectory();
            String logPath = projectRoot.toAbsolutePath().toString() + "/" + logDir;
            Path transactionLogDirectory = Paths.get(logPath, new String[0]);
            if (!Files.exists(transactionLogDirectory, new LinkOption[0])) {
                try {
                    Files.createDirectory(transactionLogDirectory, new FileAttribute[0]);
                }
                catch (IOException e) {
                    stderr.println("error: failed to create transaction log directory");
                }
            }
            System.setProperty(ATOMIKOS_LOG_BASE_PROPERTY, logPath);
            System.setProperty(ATOMIKOS_LOG_NAME_PROPERTY, "transaction_recovery");
        }
    }

    private boolean getTransactionManagerEnabled() {
        boolean transactionManagerEnabled = CONFIG_REGISTRY.getAsBoolean("b7a.transaction.manager.enabled");
        return transactionManagerEnabled;
    }

    private String getTransactionLogDirectory() {
        String transactionLogDirectory = CONFIG_REGISTRY.getAsString("b7a.transaction.log.base");
        if (transactionLogDirectory != null) {
            return transactionLogDirectory;
        }
        return "transaction_log_dir";
    }

    public void register(String transactionId, String transactionBlockId, BallerinaTransactionContext txContext) {
        String combinedId = this.generateCombinedTransactionId(transactionId, transactionBlockId);
        this.resourceRegistry.computeIfAbsent(combinedId, resourceList -> new ArrayList()).add(txContext);
    }

    public void registerCommittedFunction(String transactionBlockId, BFunctionPointer fpValue) {
        if (fpValue != null) {
            this.committedFuncRegistry.computeIfAbsent(transactionBlockId, list -> new ArrayList()).add(fpValue);
        }
    }

    public void registerAbortedFunction(String transactionBlockId, BFunctionPointer fpValue) {
        if (fpValue != null) {
            this.abortedFuncRegistry.computeIfAbsent(transactionBlockId, list -> new ArrayList()).add(fpValue);
        }
    }

    public void registerParticipation(String gTransactionId, String transactionBlockId) {
        this.localParticipants.computeIfAbsent(gTransactionId, gid -> new ConcurrentSkipListSet()).add(transactionBlockId);
        TransactionLocalContext transactionLocalContext = Scheduler.getStrand().currentTrxContext;
        transactionLocalContext.beginTransactionBlock(transactionBlockId);
    }

    public boolean prepare(String transactionId, String transactionBlockId) {
        if (this.transactionManagerEnabled) {
            return true;
        }
        String combinedId = this.generateCombinedTransactionId(transactionId, transactionBlockId);
        List<BallerinaTransactionContext> txContextList = this.resourceRegistry.get(combinedId);
        if (txContextList != null) {
            Xid xid = this.xidRegistry.get(combinedId);
            for (BallerinaTransactionContext ctx : txContextList) {
                try {
                    XAResource xaResource = ctx.getXAResource();
                    if (xaResource == null) continue;
                    xaResource.prepare(xid);
                }
                catch (XAException e) {
                    log.error("error at transaction prepare phase in transaction " + transactionId + ":" + e.getMessage(), e);
                    return false;
                }
            }
        }
        boolean status = true;
        if (this.failedResourceParticipantSet.contains(transactionId) || this.failedLocalParticipantSet.contains(transactionId)) {
            status = false;
        }
        log.info(String.format("Transaction prepare (participants): %s", status ? "success" : "failed"));
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean notifyCommit(String transactionId, String transactionBlockId) {
        Strand strand = Scheduler.getStrand();
        String combinedId = this.generateCombinedTransactionId(transactionId, transactionBlockId);
        boolean commitSuccess = true;
        List<BallerinaTransactionContext> txContextList = this.resourceRegistry.get(combinedId);
        if (txContextList != null) {
            if (this.transactionManagerEnabled) {
                Transaction trx = this.trxRegistry.get(combinedId);
                try {
                    if (trx != null) {
                        trx.commit();
                    }
                }
                catch (HeuristicMixedException | HeuristicRollbackException | RollbackException | SystemException e) {
                    log.error("error when committing transaction " + transactionId + ":" + e.getMessage(), e);
                    commitSuccess = false;
                }
            }
            for (BallerinaTransactionContext ctx : txContextList) {
                try {
                    XAResource xaResource = ctx.getXAResource();
                    if (this.transactionManagerEnabled) {
                        if (xaResource != null) continue;
                        ctx.commit();
                        continue;
                    }
                    if (xaResource != null) {
                        Xid xid = this.xidRegistry.get(combinedId);
                        xaResource.commit(xid, false);
                        continue;
                    }
                    ctx.commit();
                }
                catch (XAException e) {
                    log.error("error when committing transaction " + transactionId + ":" + e.getMessage(), e);
                    commitSuccess = false;
                }
                finally {
                    ctx.close();
                }
            }
        }
        this.invokeCommittedFunction(strand, transactionId, transactionBlockId);
        this.removeContextsFromRegistry(combinedId, transactionId);
        this.failedResourceParticipantSet.remove(transactionId);
        this.failedLocalParticipantSet.remove(transactionId);
        this.localParticipants.remove(transactionId);
        return commitSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean notifyAbort(String transactionId, String transactionBlockId, Object error) {
        Strand strand = Scheduler.getStrand();
        String combinedId = this.generateCombinedTransactionId(transactionId, transactionBlockId);
        boolean abortSuccess = true;
        List<BallerinaTransactionContext> txContextList = this.resourceRegistry.get(combinedId);
        if (txContextList != null) {
            if (this.transactionManagerEnabled) {
                Transaction trx = this.trxRegistry.get(combinedId);
                try {
                    if (trx != null) {
                        trx.rollback();
                    }
                }
                catch (SystemException e) {
                    log.error("error when aborting transaction " + transactionId + ":" + e.getMessage(), e);
                    abortSuccess = false;
                }
            }
            for (BallerinaTransactionContext ctx : txContextList) {
                try {
                    XAResource xaResource = ctx.getXAResource();
                    if (this.transactionManagerEnabled) {
                        if (xaResource != null) continue;
                        ctx.rollback();
                        continue;
                    }
                    Xid xid = this.xidRegistry.get(combinedId);
                    if (xaResource != null) {
                        ctx.getXAResource().rollback(xid);
                        continue;
                    }
                    ctx.rollback();
                }
                catch (XAException e) {
                    log.error("error when aborting the transaction " + transactionId + ":" + e.getMessage(), e);
                    abortSuccess = false;
                }
                finally {
                    ctx.close();
                }
            }
        }
        this.invokeAbortedFunction(strand, transactionId, transactionBlockId, error);
        this.removeContextsFromRegistry(combinedId, transactionId);
        this.failedResourceParticipantSet.remove(transactionId);
        this.failedLocalParticipantSet.remove(transactionId);
        this.localParticipants.remove(transactionId);
        return abortSuccess;
    }

    public void beginXATransaction(String transactionId, String transactionBlockId, XAResource xaResource) {
        String combinedId = this.generateCombinedTransactionId(transactionId, transactionBlockId);
        if (this.transactionManagerEnabled) {
            Transaction trx = this.trxRegistry.get(combinedId);
            try {
                if (trx == null) {
                    userTransactionManager.begin();
                    trx = userTransactionManager.getTransaction();
                    this.trxRegistry.put(combinedId, trx);
                }
                trx.enlistResource(xaResource);
            }
            catch (NotSupportedException | RollbackException | SystemException e) {
                log.error("error in initiating transaction " + transactionId + ":" + e.getMessage(), e);
            }
        } else {
            Xid xid = this.xidRegistry.get(combinedId);
            if (xid == null) {
                xid = XIDGenerator.createXID();
                this.xidRegistry.put(combinedId, xid);
            }
            try {
                xaResource.start(xid, 0);
            }
            catch (XAException e) {
                log.error("error in starting XA transaction " + transactionId + ":" + e.getMessage(), e);
            }
        }
    }

    public void cleanupTransactionContext() {
        Strand strand = Scheduler.getStrand();
        TransactionLocalContext transactionLocalContext = strand.currentTrxContext;
        transactionLocalContext.removeTransactionInfo();
        strand.removeCurrentTrxContext();
    }

    public boolean getAndClearFailure() {
        return Scheduler.getStrand().currentTrxContext.getAndClearFailure() != null;
    }

    public Object getRollBackOnlyError() {
        TransactionLocalContext transactionLocalContext = Scheduler.getStrand().currentTrxContext;
        return transactionLocalContext.getRollbackOnly();
    }

    public boolean isInTransaction() {
        return Scheduler.getStrand().isInTransaction();
    }

    public void rollbackTransaction(String transactionBlockId, Object error) {
        Scheduler.getStrand().currentTrxContext.rollbackTransaction(transactionBlockId, error);
    }

    public void setContextNonTransactional() {
        Scheduler.getStrand().currentTrxContext.setTransactional(false);
    }

    public void setCurrentTransactionContext(TransactionLocalContext trxCtx) {
        Scheduler.getStrand().setCurrentTransactionContext(trxCtx);
    }

    public TransactionLocalContext getCurrentTransactionContext() {
        return Scheduler.getStrand().currentTrxContext;
    }

    void endXATransaction(String transactionId, String transactionBlockId) {
        block8: {
            List<BallerinaTransactionContext> txContextList;
            String combinedId;
            block7: {
                List<BallerinaTransactionContext> txContextList2;
                combinedId = this.generateCombinedTransactionId(transactionId, transactionBlockId);
                if (!this.transactionManagerEnabled) break block7;
                Transaction trx = this.trxRegistry.get(combinedId);
                if (trx == null || (txContextList2 = this.resourceRegistry.get(combinedId)) == null) break block8;
                for (BallerinaTransactionContext ctx : txContextList2) {
                    try {
                        XAResource xaResource = ctx.getXAResource();
                        if (xaResource == null) continue;
                        trx.delistResource(xaResource, 0x4000000);
                    }
                    catch (IllegalStateException | SystemException e) {
                        log.error("error in ending the XA transaction " + transactionId + ":" + e.getMessage(), e);
                    }
                }
                break block8;
            }
            Xid xid = this.xidRegistry.get(combinedId);
            if (xid != null && (txContextList = this.resourceRegistry.get(combinedId)) != null) {
                for (BallerinaTransactionContext ctx : txContextList) {
                    try {
                        XAResource xaResource = ctx.getXAResource();
                        if (xaResource == null) continue;
                        ctx.getXAResource().end(xid, 0x4000000);
                    }
                    catch (XAException e) {
                        log.error("error in ending XA transaction " + transactionId + ":" + e.getMessage(), e);
                    }
                }
            }
        }
    }

    void rollbackTransaction(String transactionId, String transactionBlockId, Object error) {
        this.endXATransaction(transactionId, transactionBlockId);
        this.notifyAbort(transactionId, transactionBlockId, error);
    }

    private void removeContextsFromRegistry(String transactionCombinedId, String gTransactionId) {
        this.resourceRegistry.remove(transactionCombinedId);
        if (this.transactionManagerEnabled) {
            this.trxRegistry.remove(transactionCombinedId);
        } else {
            this.xidRegistry.remove(transactionCombinedId);
        }
    }

    private String generateCombinedTransactionId(String transactionId, String transactionBlockId) {
        return transactionId + ":" + transactionBlockId;
    }

    private void invokeCommittedFunction(Strand strand, String transactionId, String transactionBlockId) {
        List<BFunctionPointer> fpValueList = this.committedFuncRegistry.get(transactionId);
        if (fpValueList != null) {
            Object[] args = new Object[]{strand, strand.currentTrxContext.getInfoRecord(), true};
            for (int i = fpValueList.size(); i > 0; --i) {
                BFunctionPointer fp = fpValueList.get(i - 1);
                fp.getFunction().apply(args);
            }
        }
    }

    private void invokeAbortedFunction(Strand strand, String transactionId, String transactionBlockId, Object error) {
        List<BFunctionPointer> fpValueList = this.abortedFuncRegistry.get(transactionId);
        if (fpValueList != null) {
            Object[] args = new Object[]{strand, strand.currentTrxContext.getInfoRecord(), true, error, true, false, true};
            for (int i = fpValueList.size(); i > 0; --i) {
                BFunctionPointer fp = fpValueList.get(i - 1);
                fp.getFunction().apply(args);
            }
        }
    }

    public void notifyResourceFailure(String gTransactionId) {
        this.failedResourceParticipantSet.add(gTransactionId);
        log.info("Trx infected callable unit excepted id : " + gTransactionId);
    }

    public void notifyLocalParticipantFailure(String gTransactionId, String blockId) {
        ConcurrentSkipListSet<String> participantBlockIds = this.localParticipants.get(gTransactionId);
        if (participantBlockIds != null && participantBlockIds.contains(blockId)) {
            this.failedLocalParticipantSet.add(gTransactionId);
        }
    }

    private static Path findProjectRoot(Path projectDir) {
        Path path = projectDir.resolve("Ballerina.toml");
        if (Files.exists(path, new LinkOption[0])) {
            return projectDir;
        }
        Path parentsParent = projectDir.getParent();
        if (null != parentsParent) {
            return TransactionResourceManager.findProjectRoot(parentsParent);
        }
        return null;
    }
}

