/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.transactions;

import io.ballerina.runtime.api.PredefinedTypes;
import io.ballerina.runtime.api.async.Callback;
import io.ballerina.runtime.api.async.StrandMetadata;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.internal.scheduling.Scheduler;
import io.ballerina.runtime.internal.scheduling.Strand;
import io.ballerina.runtime.internal.util.exceptions.BallerinaException;
import io.ballerina.runtime.internal.values.FutureValue;
import io.ballerina.runtime.internal.values.MapValue;
import io.ballerina.runtime.internal.values.ObjectValue;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import java.util.function.Function;

public class TransactionUtils {
    private static final StrandMetadata TRX_METADATA = new StrandMetadata("ballerina", "lang.transaction", "0.0.1", "onAbort");

    public static void notifyTransactionAbort(Strand strand, String globalTransactionId, String transactionBlockId) {
        TransactionUtils.executeFunction(strand.scheduler, TransactionUtils.class.getClassLoader(), "ballerina.lang.transaction", "transaction_block", "abortTransaction", globalTransactionId, TRX_METADATA, globalTransactionId, transactionBlockId);
    }

    public static Object executeFunction(Scheduler scheduler, ClassLoader classLoader, String packageName, String className, String methodName, String strandName, StrandMetadata metaData, Object ... paramValues) {
        try {
            Class<?> clazz = classLoader.loadClass(packageName + "." + className);
            int paramCount = paramValues.length * 2 + 1;
            Class[] jvmParamTypes = new Class[paramCount];
            Object[] jvmArgs = new Object[paramCount];
            jvmParamTypes[0] = Strand.class;
            jvmArgs[0] = scheduler;
            int j = 1;
            for (int i = 0; i < paramValues.length; ++i) {
                jvmArgs[j] = paramValues[i];
                jvmParamTypes[j++] = TransactionUtils.getJvmType(paramValues[i]);
                jvmArgs[j] = true;
                jvmParamTypes[j++] = Boolean.TYPE;
            }
            Method method = clazz.getDeclaredMethod(methodName, jvmParamTypes);
            Function<Object[], Object> func = args -> {
                try {
                    return method.invoke(null, args);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new BallerinaException(methodName + " function invocation failed: " + e.getMessage());
                }
            };
            final CountDownLatch completeFunction = new CountDownLatch(1);
            FutureValue futureValue = scheduler.schedule(jvmArgs, func, null, new Callback(){

                @Override
                public void notifySuccess(Object result) {
                    completeFunction.countDown();
                }

                @Override
                public void notifyFailure(BError error) {
                    completeFunction.countDown();
                }
            }, new HashMap<String, Object>(), PredefinedTypes.TYPE_ANY, strandName, metaData);
            completeFunction.await();
            return futureValue.result;
        }
        catch (ClassNotFoundException | InterruptedException | NoSuchMethodException e) {
            throw new BallerinaException("invocation failed: " + e.getMessage());
        }
    }

    private static Class<?> getJvmType(Object paramValue) {
        if (paramValue instanceof MapValue) {
            return MapValue.class;
        }
        if (paramValue instanceof ObjectValue) {
            return ObjectValue.class;
        }
        if (paramValue instanceof Boolean) {
            return Boolean.TYPE;
        }
        if (paramValue instanceof String) {
            return String.class;
        }
        throw new RuntimeException("unknown param type: " + paramValue.getClass());
    }
}

