/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.toml.internal.parser;

import io.ballerina.toml.internal.diagnostics.DiagnosticCode;
import io.ballerina.toml.internal.parser.ParserMode;
import io.ballerina.toml.internal.parser.SyntaxErrors;
import io.ballerina.toml.internal.parser.tree.STNode;
import io.ballerina.toml.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.toml.internal.parser.tree.STNodeFactory;
import io.ballerina.toml.internal.parser.tree.STToken;
import io.ballerina.tools.text.CharReader;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class AbstractLexer {
    protected static final int INITIAL_TRIVIA_CAPACITY = 10;
    protected List<STNode> leadingTriviaList = new ArrayList<STNode>(10);
    private Collection<STNodeDiagnostic> diagnostics = new ArrayList<STNodeDiagnostic>();
    protected CharReader reader;
    protected ParserMode mode;
    protected ArrayDeque<ParserMode> modeStack = new ArrayDeque();

    public AbstractLexer(CharReader charReader, ParserMode initialParserMode) {
        this.reader = charReader;
        this.startMode(initialParserMode);
    }

    public abstract STToken nextToken();

    public void reset(int offset) {
        this.reader.reset(offset);
    }

    public void startMode(ParserMode mode) {
        this.mode = mode;
        this.modeStack.push(mode);
    }

    public void switchMode(ParserMode mode) {
        this.modeStack.pop();
        this.mode = mode;
        this.modeStack.push(mode);
    }

    public void endMode() {
        this.modeStack.pop();
        this.mode = this.modeStack.peek();
    }

    private void resetDiagnosticList() {
        this.diagnostics = new ArrayList<STNodeDiagnostic>();
    }

    private boolean noDiagnostics() {
        return this.diagnostics.isEmpty();
    }

    private Collection<STNodeDiagnostic> getDiagnostics() {
        return this.diagnostics;
    }

    protected STToken cloneWithDiagnostics(STToken toClone) {
        if (this.noDiagnostics()) {
            return toClone;
        }
        STToken cloned = SyntaxErrors.addSyntaxDiagnostics(toClone, this.getDiagnostics());
        this.resetDiagnosticList();
        return cloned;
    }

    protected void reportLexerError(DiagnosticCode diagnosticCode, Object ... args) {
        this.diagnostics.add(SyntaxErrors.createDiagnostic(diagnosticCode, args));
    }

    protected STNode getLeadingTrivia() {
        STNode trivia = STNodeFactory.createNodeList(this.leadingTriviaList);
        this.leadingTriviaList = new ArrayList<STNode>(10);
        return trivia;
    }
}

