/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.toml.internal.parser;

import io.ballerina.toml.internal.parser.AbstractLexer;
import io.ballerina.toml.internal.parser.AbstractTokenReader;
import io.ballerina.toml.internal.parser.ParserMode;
import io.ballerina.toml.internal.parser.tree.STToken;

public class TokenReader
extends AbstractTokenReader {
    private static final int BUFFER_SIZE = 20;
    private AbstractLexer lexer;
    private TokenBuffer tokensAhead = new TokenBuffer(20);
    private STToken currentToken = null;

    TokenReader(AbstractLexer lexer) {
        this.lexer = lexer;
    }

    @Override
    public STToken read() {
        if (this.tokensAhead.size > 0) {
            this.currentToken = this.tokensAhead.consume();
            return this.currentToken;
        }
        this.currentToken = this.lexer.nextToken();
        return this.currentToken;
    }

    @Override
    public STToken peek() {
        if (this.tokensAhead.size > 0) {
            return this.tokensAhead.peek();
        }
        STToken token = this.lexer.nextToken();
        this.tokensAhead.add(token);
        return token;
    }

    @Override
    public STToken peek(int k) {
        while (this.tokensAhead.size < k) {
            STToken nextToken = this.lexer.nextToken();
            this.tokensAhead.add(nextToken);
        }
        return this.tokensAhead.peek(k);
    }

    @Override
    public STToken head() {
        return this.currentToken;
    }

    @Override
    public void startMode(ParserMode mode) {
        this.lexer.startMode(mode);
    }

    @Override
    public void endMode() {
        this.lexer.endMode();
    }

    @Override
    public int getCurrentTokenIndex() {
        return this.tokensAhead.getCurrentTokenIndex();
    }

    private static class TokenBuffer {
        private final int capacity;
        private final STToken[] tokens;
        private int endIndex = -1;
        private int startIndex = -1;
        private int size = 0;

        TokenBuffer(int size) {
            this.capacity = size;
            this.tokens = new STToken[size];
        }

        public void add(STToken token) {
            if (this.size == this.capacity) {
                throw new IndexOutOfBoundsException("buffer overflow");
            }
            this.endIndex = this.endIndex == this.capacity - 1 ? 0 : ++this.endIndex;
            if (this.size == 0) {
                this.startIndex = this.endIndex;
            }
            this.tokens[this.endIndex] = token;
            ++this.size;
        }

        public STToken consume() {
            STToken token = this.tokens[this.startIndex];
            --this.size;
            this.startIndex = this.startIndex == this.capacity - 1 ? 0 : ++this.startIndex;
            return token;
        }

        public STToken peek() {
            return this.tokens[this.startIndex];
        }

        public STToken peek(int k) {
            if (k > this.size) {
                throw new IndexOutOfBoundsException("size: " + this.size + ", index: " + k);
            }
            int index = this.startIndex + k - 1;
            if (index >= this.capacity) {
                index -= this.capacity;
            }
            return this.tokens[index];
        }

        public int getCurrentTokenIndex() {
            return this.startIndex;
        }
    }
}

