/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.toml.internal.parser.tree;

import io.ballerina.toml.internal.parser.tree.STNode;
import io.ballerina.toml.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.toml.internal.parser.tree.STNodeTransformer;
import io.ballerina.toml.internal.parser.tree.STToken;
import io.ballerina.toml.syntax.tree.IdentifierToken;
import io.ballerina.toml.syntax.tree.Node;
import io.ballerina.toml.syntax.tree.NonTerminalNode;
import io.ballerina.toml.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STDocumentationLineToken
extends STToken {
    private final String text;

    STDocumentationLineToken(String text, STNode leadingTrivia, STNode trailingTrivia) {
        this(text, leadingTrivia, trailingTrivia, Collections.emptyList());
    }

    STDocumentationLineToken(String text, STNode leadingTrivia, STNode trailingTrivia, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.MARKDOWN_DOCUMENTATION_LINE, text.length(), leadingTrivia, trailingTrivia, diagnostics);
        this.text = text;
    }

    @Override
    public String text() {
        return this.text;
    }

    @Override
    public STToken modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STDocumentationLineToken(this.text, this.leadingMinutiae, this.trailingMinutiae, diagnostics);
    }

    @Override
    public STToken modifyWith(STNode leadingMinutiae, STNode trailingMinutiae) {
        return new STDocumentationLineToken(this.text, leadingMinutiae, trailingMinutiae, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new IdentifierToken(this, position, parent);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }

    @Override
    public String toString() {
        return this.leadingMinutiae + this.text + this.trailingMinutiae;
    }

    @Override
    public void writeTo(StringBuilder builder) {
        this.leadingMinutiae.writeTo(builder);
        builder.append(this.text);
        this.trailingMinutiae.writeTo(builder);
    }
}

