/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.toml.internal.parser.tree;

import io.ballerina.toml.internal.parser.tree.STDocumentMemberDeclarationNode;
import io.ballerina.toml.internal.parser.tree.STNode;
import io.ballerina.toml.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.toml.internal.parser.tree.STNodeTransformer;
import io.ballerina.toml.internal.parser.tree.STNodeVisitor;
import io.ballerina.toml.syntax.tree.Node;
import io.ballerina.toml.syntax.tree.NonTerminalNode;
import io.ballerina.toml.syntax.tree.SyntaxKind;
import io.ballerina.toml.syntax.tree.TableNode;
import java.util.Collection;
import java.util.Collections;

public class STTableNode
extends STDocumentMemberDeclarationNode {
    public final STNode openBracket;
    public final STNode identifier;
    public final STNode closeBracket;
    public final STNode fields;

    STTableNode(STNode openBracket, STNode identifier, STNode closeBracket, STNode fields) {
        this(openBracket, identifier, closeBracket, fields, Collections.emptyList());
    }

    STTableNode(STNode openBracket, STNode identifier, STNode closeBracket, STNode fields, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.TABLE, diagnostics);
        this.openBracket = openBracket;
        this.identifier = identifier;
        this.closeBracket = closeBracket;
        this.fields = fields;
        this.addChildren(openBracket, identifier, closeBracket, fields);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STTableNode(this.openBracket, this.identifier, this.closeBracket, this.fields, diagnostics);
    }

    public STTableNode modify(STNode openBracket, STNode identifier, STNode closeBracket, STNode fields) {
        if (this.checkForReferenceEquality(openBracket, identifier, closeBracket, fields)) {
            return this;
        }
        return new STTableNode(openBracket, identifier, closeBracket, fields, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new TableNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

