/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.toml.semantic.ast;

import io.ballerina.toml.semantic.TomlType;
import io.ballerina.toml.semantic.ast.Node;
import io.ballerina.toml.semantic.ast.TomlNodeVisitor;
import io.ballerina.toml.semantic.diagnostics.DiagnosticComparator;
import io.ballerina.toml.semantic.diagnostics.TomlNodeLocation;
import io.ballerina.tools.diagnostics.Diagnostic;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public abstract class TomlNode
implements Node {
    private final TomlType kind;
    private final TomlNodeLocation location;
    protected Set<Diagnostic> diagnostics;

    public TomlNode(TomlType kind, TomlNodeLocation location) {
        this.kind = kind;
        this.location = location;
        this.diagnostics = new TreeSet<Diagnostic>(new DiagnosticComparator());
    }

    public abstract void accept(TomlNodeVisitor var1);

    public Set<Diagnostic> diagnostics() {
        return this.diagnostics;
    }

    public void addDiagnostic(Diagnostic diagnostic) {
        this.diagnostics.add(diagnostic);
    }

    public void addDiagnostics(List<Diagnostic> diagnostics) {
        this.diagnostics.addAll(diagnostics);
    }

    @Override
    public TomlNodeLocation location() {
        return this.location;
    }

    @Override
    public TomlType kind() {
        return this.kind;
    }
}

